/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.Principal;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.sql.DataSource;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.realm.RealmBase;
import org.apache.naming.ContextBindings;

public class DataSourceRealm
extends RealmBase {
    private String preparedRoles = null;
    private String preparedCredentials = null;
    protected String dataSourceName = null;
    protected boolean localDataSource = false;
    protected String roleNameCol = null;
    protected String userCredCol = null;
    protected String userNameCol = null;
    protected String userRoleTable = null;
    protected String userTable = null;
    private volatile boolean connectionSuccess = true;

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String string) {
        this.dataSourceName = string;
    }

    public boolean getLocalDataSource() {
        return this.localDataSource;
    }

    public void setLocalDataSource(boolean bl) {
        this.localDataSource = bl;
    }

    public String getRoleNameCol() {
        return this.roleNameCol;
    }

    public void setRoleNameCol(String string) {
        this.roleNameCol = string;
    }

    public String getUserCredCol() {
        return this.userCredCol;
    }

    public void setUserCredCol(String string) {
        this.userCredCol = string;
    }

    public String getUserNameCol() {
        return this.userNameCol;
    }

    public void setUserNameCol(String string) {
        this.userNameCol = string;
    }

    public String getUserRoleTable() {
        return this.userRoleTable;
    }

    public void setUserRoleTable(String string) {
        this.userRoleTable = string;
    }

    public String getUserTable() {
        return this.userTable;
    }

    public void setUserTable(String string) {
        this.userTable = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Principal authenticate(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            Principal principal = this.authenticate(connection, string, string2);
            return principal;
        }
        finally {
            this.close(connection);
        }
    }

    @Override
    public boolean isAvailable() {
        return this.connectionSuccess;
    }

    protected Principal authenticate(Connection connection, String string, String string2) {
        if (string == null || string2 == null) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        String string3 = this.getPassword(connection, string);
        if (string3 == null) {
            this.getCredentialHandler().mutate(string2);
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        boolean bl = this.getCredentialHandler().matches(string2, string3);
        if (bl) {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateSuccess", new Object[]{string}));
            }
        } else {
            if (this.containerLog.isTraceEnabled()) {
                this.containerLog.trace((Object)sm.getString("dataSourceRealm.authenticateFailure", new Object[]{string}));
            }
            return null;
        }
        ArrayList<String> arrayList = this.getRoles(connection, string);
        return new GenericPrincipal(string, arrayList);
    }

    protected void close(Connection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)"Exception committing connection before closing:", (Throwable)sQLException);
        }
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            this.containerLog.error((Object)sm.getString("dataSourceRealm.close"), (Throwable)sQLException);
        }
    }

    protected Connection open() {
        try {
            Context context = null;
            if (this.localDataSource) {
                context = ContextBindings.getClassLoader();
                context = (Context)context.lookup("comp/env");
            } else {
                context = this.getServer().getGlobalNamingContext();
            }
            DataSource dataSource = (DataSource)context.lookup(this.dataSourceName);
            Connection connection = dataSource.getConnection();
            this.connectionSuccess = true;
            return connection;
        }
        catch (Exception exception) {
            this.connectionSuccess = false;
            this.containerLog.error((Object)sm.getString("dataSourceRealm.exception"), (Throwable)exception);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String getPassword(String string) {
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            String string2 = this.getPassword(connection, string);
            return string2;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * Exception decompiling
     */
    protected String getPassword(Connection var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Principal getPrincipal(String string) {
        Connection connection = this.open();
        if (connection == null) {
            return new GenericPrincipal(string, null);
        }
        try {
            GenericPrincipal genericPrincipal = new GenericPrincipal(string, this.getRoles(connection, string));
            return genericPrincipal;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<String> getRoles(String string) {
        Connection connection = null;
        connection = this.open();
        if (connection == null) {
            return null;
        }
        try {
            ArrayList<String> arrayList = this.getRoles(connection, string);
            return arrayList;
        }
        finally {
            this.close(connection);
        }
    }

    /*
     * Exception decompiling
     */
    protected ArrayList<String> getRoles(Connection var1_1, String var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isRoleStoreDefined() {
        return this.userRoleTable != null || this.roleNameCol != null;
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringBuilder stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.roleNameCol);
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.userRoleTable);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.userNameCol);
        stringBuilder.append(" = ?");
        this.preparedRoles = stringBuilder.toString();
        stringBuilder = new StringBuilder("SELECT ");
        stringBuilder.append(this.userCredCol);
        stringBuilder.append(" FROM ");
        stringBuilder.append(this.userTable);
        stringBuilder.append(" WHERE ");
        stringBuilder.append(this.userNameCol);
        stringBuilder.append(" = ?");
        this.preparedCredentials = stringBuilder.toString();
        super.startInternal();
    }
}

