/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

abstract class AbstractStream {
    private static final Log log = LogFactory.getLog(AbstractStream.class);
    private static final StringManager sm = StringManager.getManager(AbstractStream.class);
    private final Integer identifier;
    private final String idAsString;
    private volatile AbstractStream parentStream = null;
    private final Set<AbstractNonZeroStream> childStreams = Collections.newSetFromMap(new ConcurrentHashMap());
    private long windowSize = 65535L;

    public AbstractStream(Integer n) {
        this.identifier = n;
        this.idAsString = n.toString();
    }

    public Integer getIdentifier() {
        return this.identifier;
    }

    final String getIdAsString() {
        return this.idAsString;
    }

    public int getIdAsInt() {
        return this.identifier;
    }

    void detachFromParent() {
        if (this.parentStream != null) {
            this.parentStream.getChildStreams().remove(this);
            this.parentStream = null;
        }
    }

    final void addChild(AbstractNonZeroStream abstractNonZeroStream) {
        abstractNonZeroStream.setParentStream(this);
        this.childStreams.add(abstractNonZeroStream);
    }

    boolean isDescendant(AbstractStream abstractStream) {
        AbstractStream abstractStream2;
        for (abstractStream2 = abstractStream.getParentStream(); abstractStream2 != null && abstractStream2 != this; abstractStream2 = abstractStream2.getParentStream()) {
        }
        return abstractStream2 != null;
    }

    AbstractStream getParentStream() {
        return this.parentStream;
    }

    void setParentStream(AbstractStream abstractStream) {
        this.parentStream = abstractStream;
    }

    final Set<AbstractNonZeroStream> getChildStreams() {
        return this.childStreams;
    }

    protected synchronized void setWindowSize(long l) {
        this.windowSize = l;
    }

    protected synchronized long getWindowSize() {
        return this.windowSize;
    }

    protected synchronized void incrementWindowSize(int n) throws Http2Exception {
        this.windowSize += (long)n;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("abstractStream.windowSizeInc", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(n), Long.toString(this.windowSize)}));
        }
        if (this.windowSize > Integer.MAX_VALUE) {
            String string = sm.getString("abstractStream.windowSizeTooBig", new Object[]{this.getConnectionId(), this.identifier, Integer.toString(n), Long.toString(this.windowSize)});
            if (this.identifier == 0) {
                throw new ConnectionException(string, Http2Error.FLOW_CONTROL_ERROR);
            }
            throw new StreamException(string, Http2Error.FLOW_CONTROL_ERROR, this.identifier);
        }
    }

    protected synchronized void decrementWindowSize(int n) {
        this.windowSize -= (long)n;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("abstractStream.windowSizeDec", new Object[]{this.getConnectionId(), this.getIdAsString(), Integer.toString(n), Long.toString(this.windowSize)}));
        }
    }

    protected abstract String getConnectionId();

    protected abstract int getWeight();

    @Deprecated
    protected abstract void doNotifyAll();
}

