/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.util;

import java.security.AccessController;

public class Validation {
    private static final String[] invalidIdentifiers = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "false", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "null", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throw", "throws", "transient", "true", "try", "void", "volatile", "while"};
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    private static final boolean SKIP_IDENTIFIER_CHECK;

    private Validation() {
    }

    public static boolean isIdentifier(String string) {
        int n;
        if (SKIP_IDENTIFIER_CHECK) {
            return true;
        }
        if (string == null || string.length() == 0) {
            return false;
        }
        int n2 = 0;
        int n3 = invalidIdentifiers.length;
        while (n2 < n3) {
            n = n2 + n3 >>> 1;
            int n4 = invalidIdentifiers[n].compareTo(string);
            if (n4 == 0) {
                return false;
            }
            if (n4 < 0) {
                n2 = n + 1;
                continue;
            }
            n3 = n;
        }
        if (!Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (n = 1; n < string.length(); ++n) {
            if (Character.isJavaIdentifierPart(string.charAt(n))) continue;
            return false;
        }
        return true;
    }

    static {
        String string = IS_SECURITY_ENABLED ? AccessController.doPrivileged(() -> System.getProperty("org.apache.el.parser.SKIP_IDENTIFIER_CHECK", "false")) : System.getProperty("org.apache.el.parser.SKIP_IDENTIFIER_CHECK", "false");
        SKIP_IDENTIFIER_CHECK = Boolean.parseBoolean(string);
    }
}

