/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.coyote.http2.Hpack;
import org.apache.coyote.http2.HpackException;
import org.apache.tomcat.util.res.StringManager;

public class HPackHuffman {
    protected static final StringManager sm = StringManager.getManager(HPackHuffman.class);
    private static final HuffmanCode[] HUFFMAN_CODES;
    private static final int[] DECODING_TABLE;
    private static final int LOW_TERMINAL_BIT = 32768;
    private static final int HIGH_TERMINAL_BIT = Integer.MIN_VALUE;
    private static final int LOW_MASK = Short.MAX_VALUE;

    public static void decode(ByteBuffer byteBuffer, int n, StringBuilder stringBuilder) throws HpackException {
        assert (byteBuffer.remaining() >= n);
        int n2 = 0;
        boolean bl = true;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byteBuffer.get();
            for (int j = 7; j >= 0; --j) {
                int n4 = DECODING_TABLE[n2];
                if ((1 << j & by) == 0) {
                    if ((n4 & 0x8000) == 0) {
                        n2 = n4 & Short.MAX_VALUE;
                        bl = false;
                        n3 = 0;
                        continue;
                    }
                    stringBuilder.append((char)(n4 & Short.MAX_VALUE));
                    n2 = 0;
                    bl = true;
                    continue;
                }
                if (bl) {
                    ++n3;
                }
                if ((n4 & Integer.MIN_VALUE) == 0) {
                    n2 = n4 >> 16 & Short.MAX_VALUE;
                    continue;
                }
                if (n3 != 0) {
                    throw new HpackException(sm.getString("hpackhuffman.stringLiteralEOS"));
                }
                stringBuilder.append((char)(n4 >> 16 & Short.MAX_VALUE));
                n2 = 0;
                bl = true;
            }
        }
        if (n3 > 7) {
            throw new HpackException(sm.getString("hpackhuffman.stringLiteralTooMuchPadding"));
        }
        if (!bl) {
            throw new HpackException(sm.getString("hpackhuffman.huffmanEncodedHpackValueDidNotEndWithEOS"));
        }
    }

    public static boolean encode(ByteBuffer byteBuffer, String string, boolean bl) {
        int n;
        int n2;
        if (byteBuffer.remaining() <= string.length()) {
            return false;
        }
        int n3 = byteBuffer.position();
        int n4 = 0;
        for (n2 = 0; n2 < string.length(); ++n2) {
            n = string.charAt(n2);
            if (n > 255) {
                throw new IllegalArgumentException(sm.getString("hpack.invalidCharacter", new Object[]{Character.toString((char)n), n}));
            }
            if (bl) {
                n = Hpack.toLower((char)n);
            }
            HuffmanCode huffmanCode = HUFFMAN_CODES[n];
            n4 += huffmanCode.length;
        }
        n2 = n4 / 8 + (n4 % 8 == 0 ? 0 : 1);
        byteBuffer.put((byte)-128);
        Hpack.encodeInteger(byteBuffer, n2, 7);
        n = 0;
        byte by = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (bl) {
                c = Hpack.toLower(c);
            }
            HuffmanCode huffmanCode = HUFFMAN_CODES[c];
            if (huffmanCode.length + n <= 8) {
                by = (byte)(by | (huffmanCode.value & 0xFF) << 8 - (huffmanCode.length + n));
                n += huffmanCode.length;
            } else {
                int n5;
                int n6 = huffmanCode.value;
                for (int j = huffmanCode.length; j > 0; j -= n5) {
                    if (!byteBuffer.hasRemaining()) {
                        byteBuffer.position(n3);
                        return false;
                    }
                    n5 = 8 - n;
                    by = j > n5 ? (byte)(by | n6 >> j - n5) : (byte)(by | n6 << n5 - j);
                    if (j > n5) {
                        byteBuffer.put(by);
                        by = 0;
                        n = 0;
                        continue;
                    }
                    n = j;
                }
            }
            if (n == 8) {
                if (!byteBuffer.hasRemaining()) {
                    byteBuffer.position(n3);
                    return false;
                }
                byteBuffer.put(by);
                by = 0;
                n = 0;
            }
            if (byteBuffer.position() - n3 <= string.length()) continue;
            byteBuffer.position(n3);
            return false;
        }
        if (n > 0) {
            if (!byteBuffer.hasRemaining()) {
                byteBuffer.position(n3);
                return false;
            }
            byteBuffer.put((byte)(by | 255 >> n));
        }
        return true;
    }

    static {
        HuffmanCode[] huffmanCodeArray = new HuffmanCode[]{new HuffmanCode(8184, 13), new HuffmanCode(8388568, 23), new HuffmanCode(0xFFFFFE2, 28), new HuffmanCode(0xFFFFFE3, 28), new HuffmanCode(0xFFFFFE4, 28), new HuffmanCode(0xFFFFFE5, 28), new HuffmanCode(0xFFFFFE6, 28), new HuffmanCode(0xFFFFFE7, 28), new HuffmanCode(0xFFFFFE8, 28), new HuffmanCode(0xFFFFEA, 24), new HuffmanCode(0x3FFFFFFC, 30), new HuffmanCode(0xFFFFFE9, 28), new HuffmanCode(0xFFFFFEA, 28), new HuffmanCode(0x3FFFFFFD, 30), new HuffmanCode(0xFFFFFEB, 28), new HuffmanCode(0xFFFFFEC, 28), new HuffmanCode(0xFFFFFED, 28), new HuffmanCode(0xFFFFFEE, 28), new HuffmanCode(0xFFFFFEF, 28), new HuffmanCode(0xFFFFFF0, 28), new HuffmanCode(0xFFFFFF1, 28), new HuffmanCode(0xFFFFFF2, 28), new HuffmanCode(0x3FFFFFFE, 30), new HuffmanCode(0xFFFFFF3, 28), new HuffmanCode(0xFFFFFF4, 28), new HuffmanCode(0xFFFFFF5, 28), new HuffmanCode(0xFFFFFF6, 28), new HuffmanCode(0xFFFFFF7, 28), new HuffmanCode(0xFFFFFF8, 28), new HuffmanCode(0xFFFFFF9, 28), new HuffmanCode(0xFFFFFFA, 28), new HuffmanCode(0xFFFFFFB, 28), new HuffmanCode(20, 6), new HuffmanCode(1016, 10), new HuffmanCode(1017, 10), new HuffmanCode(4090, 12), new HuffmanCode(8185, 13), new HuffmanCode(21, 6), new HuffmanCode(248, 8), new HuffmanCode(2042, 11), new HuffmanCode(1018, 10), new HuffmanCode(1019, 10), new HuffmanCode(249, 8), new HuffmanCode(2043, 11), new HuffmanCode(250, 8), new HuffmanCode(22, 6), new HuffmanCode(23, 6), new HuffmanCode(24, 6), new HuffmanCode(0, 5), new HuffmanCode(1, 5), new HuffmanCode(2, 5), new HuffmanCode(25, 6), new HuffmanCode(26, 6), new HuffmanCode(27, 6), new HuffmanCode(28, 6), new HuffmanCode(29, 6), new HuffmanCode(30, 6), new HuffmanCode(31, 6), new HuffmanCode(92, 7), new HuffmanCode(251, 8), new HuffmanCode(32764, 15), new HuffmanCode(32, 6), new HuffmanCode(4091, 12), new HuffmanCode(1020, 10), new HuffmanCode(8186, 13), new HuffmanCode(33, 6), new HuffmanCode(93, 7), new HuffmanCode(94, 7), new HuffmanCode(95, 7), new HuffmanCode(96, 7), new HuffmanCode(97, 7), new HuffmanCode(98, 7), new HuffmanCode(99, 7), new HuffmanCode(100, 7), new HuffmanCode(101, 7), new HuffmanCode(102, 7), new HuffmanCode(103, 7), new HuffmanCode(104, 7), new HuffmanCode(105, 7), new HuffmanCode(106, 7), new HuffmanCode(107, 7), new HuffmanCode(108, 7), new HuffmanCode(109, 7), new HuffmanCode(110, 7), new HuffmanCode(111, 7), new HuffmanCode(112, 7), new HuffmanCode(113, 7), new HuffmanCode(114, 7), new HuffmanCode(252, 8), new HuffmanCode(115, 7), new HuffmanCode(253, 8), new HuffmanCode(8187, 13), new HuffmanCode(524272, 19), new HuffmanCode(8188, 13), new HuffmanCode(16380, 14), new HuffmanCode(34, 6), new HuffmanCode(32765, 15), new HuffmanCode(3, 5), new HuffmanCode(35, 6), new HuffmanCode(4, 5), new HuffmanCode(36, 6), new HuffmanCode(5, 5), new HuffmanCode(37, 6), new HuffmanCode(38, 6), new HuffmanCode(39, 6), new HuffmanCode(6, 5), new HuffmanCode(116, 7), new HuffmanCode(117, 7), new HuffmanCode(40, 6), new HuffmanCode(41, 6), new HuffmanCode(42, 6), new HuffmanCode(7, 5), new HuffmanCode(43, 6), new HuffmanCode(118, 7), new HuffmanCode(44, 6), new HuffmanCode(8, 5), new HuffmanCode(9, 5), new HuffmanCode(45, 6), new HuffmanCode(119, 7), new HuffmanCode(120, 7), new HuffmanCode(121, 7), new HuffmanCode(122, 7), new HuffmanCode(123, 7), new HuffmanCode(32766, 15), new HuffmanCode(2044, 11), new HuffmanCode(16381, 14), new HuffmanCode(8189, 13), new HuffmanCode(0xFFFFFFC, 28), new HuffmanCode(1048550, 20), new HuffmanCode(4194258, 22), new HuffmanCode(1048551, 20), new HuffmanCode(1048552, 20), new HuffmanCode(0x3FFFD3, 22), new HuffmanCode(4194260, 22), new HuffmanCode(4194261, 22), new HuffmanCode(8388569, 23), new HuffmanCode(4194262, 22), new HuffmanCode(8388570, 23), new HuffmanCode(8388571, 23), new HuffmanCode(8388572, 23), new HuffmanCode(0x7FFFDD, 23), new HuffmanCode(8388574, 23), new HuffmanCode(0xFFFFEB, 24), new HuffmanCode(0x7FFFDF, 23), new HuffmanCode(0xFFFFEC, 24), new HuffmanCode(0xFFFFED, 24), new HuffmanCode(4194263, 22), new HuffmanCode(8388576, 23), new HuffmanCode(0xFFFFEE, 24), new HuffmanCode(8388577, 23), new HuffmanCode(8388578, 23), new HuffmanCode(8388579, 23), new HuffmanCode(8388580, 23), new HuffmanCode(2097116, 21), new HuffmanCode(4194264, 22), new HuffmanCode(8388581, 23), new HuffmanCode(4194265, 22), new HuffmanCode(8388582, 23), new HuffmanCode(0x7FFFE7, 23), new HuffmanCode(0xFFFFEF, 24), new HuffmanCode(4194266, 22), new HuffmanCode(0x1FFFDD, 21), new HuffmanCode(1048553, 20), new HuffmanCode(4194267, 22), new HuffmanCode(4194268, 22), new HuffmanCode(8388584, 23), new HuffmanCode(8388585, 23), new HuffmanCode(2097118, 21), new HuffmanCode(8388586, 23), new HuffmanCode(0x3FFFDD, 22), new HuffmanCode(4194270, 22), new HuffmanCode(0xFFFFF0, 24), new HuffmanCode(0x1FFFDF, 21), new HuffmanCode(0x3FFFDF, 22), new HuffmanCode(8388587, 23), new HuffmanCode(8388588, 23), new HuffmanCode(2097120, 21), new HuffmanCode(0x1FFFE1, 21), new HuffmanCode(4194272, 22), new HuffmanCode(2097122, 21), new HuffmanCode(8388589, 23), new HuffmanCode(4194273, 22), new HuffmanCode(0x7FFFEE, 23), new HuffmanCode(0x7FFFEF, 23), new HuffmanCode(1048554, 20), new HuffmanCode(4194274, 22), new HuffmanCode(0x3FFFE3, 22), new HuffmanCode(4194276, 22), new HuffmanCode(0x7FFFF0, 23), new HuffmanCode(4194277, 22), new HuffmanCode(4194278, 22), new HuffmanCode(0x7FFFF1, 23), new HuffmanCode(67108832, 26), new HuffmanCode(67108833, 26), new HuffmanCode(1048555, 20), new HuffmanCode(524273, 19), new HuffmanCode(4194279, 22), new HuffmanCode(0x7FFFF2, 23), new HuffmanCode(4194280, 22), new HuffmanCode(33554412, 25), new HuffmanCode(67108834, 26), new HuffmanCode(0x3FFFFE3, 26), new HuffmanCode(67108836, 26), new HuffmanCode(134217694, 27), new HuffmanCode(0x7FFFFDF, 27), new HuffmanCode(67108837, 26), new HuffmanCode(0xFFFFF1, 24), new HuffmanCode(33554413, 25), new HuffmanCode(524274, 19), new HuffmanCode(2097123, 21), new HuffmanCode(67108838, 26), new HuffmanCode(134217696, 27), new HuffmanCode(134217697, 27), new HuffmanCode(67108839, 26), new HuffmanCode(134217698, 27), new HuffmanCode(0xFFFFF2, 24), new HuffmanCode(2097124, 21), new HuffmanCode(2097125, 21), new HuffmanCode(67108840, 26), new HuffmanCode(67108841, 26), new HuffmanCode(0xFFFFFFD, 28), new HuffmanCode(134217699, 27), new HuffmanCode(134217700, 27), new HuffmanCode(134217701, 27), new HuffmanCode(1048556, 20), new HuffmanCode(0xFFFFF3, 24), new HuffmanCode(1048557, 20), new HuffmanCode(2097126, 21), new HuffmanCode(4194281, 22), new HuffmanCode(2097127, 21), new HuffmanCode(2097128, 21), new HuffmanCode(0x7FFFF3, 23), new HuffmanCode(4194282, 22), new HuffmanCode(4194283, 22), new HuffmanCode(0x1FFFFEE, 25), new HuffmanCode(0x1FFFFEF, 25), new HuffmanCode(0xFFFFF4, 24), new HuffmanCode(0xFFFFF5, 24), new HuffmanCode(67108842, 26), new HuffmanCode(0x7FFFF4, 23), new HuffmanCode(67108843, 26), new HuffmanCode(134217702, 27), new HuffmanCode(67108844, 26), new HuffmanCode(67108845, 26), new HuffmanCode(0x7FFFFE7, 27), new HuffmanCode(134217704, 27), new HuffmanCode(134217705, 27), new HuffmanCode(134217706, 27), new HuffmanCode(134217707, 27), new HuffmanCode(0xFFFFFFE, 28), new HuffmanCode(134217708, 27), new HuffmanCode(134217709, 27), new HuffmanCode(0x7FFFFEE, 27), new HuffmanCode(0x7FFFFEF, 27), new HuffmanCode(0x7FFFFF0, 27), new HuffmanCode(0x3FFFFEE, 26), new HuffmanCode(0x3FFFFFFF, 30)};
        HUFFMAN_CODES = huffmanCodeArray;
        int[] nArray = new int[256];
        int n = 0;
        int n2 = 1;
        HuffmanCode[] huffmanCodeArray2 = new HuffmanCode[256];
        huffmanCodeArray2[0] = new HuffmanCode(0, 0);
        HashSet<HuffmanCode> hashSet = new HashSet<HuffmanCode>(Arrays.asList(HUFFMAN_CODES));
        while (!hashSet.isEmpty()) {
            int n3;
            int n4;
            int n5 = huffmanCodeArray2[n].length;
            int n6 = huffmanCodeArray2[n].value;
            int n7 = n5 + 1;
            HuffmanCode huffmanCode = new HuffmanCode(n6 << 1 | 1, n7);
            HuffmanCode huffmanCode2 = new HuffmanCode(n6 << 1, n7);
            int n8 = 0;
            boolean bl = hashSet.remove(huffmanCode);
            if (bl) {
                n4 = 0;
                for (n4 = 0; n4 < huffmanCodeArray.length && !huffmanCodeArray[n4].equals(huffmanCode); ++n4) {
                }
                n8 = 0x8000 | n4;
            } else {
                n4 = n2++;
                huffmanCodeArray2[n4] = huffmanCode;
                n8 = n4;
            }
            n8 <<= 16;
            n4 = hashSet.remove(huffmanCode2) ? 1 : 0;
            if (n4 != 0) {
                n3 = 0;
                for (n3 = 0; n3 < huffmanCodeArray.length && !huffmanCodeArray[n3].equals(huffmanCode2); ++n3) {
                }
                n8 |= 0x8000 | n3;
            } else {
                n3 = n2++;
                huffmanCodeArray2[n3] = huffmanCode2;
                n8 |= n3;
            }
            nArray[n] = n8;
            ++n;
        }
        DECODING_TABLE = nArray;
    }

    protected static class HuffmanCode {
        int value;
        int length;

        public HuffmanCode(int n, int n2) {
            this.value = n;
            this.length = n2;
        }

        public int getValue() {
            return this.value;
        }

        public int getLength() {
            return this.length;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            HuffmanCode huffmanCode = (HuffmanCode)object;
            if (this.length != huffmanCode.length) {
                return false;
            }
            return this.value == huffmanCode.value;
        }

        public int hashCode() {
            int n = this.value;
            n = 31 * n + this.length;
            return n;
        }

        public String toString() {
            return "HuffmanCode{value=" + this.value + ", length=" + this.length + '}';
        }
    }
}

