/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.storeconfig;

import java.io.PrintWriter;
import org.apache.catalina.Realm;
import org.apache.catalina.realm.CombinedRealm;
import org.apache.catalina.storeconfig.StoreDescription;
import org.apache.catalina.storeconfig.StoreFactoryBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class RealmSF
extends StoreFactoryBase {
    private static Log log = LogFactory.getLog(RealmSF.class);

    @Override
    public void store(PrintWriter printWriter, int n, Object object) throws Exception {
        if (object instanceof CombinedRealm) {
            StoreDescription storeDescription = this.getRegistry().findDescription(object.getClass());
            if (storeDescription != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("factory.storeTag", new Object[]{storeDescription.getTag(), object}));
                }
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printOpenTag(printWriter, n + 2, object, storeDescription);
                this.storeChildren(printWriter, n + 2, object, storeDescription);
                this.getStoreAppender().printIndent(printWriter, n + 2);
                this.getStoreAppender().printCloseTag(printWriter, storeDescription);
            } else if (log.isWarnEnabled()) {
                log.warn((Object)sm.getString("factory.storeNoDescriptor", new Object[]{object.getClass()}));
            }
        } else {
            super.store(printWriter, n, object);
        }
    }

    @Override
    public void storeChildren(PrintWriter printWriter, int n, Object object, StoreDescription storeDescription) throws Exception {
        CombinedRealm combinedRealm;
        if (object instanceof CombinedRealm) {
            combinedRealm = (CombinedRealm)object;
            Object[] objectArray = combinedRealm.getNestedRealms();
            this.storeElementArray(printWriter, n, objectArray);
        }
        if ((combinedRealm = ((Realm)object).getCredentialHandler()) != null) {
            this.storeElement(printWriter, n, combinedRealm);
        }
    }
}

