/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.managed;

import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.xa.XAResource;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionContextListener;
import org.apache.tomcat.dbcp.dbcp2.managed.TransactionRegistry;

public class TransactionContext {
    private final TransactionRegistry transactionRegistry;
    private final WeakReference<Transaction> transactionRef;
    private final TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    private Connection sharedConnection;
    private boolean transactionComplete;

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
        Objects.requireNonNull(transactionRegistry, "transactionRegistry is null");
        Objects.requireNonNull(transaction, "transaction is null");
        this.transactionRegistry = transactionRegistry;
        this.transactionRef = new WeakReference<Transaction>(transaction);
        this.transactionComplete = false;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
    }

    public TransactionContext(TransactionRegistry transactionRegistry, Transaction transaction) {
        this(transactionRegistry, transaction, null);
    }

    public Connection getSharedConnection() {
        return this.sharedConnection;
    }

    public void setSharedConnection(Connection connection) throws SQLException {
        if (this.sharedConnection != null) {
            throw new IllegalStateException("A shared connection is already set");
        }
        Transaction transaction = this.getTransaction();
        try {
            XAResource xAResource = this.transactionRegistry.getXAResource(connection);
            if (!transaction.enlistResource(xAResource)) {
                throw new SQLException("Unable to enlist connection in transaction: enlistResource returns 'false'.");
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw new SQLException("Unable to enlist connection in the transaction", illegalStateException);
        }
        catch (RollbackException rollbackException) {
        }
        catch (SystemException systemException) {
            throw new SQLException("Unable to enlist connection the transaction", systemException);
        }
        this.sharedConnection = connection;
    }

    public void addTransactionContextListener(final TransactionContextListener transactionContextListener) throws SQLException {
        try {
            if (!this.isActive()) {
                Transaction transaction = (Transaction)this.transactionRef.get();
                transactionContextListener.afterCompletion(this, transaction != null && transaction.getStatus() == 3);
                return;
            }
            Synchronization synchronization = new Synchronization(){

                public void beforeCompletion() {
                }

                public void afterCompletion(int n) {
                    transactionContextListener.afterCompletion(TransactionContext.this, n == 3);
                }
            };
            if (this.transactionSynchronizationRegistry != null) {
                this.transactionSynchronizationRegistry.registerInterposedSynchronization(synchronization);
            } else {
                this.getTransaction().registerSynchronization(synchronization);
            }
        }
        catch (RollbackException rollbackException) {
        }
        catch (Exception exception) {
            throw new SQLException("Unable to register transaction context listener", exception);
        }
    }

    public boolean isActive() throws SQLException {
        try {
            Transaction transaction = (Transaction)this.transactionRef.get();
            if (transaction == null) {
                return false;
            }
            int n = transaction.getStatus();
            return n == 0 || n == 1;
        }
        catch (SystemException systemException) {
            throw new SQLException("Unable to get transaction status", systemException);
        }
    }

    private Transaction getTransaction() throws SQLException {
        Transaction transaction = (Transaction)this.transactionRef.get();
        if (transaction == null) {
            throw new SQLException("Unable to enlist connection because the transaction has been garbage collected");
        }
        return transaction;
    }

    public void completeTransaction() {
        this.transactionComplete = true;
    }

    public boolean isTransactionComplete() {
        return this.transactionComplete;
    }
}

