/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.cert.Certificate;
import java.util.jar.Manifest;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.webresources.AbstractResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FileResource
extends AbstractResource {
    private static final Log log = LogFactory.getLog(FileResource.class);
    private static final boolean PROPERTIES_NEED_CONVERT;
    private final File resource;
    private final String name;
    private final boolean readOnly;
    private final Manifest manifest;
    private final boolean needConvert;

    public FileResource(WebResourceRoot webResourceRoot, String string, File file, boolean bl, Manifest manifest) {
        super(webResourceRoot, string);
        this.resource = file;
        if (string.charAt(string.length() - 1) == '/') {
            String string2 = file.getName() + '/';
            if (string.endsWith(string2)) {
                this.name = file.getName();
            } else {
                int n = string.length() - 1;
                this.name = string.substring(string.lastIndexOf(47, n - 1) + 1, n);
            }
        } else {
            this.name = file.getName();
        }
        this.readOnly = bl;
        this.manifest = manifest;
        this.needConvert = PROPERTIES_NEED_CONVERT && this.name.endsWith(".properties");
    }

    @Override
    public long getLastModified() {
        return this.resource.lastModified();
    }

    @Override
    public boolean exists() {
        return this.resource.exists();
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isDirectory() {
        return this.resource.isDirectory();
    }

    @Override
    public boolean isFile() {
        return this.resource.isFile();
    }

    @Override
    public boolean delete() {
        if (this.readOnly) {
            return false;
        }
        return this.resource.delete();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getContentLength() {
        return this.getContentLengthInternal(this.needConvert);
    }

    private long getContentLengthInternal(boolean bl) {
        if (bl) {
            byte[] byArray = this.getContent();
            if (byArray == null) {
                return -1L;
            }
            return byArray.length;
        }
        if (this.isDirectory()) {
            return -1L;
        }
        return this.resource.length();
    }

    @Override
    public String getCanonicalPath() {
        try {
            return this.resource.getCanonicalPath();
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("fileResource.getCanonicalPathFail", new Object[]{this.resource.getPath()}), (Throwable)iOException);
            }
            return null;
        }
    }

    @Override
    public boolean canRead() {
        return this.resource.canRead();
    }

    @Override
    protected InputStream doGetInputStream() {
        if (this.needConvert) {
            byte[] byArray = this.getContent();
            if (byArray == null) {
                return null;
            }
            return new ByteArrayInputStream(byArray);
        }
        try {
            return new FileInputStream(this.resource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
    }

    @Override
    public final byte[] getContent() {
        Object object;
        long l = this.getContentLengthInternal(false);
        if (l > Integer.MAX_VALUE) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("abstractResource.getContentTooLarge", new Object[]{this.getWebappPath(), l}));
        }
        if (l < 0L) {
            return null;
        }
        int n = (int)l;
        byte[] byArray = new byte[n];
        try {
            object = new FileInputStream(this.resource);
            Throwable throwable = null;
            try {
                int n2;
                for (int i = 0; i < n; i += n2) {
                    n2 = ((InputStream)object).read(byArray, i, n - i);
                    if (n2 >= 0) continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((Object)sm.getString("abstractResource.getContentFail", new Object[]{this.getWebappPath()}), (Throwable)iOException);
            }
            return null;
        }
        if (this.needConvert) {
            object = new String(byArray);
            try {
                byArray = ((String)object).getBytes(StandardCharsets.UTF_8);
            }
            catch (Exception exception) {
                byArray = null;
            }
        }
        return byArray;
    }

    @Override
    public long getCreation() {
        try {
            BasicFileAttributes basicFileAttributes = Files.readAttributes(this.resource.toPath(), BasicFileAttributes.class, new LinkOption[0]);
            return basicFileAttributes.creationTime().toMillis();
        }
        catch (IOException iOException) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("fileResource.getCreationFail", new Object[]{this.resource.getPath()}), (Throwable)iOException);
            }
            return 0L;
        }
    }

    @Override
    public URL getURL() {
        if (this.resource.exists()) {
            try {
                return this.resource.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("fileResource.getUrlFail", new Object[]{this.resource.getPath()}), (Throwable)malformedURLException);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public URL getCodeBase() {
        if (this.getWebappPath().startsWith("/WEB-INF/classes/") && this.name.endsWith(".class")) {
            return this.getWebResourceRoot().getResource("/WEB-INF/classes/").getURL();
        }
        return this.getURL();
    }

    @Override
    public Certificate[] getCertificates() {
        return null;
    }

    @Override
    public Manifest getManifest() {
        return this.manifest;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    static {
        boolean bl = false;
        try {
            String string = System.getProperty("file.encoding");
            if (string.contains("EBCDIC")) {
                bl = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        PROPERTIES_NEED_CONVERT = bl;
    }
}

