/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Segment;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.lib.profiler.results.threads.ThreadDump;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public class ThreadDumpWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "ThreadDumpWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ThreadDumpWindow.HelpCtx");
    private HTMLTextArea a;

    public ThreadDumpWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public ThreadDumpWindow(ThreadDump threadDump) {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setName(Bundle.ThreadDumpWindow_Caption(StringUtils.formatUserDate((Date)threadDump.getTime())));
        this.setIcon(Icons.getImage((String)"ProfilerIcons.Thread"));
        StringBuilder stringBuilder = new StringBuilder();
        this.printThreads(stringBuilder, threadDump);
        this.a = new HTMLTextArea(){

            protected void showURL(URL uRL) {
                if (uRL == null) {
                    return;
                }
                String string = uRL.toString();
                ThreadDumpWindow.this.showURL(string);
            }
        };
        this.a.setEditorKit((EditorKit)new CustomHtmlEditorKit());
        this.a.setText(stringBuilder.toString());
        this.a.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane((Component)this.a);
        jScrollPane.setBorder(BorderFactory.createEmptyBorder());
        jScrollPane.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add(jScrollPane, "Center");
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.a;
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void printThreads(StringBuilder stringBuilder, ThreadDump threadDump) {
        ThreadInfo[] threadInfoArray = threadDump.getThreads();
        boolean bl = GoToSource.isAvailable();
        boolean bl2 = threadDump.isJDK15();
        stringBuilder.append("<pre>");
        stringBuilder.append(" <b>Full thread dump: ");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        stringBuilder.append(simpleDateFormat.format(threadDump.getTime()) + "</b><br><br>");
        for (ThreadInfo threadInfo : threadInfoArray) {
            if (threadInfo == null) continue;
            if (bl2) {
                this.print15Thread(stringBuilder, threadInfo, bl);
                continue;
            }
            this.print16Thread(stringBuilder, threadInfo, bl);
        }
        stringBuilder.append("</pre>");
    }

    private void print15Thread(StringBuilder stringBuilder, ThreadInfo threadInfo, boolean bl) {
        stringBuilder.append("<br>\"" + threadInfo.getThreadName() + "\" - Thread t@" + threadInfo.getThreadId() + "<br>");
        stringBuilder.append("   java.lang.Thread.State: " + (Object)((Object)threadInfo.getThreadState()));
        if (threadInfo.getLockName() != null) {
            stringBuilder.append(" on " + threadInfo.getLockName());
            if (threadInfo.getLockOwnerName() != null) {
                stringBuilder.append(" owned by: " + threadInfo.getLockOwnerName());
            }
        }
        stringBuilder.append("<br>");
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            String string;
            String string2 = string = ThreadDumpWindow.htmlize(stackTraceElement.toString());
            if (bl) {
                String string3 = stackTraceElement.getClassName();
                String string4 = stackTraceElement.getMethodName();
                int n = stackTraceElement.getLineNumber();
                String string5 = "file:/stackframe/" + string3 + "|" + string4 + "|" + n;
                string2 = "<a href=\"" + string5 + "\">" + string + "</a>";
            }
            stringBuilder.append("        at ").append(string2).append("<br>");
        }
    }

    private void print16Thread(StringBuilder stringBuilder, ThreadInfo threadInfo, boolean bl) {
        LockInfo[] lockInfoArray;
        MonitorInfo[] monitorInfoArray = threadInfo.getLockedMonitors();
        stringBuilder.append("&nbsp;<b>");
        stringBuilder.append("\"").append(threadInfo.getThreadName()).append("\" - Thread t@").append(threadInfo.getThreadId()).append("<br>");
        stringBuilder.append("    java.lang.Thread.State: ").append((Object)threadInfo.getThreadState());
        stringBuilder.append("</b><br>");
        int n = 0;
        for (StackTraceElement stackTraceElement : threadInfo.getStackTrace()) {
            LockInfo lockInfo = threadInfo.getLockInfo();
            String object = ThreadDumpWindow.htmlize(stackTraceElement.toString());
            String string = threadInfo.getLockOwnerName();
            String string2 = object;
            if (bl) {
                String string3 = stackTraceElement.getClassName();
                String string4 = stackTraceElement.getMethodName();
                int n2 = stackTraceElement.getLineNumber();
                String string5 = "file:/stackframe/" + string3 + "|" + string4 + "|" + n2;
                string2 = "<a href=\"" + string5 + "\">" + object + "</a>";
            }
            stringBuilder.append("    at ").append(string2).append("<br>");
            if (n == 0) {
                if ("java.lang.Object".equals(stackTraceElement.getClassName()) && "wait".equals(stackTraceElement.getMethodName())) {
                    if (lockInfo != null) {
                        stringBuilder.append("    - waiting on ");
                        this.printLock(stringBuilder, lockInfo);
                        stringBuilder.append("<br>");
                    }
                } else if (lockInfo != null) {
                    if (string == null) {
                        stringBuilder.append("    - parking to wait for ");
                        this.printLock(stringBuilder, lockInfo);
                        stringBuilder.append("<br>");
                    } else {
                        stringBuilder.append("    - waiting to lock ");
                        this.printLock(stringBuilder, lockInfo);
                        stringBuilder.append(" owned by \"").append(string).append("\" t@").append(threadInfo.getLockOwnerId()).append("<br>");
                    }
                }
            }
            this.printMonitors(stringBuilder, monitorInfoArray, n);
            ++n;
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        this.printMonitors(stringBuilder2, monitorInfoArray, -1);
        if (stringBuilder2.length() > 0) {
            stringBuilder.append("   JNI locked monitors:<br>");
            stringBuilder.append((CharSequence)stringBuilder2);
        }
        if ((lockInfoArray = threadInfo.getLockedSynchronizers()) != null) {
            stringBuilder.append("<br>   Locked ownable synchronizers:");
            if (lockInfoArray.length == 0) {
                stringBuilder.append("<br>    - None\n");
            } else {
                for (LockInfo lockInfo : lockInfoArray) {
                    stringBuilder.append("<br>    - locked ");
                    this.printLock(stringBuilder, lockInfo);
                    stringBuilder.append("<br>");
                }
            }
        }
        stringBuilder.append("<br>");
    }

    private void printMonitors(StringBuilder stringBuilder, MonitorInfo[] monitorInfoArray, int n) {
        if (monitorInfoArray != null) {
            for (MonitorInfo monitorInfo : monitorInfoArray) {
                if (monitorInfo.getLockedStackDepth() != n) continue;
                stringBuilder.append("    - locked ");
                this.printLock(stringBuilder, monitorInfo);
                stringBuilder.append("<br>");
            }
        }
    }

    private void printLock(StringBuilder stringBuilder, LockInfo lockInfo) {
        String string = Integer.toHexString(lockInfo.getIdentityHashCode());
        String string2 = lockInfo.getClassName();
        stringBuilder.append("&lt;").append(string).append("&gt; (a ").append(string2).append(")");
    }

    private static String htmlize(String string) {
        return string.replace(">", "&gt;").replace("<", "&lt;");
    }

    private void showURL(String string) {
        if (string.startsWith("file:/stackframe/")) {
            string = string.substring("file:/stackframe/".length());
            String[] stringArray = string.split("\\|");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            int n = Integer.parseInt(stringArray[2]);
            GoToSource.openSource(null, (String)string2, (String)string3, (int)n);
        }
    }

    private class CustomHTMLDocument
    extends HTMLDocument {
        private static final int CACHE_BOUNDARY = 1000;
        private char[] segArray;
        private int segOffset;
        private int segCount;
        private boolean segPartialReturn;
        private int lastOffset;
        private int lastLength;

        private CustomHTMLDocument(StyleSheet styleSheet) {
            super(styleSheet);
            this.lastOffset = -1;
            this.lastLength = -1;
            this.putProperty("multiByte", Boolean.TRUE);
        }

        @Override
        public void getText(int n, int n2, Segment segment) throws BadLocationException {
            if (this.lastOffset == n && this.lastLength == n2) {
                segment.array = this.segArray;
                segment.offset = this.segOffset;
                segment.count = this.segCount;
                segment.setPartialReturn(this.segPartialReturn);
                return;
            }
            super.getText(n, n2, segment);
            if (n2 > 1000 || this.lastLength <= 1000) {
                this.segArray = segment.array;
                this.segOffset = segment.offset;
                this.segCount = segment.count;
                this.segPartialReturn = segment.isPartialReturn();
                this.lastOffset = n;
                this.lastLength = n2;
            }
        }
    }

    private class CustomHtmlEditorKit
    extends HTMLEditorKit {
        private CustomHtmlEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styleSheet = this.getStyleSheet();
            StyleSheet styleSheet2 = new StyleSheet();
            styleSheet2.addStyleSheet(styleSheet);
            CustomHTMLDocument customHTMLDocument = new CustomHTMLDocument(styleSheet2);
            customHTMLDocument.setParser(this.getParser());
            customHTMLDocument.setAsynchronousLoadPriority(4);
            customHTMLDocument.setTokenThreshold(100);
            return customHTMLDocument;
        }
    }
}

