/*
 * Decompiled with CFR 0.152.
 */
package freemind.extensions;

import freemind.main.FreeMindMain;
import freemind.main.Resources;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ImportWizard {
    public final String lookFor = ".xml";
    public Vector CLASS_LIST = new Vector(500);
    private final FreeMindMain mFrame;
    private static Logger logger = null;

    public ImportWizard(FreeMindMain frame) {
        this.mFrame = frame;
        if (logger == null) {
            logger = frame.getLogger(this.getClass().getName());
        }
    }

    public void buildClassList() {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = File.pathSeparator;
        classPath = this.mFrame.getFreemindBaseDir() + classPathSeparator + classPath;
        logger.info("Classpath for plugins:" + classPath);
        HashSet<String> foundPlugins = new HashSet<String>();
        StringTokenizer st = new StringTokenizer(classPath, classPathSeparator);
        while (st.hasMoreTokens()) {
            String classPathEntry = st.nextToken();
            File classPathFile = new File(classPathEntry);
            try {
                String key = classPathFile.getCanonicalPath();
                if (foundPlugins.contains(key)) continue;
                logger.fine("looking for plugins in " + key);
                foundPlugins.add(key);
            }
            catch (IOException e) {
                Resources.getInstance().logException(e);
            }
            if (!classPathFile.exists()) continue;
            String lowerCaseFileName = classPathEntry.toLowerCase();
            if (lowerCaseFileName.endsWith(".jar")) {
                logger.fine("searching for plugins in: " + classPathEntry);
                this.addClassesFromZip(this.CLASS_LIST, classPathFile);
                continue;
            }
            if (lowerCaseFileName.endsWith(".zip")) {
                logger.fine("searching for plugins in: " + classPathEntry);
                this.addClassesFromZip(this.CLASS_LIST, classPathFile);
                continue;
            }
            if (!classPathFile.isDirectory()) continue;
            logger.fine("searching for plugins in: " + classPathEntry);
            this.addClassesFromDir(this.CLASS_LIST, classPathFile, classPathFile, 0);
        }
    }

    public void addClassesFromZip(Vector classList, File classPathFile) {
        try {
            ZipFile zipFile = new ZipFile(classPathFile);
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String current = zipEntry.getName();
                if (!this.isInteresting(current)) continue;
                current = current.substring(0, current.length() - ".xml".length());
                classList.addElement(current);
            }
        }
        catch (Exception ex) {
            Resources.getInstance().logException(ex, "Problem opening " + classPathFile + " with zip.");
        }
    }

    private boolean isInteresting(String current) {
        int length = current.length();
        if (length < ".xml".length()) {
            return false;
        }
        String currentPostfix = current.substring(length - ".xml".length());
        return ".xml".equalsIgnoreCase(currentPostfix);
    }

    public void addClassesFromDir(Vector classList, File rootDir, File currentDir, int recursionLevel) {
        if (recursionLevel >= 6) {
            return;
        }
        String[] files = currentDir.list();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String current = files[i];
                logger.fine("looking at: " + current);
                if (this.isInteresting(current)) {
                    String rootPath = rootDir.getPath();
                    String currentPath = currentDir.getPath();
                    if (!currentPath.startsWith(rootPath)) {
                        logger.severe("currentPath doesn't start with rootPath!\nrootPath: " + rootPath + "\n" + "currentPath: " + currentPath + "\n");
                        continue;
                    }
                    current = current.substring(0, current.length() - ".xml".length());
                    String packageName = currentPath.substring(rootPath.length());
                    String fileName = packageName.length() > 0 ? packageName.substring(1) + File.separator + current : current;
                    classList.addElement(fileName);
                    logger.info("Found: " + fileName);
                    continue;
                }
                File currentFile = new File(currentDir, current);
                if (!currentFile.isDirectory()) continue;
                this.addClassesFromDir(classList, rootDir, currentFile, recursionLevel + 1);
            }
        }
    }
}

