/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.branding.desktop;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.TransferHandler;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.project.api.ProjectControllerUI;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class DragNDropFrameAdapter {
    private static final String GEPHI_EXTENSION = "gephi";

    public static void register() {
        JFrame frame = (JFrame)WindowManager.getDefault().getMainWindow();
        frame.setTransferHandler(new TransferHandler(){

            @Override
            public boolean canImport(TransferHandler.TransferSupport support) {
                return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
            }

            @Override
            public boolean importData(TransferHandler.TransferSupport support) {
                if (!this.canImport(support)) {
                    return false;
                }
                try {
                    List data = (List)support.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                    File file = (File)data.get(0);
                    FileObject fileObject = FileUtil.toFileObject((File)file);
                    if (!file.exists()) {
                        return false;
                    }
                    if (fileObject.hasExt(DragNDropFrameAdapter.GEPHI_EXTENSION)) {
                        ProjectControllerUI pc = (ProjectControllerUI)Lookup.getDefault().lookup(ProjectControllerUI.class);
                        try {
                            pc.openProject(file);
                        }
                        catch (Exception ew) {
                            Exceptions.printStackTrace((Throwable)ew);
                            NotifyDescriptor.Message msg = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DragNDropFrameAdapter.class, (String)"DragNDropFrameAdapter.openGephiError"), 2);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)msg);
                        }
                    } else {
                        ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                        if (importController.getImportController().isFileSupported(FileUtil.toFile((FileObject)fileObject))) {
                            importController.importFile(fileObject);
                        } else {
                            return false;
                        }
                    }
                    return true;
                }
                catch (UnsupportedFlavorException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return false;
            }
        });
    }
}

