/*
 * Decompiled with CFR 0.152.
 */
package json.ext;

import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.ThreadContext;
import org.jruby.util.ByteList;

abstract class ByteListTranscoder {
    protected final ThreadContext context;
    protected ByteList src;
    protected int srcEnd;
    protected int charStart;
    protected int pos;
    private ByteList out;
    private int quoteStart = -1;

    protected ByteListTranscoder(ThreadContext threadContext) {
        this.context = threadContext;
    }

    protected void init(ByteList byteList, ByteList byteList2) {
        this.init(byteList, 0, byteList.length(), byteList2);
    }

    protected void init(ByteList byteList, int n, int n2, ByteList byteList2) {
        this.src = byteList;
        this.pos = n;
        this.charStart = n;
        this.srcEnd = n2;
        this.out = byteList2;
    }

    protected boolean hasNext() {
        return this.pos < this.srcEnd;
    }

    private char next() {
        return this.src.charAt(this.pos++);
    }

    protected int readUtf8Char() {
        this.charStart = this.pos;
        char c = this.next();
        if (c <= '\u007f') {
            return c;
        }
        if (c <= '\u00bf') {
            throw this.invalidUtf8();
        }
        if (c <= '\u00df') {
            this.ensureMin(1);
            int n = (c & 0x1F) << 6 | this.nextPart();
            if (n < 128) {
                throw this.invalidUtf8();
            }
            return n;
        }
        if (c <= '\u00ef') {
            this.ensureMin(2);
            int n = (c & 0xF) << 12 | this.nextPart() << 6 | this.nextPart();
            if (n < 2048) {
                throw this.invalidUtf8();
            }
            return n;
        }
        if (c <= '\u00f7') {
            this.ensureMin(3);
            int n = (c & 7) << 18 | this.nextPart() << 12 | this.nextPart() << 6 | this.nextPart();
            if (!Character.isValidCodePoint(n)) {
                throw this.invalidUtf8();
            }
            return n;
        }
        throw this.invalidUtf8();
    }

    protected void ensureMin(int n) {
        if (this.pos + n > this.srcEnd) {
            throw this.incompleteUtf8();
        }
    }

    private int nextPart() {
        char c = this.next();
        if ((c & 0xC0) != 128) {
            throw this.invalidUtf8();
        }
        return c & 0x3F;
    }

    protected void quoteStart() {
        if (this.quoteStart == -1) {
            this.quoteStart = this.charStart;
        }
    }

    protected void quoteStop(int n) {
        if (this.quoteStart != -1) {
            this.out.append(this.src, this.quoteStart, n - this.quoteStart);
            this.quoteStart = -1;
        }
    }

    protected void append(int n) {
        this.out.append(n);
    }

    protected void append(byte[] byArray, int n, int n2) {
        this.out.append(byArray, n, n2);
    }

    protected abstract RaiseException invalidUtf8();

    protected RaiseException incompleteUtf8() {
        return this.invalidUtf8();
    }
}

