/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import org.jetbrains.kotlin.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.org.apache.ivy.core.event.EventManager;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.Artifact;
import org.jetbrains.kotlin.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.org.apache.ivy.core.module.id.ModuleRevisionId;
import org.jetbrains.kotlin.org.apache.ivy.core.report.DownloadReport;
import org.jetbrains.kotlin.org.apache.ivy.core.resolve.DownloadOptions;
import org.jetbrains.kotlin.org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.jetbrains.kotlin.org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.AbstractRepository;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Repository;
import org.jetbrains.kotlin.org.apache.ivy.plugins.repository.Resource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.AbstractPatternsBasedResolver;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.ResolverSettings;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.jetbrains.kotlin.org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.jetbrains.kotlin.org.apache.ivy.plugins.version.VersionMatcher;
import org.jetbrains.kotlin.org.apache.ivy.util.Message;
import org.jetbrains.kotlin.org.apache.ivy.util.StringUtils;

public class RepositoryResolver
extends AbstractPatternsBasedResolver {
    private Repository repository;
    private Boolean alwaysCheckExactRevision = null;
    private String signerName = null;

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.repository instanceof AbstractRepository) {
            ((AbstractRepository)this.repository).setName(name);
        }
    }

    @Override
    protected ResolvedResource findResourceUsingPattern(ModuleRevisionId mrid, String pattern, Artifact artifact, ResourceMDParser rmdparser, Date date) {
        String name = this.getName();
        VersionMatcher versionMatcher = this.getSettings().getVersionMatcher();
        try {
            if (!versionMatcher.isDynamic(mrid) || this.isAlwaysCheckExactRevision()) {
                String resourceName = IvyPatternHelper.substitute(pattern, mrid, artifact);
                Message.debug("\t trying " + resourceName);
                this.logAttempt(resourceName);
                Resource res2 = this.repository.getResource(resourceName);
                boolean reachable = res2.exists();
                if (reachable) {
                    String revision;
                    if (pattern.contains("revision")) {
                        revision = mrid.getRevision();
                    } else if ("ivy".equals(artifact.getType()) || "pom".equals(artifact.getType())) {
                        File temp = File.createTempFile("ivy", artifact.getExt());
                        temp.deleteOnExit();
                        this.repository.get(res2.getName(), temp);
                        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(res2);
                        ModuleDescriptor md = parser.parseDescriptor(this.getParserSettings(), temp.toURI().toURL(), res2, false);
                        revision = md.getRevision();
                        if (StringUtils.isNullOrEmpty(revision)) {
                            revision = "working@" + name;
                        }
                    } else {
                        revision = "working@" + name;
                    }
                    return new ResolvedResource(res2, revision);
                }
                if (versionMatcher.isDynamic(mrid)) {
                    return this.findDynamicResourceUsingPattern(rmdparser, mrid, pattern, artifact, date);
                }
                Message.debug("\t" + name + ": resource not reachable for " + mrid + ": res=" + res2);
                return null;
            }
            return this.findDynamicResourceUsingPattern(rmdparser, mrid, pattern, artifact, date);
        }
        catch (IOException | ParseException ex) {
            throw new RuntimeException(name + ": unable to get resource for " + mrid + ": res=" + IvyPatternHelper.substitute(pattern, mrid, artifact) + ": " + ex, ex);
        }
    }

    private ResolvedResource findDynamicResourceUsingPattern(ResourceMDParser rmdparser, ModuleRevisionId mrid, String pattern, Artifact artifact, Date date) {
        String name = this.getName();
        this.logAttempt(IvyPatternHelper.substitute(pattern, ModuleRevisionId.newInstance(mrid, IvyPatternHelper.getTokenString("revision")), artifact));
        ResolvedResource[] rress = this.listResources(this.repository, mrid, pattern, artifact);
        if (rress == null) {
            Message.debug("\t" + name + ": unable to list resources for " + mrid + ": pattern=" + pattern);
            return null;
        }
        ResolvedResource found = this.findResource(rress, rmdparser, mrid, date);
        if (found == null) {
            Message.debug("\t" + name + ": no resource found for " + mrid + ": pattern=" + pattern);
        }
        return found;
    }

    protected ResolvedResource[] listResources(Repository repository, ModuleRevisionId mrid, String pattern, Artifact artifact) {
        return ResolverHelper.findAll(repository, mrid, pattern, artifact);
    }

    @Override
    protected long get(Resource resource, File dest) throws IOException {
        Message.verbose("\t" + this.getName() + ": downloading " + resource.getName());
        Message.debug("\t\tto " + dest);
        if (dest.getParentFile() != null) {
            dest.getParentFile().mkdirs();
        }
        this.repository.get(resource.getName(), dest);
        return dest.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        EventManager eventManager = this.getEventManager();
        try {
            if (eventManager != null) {
                this.repository.addTransferListener(eventManager);
            }
            DownloadReport downloadReport = super.download(artifacts, options);
            return downloadReport;
        }
        finally {
            if (eventManager != null) {
                this.repository.removeTransferListener(eventManager);
            }
        }
    }

    @Override
    public String getTypeName() {
        return "repository";
    }

    @Override
    public void dumpSettings() {
        super.dumpSettings();
        Message.debug("\t\trepository: " + this.getRepository());
    }

    @Override
    public void setSettings(ResolverSettings settings) {
        super.setSettings(settings);
        if (settings != null && this.alwaysCheckExactRevision == null) {
            this.alwaysCheckExactRevision = Boolean.valueOf(settings.getVariable("ivy.default.always.check.exact.revision"));
        }
    }

    public boolean isAlwaysCheckExactRevision() {
        return this.alwaysCheckExactRevision == null || this.alwaysCheckExactRevision != false;
    }
}

