/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionOut;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.ConeStubType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.TypeRendererKt;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J-\u0010\t\u001a\u00020\u00062\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000b2\u000e\u0010\r\u001a\n\u0012\u0006\b\u0001\u0012\u00020\f0\u000bH\u0002\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u000fH\u0002J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002R\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinTypeComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lkotlin/Comparator;", "()V", "priority", "", "getPriority", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)I", "compare", "a", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "b", "([Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)I", "Lorg/jetbrains/kotlin/fir/types/ConeNullability;", "tree"})
public final class ConeKotlinTypeComparator
implements Comparator<ConeKotlinType> {
    @NotNull
    public static final ConeKotlinTypeComparator INSTANCE = new ConeKotlinTypeComparator();

    private ConeKotlinTypeComparator() {
    }

    private final int getPriority(ConeKotlinType $this$priority) {
        ConeKotlinType coneKotlinType = $this$priority;
        return coneKotlinType instanceof ConeClassErrorType ? 8 : (coneKotlinType instanceof ConeLookupTagBasedType ? 7 : (coneKotlinType instanceof ConeFlexibleType ? 6 : (coneKotlinType instanceof ConeCapturedType ? 5 : (coneKotlinType instanceof ConeDefinitelyNotNullType ? 4 : (coneKotlinType instanceof ConeIntersectionType ? 3 : (coneKotlinType instanceof ConeStubType ? 2 : (coneKotlinType instanceof ConeIntegerLiteralType ? 1 : 0)))))));
    }

    @Override
    private final int compare(ConeTypeProjection a, ConeTypeProjection b) {
        int kindDiff = a.getKind().ordinal() - b.getKind().ordinal();
        if (kindDiff != 0) {
            return kindDiff;
        }
        ConeTypeProjection coneTypeProjection = a;
        if (coneTypeProjection instanceof ConeStarProjection) {
            return 0;
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionIn) {
            boolean bl = b instanceof ConeKotlinTypeProjectionIn;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "ordinal is inconsistent: " + a + " v.s. " + b;
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            return this.compare(((ConeKotlinTypeProjectionIn)a).getType(), ((ConeKotlinTypeProjectionIn)b).getType());
        }
        if (coneTypeProjection instanceof ConeKotlinTypeProjectionOut) {
            boolean bl = b instanceof ConeKotlinTypeProjectionOut;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string3 = "ordinal is inconsistent: " + a + " v.s. " + b;
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            return this.compare(((ConeKotlinTypeProjectionOut)a).getType(), ((ConeKotlinTypeProjectionOut)b).getType());
        }
        boolean bl = a instanceof ConeKotlinType && b instanceof ConeKotlinType;
        boolean bl8 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl9 = false;
            String string4 = "Expect INVARIANT: " + a + " v.s. " + b;
            throw (Throwable)((Object)new AssertionError((Object)string4));
        }
        return this.compare((ConeKotlinType)a, (ConeKotlinType)b);
    }

    @Override
    private final int compare(ConeTypeProjection[] a, ConeTypeProjection[] b) {
        int sizeDiff = a.length - b.length;
        if (sizeDiff != 0) {
            return sizeDiff;
        }
        for (Pair<ConeTypeProjection, ConeTypeProjection> pair : ArraysKt.zip(a, b)) {
            ConeTypeProjection bTypeProjection;
            ConeTypeProjection aTypeProjection = pair.component1();
            int typeProjectionDiff = this.compare(aTypeProjection, bTypeProjection = pair.component2());
            if (typeProjectionDiff == 0) continue;
            return typeProjectionDiff;
        }
        return 0;
    }

    @Override
    private final int compare(ConeNullability a, ConeNullability b) {
        return a.ordinal() - b.ordinal();
    }

    @Override
    public int compare(@NotNull ConeKotlinType a, @NotNull ConeKotlinType b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        int priorityDiff = this.getPriority(a) - this.getPriority(b);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        ConeKotlinType coneKotlinType = a;
        if (coneKotlinType instanceof ConeClassErrorType) {
            boolean bl = b instanceof ConeClassErrorType;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string2 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(string2.toString());
            }
            return a.hashCode() - b.hashCode();
        }
        if (coneKotlinType instanceof ConeLookupTagBasedType) {
            boolean bl = b instanceof ConeLookupTagBasedType;
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl) {
                boolean bl7 = false;
                String string3 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(string3.toString());
            }
            int nameDiff = ((ConeLookupTagBasedType)a).getLookupTag().getName().compareTo(((ConeLookupTagBasedType)b).getLookupTag().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            int nullabilityDiff2 = this.compare(a.getNullability(), b.getNullability());
            if (nullabilityDiff2 != 0) {
                return nullabilityDiff2;
            }
            return this.compare(a.getTypeArguments(), b.getTypeArguments());
        }
        if (coneKotlinType instanceof ConeFlexibleType) {
            boolean nameDiff = b instanceof ConeFlexibleType;
            boolean nullabilityDiff2 = false;
            boolean bl = false;
            if (!nameDiff) {
                boolean bl8 = false;
                String string4 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(string4.toString());
            }
            int lowerBoundDiff = this.compare(((ConeFlexibleType)a).getLowerBound(), ((ConeFlexibleType)b).getLowerBound());
            if (lowerBoundDiff != 0) {
                return lowerBoundDiff;
            }
            return this.compare(((ConeFlexibleType)a).getUpperBound(), ((ConeFlexibleType)b).getUpperBound());
        }
        if (coneKotlinType instanceof ConeCapturedType) {
            int nullabilityDiff;
            int bHasLowerType;
            boolean lowerBoundDiff = b instanceof ConeCapturedType;
            boolean nullabilityDiff2 = false;
            boolean bl = false;
            if (!lowerBoundDiff) {
                boolean bl9 = false;
                String string5 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(string5.toString());
            }
            int aHasLowerType = ((ConeCapturedType)a).getLowerType() != null ? 1 : 0;
            int hasLowerTypeDiff2222 = aHasLowerType - (bHasLowerType = ((ConeCapturedType)b).getLowerType() != null ? 1 : 0);
            if (hasLowerTypeDiff2222 != 0) {
                return hasLowerTypeDiff2222;
            }
            if (((ConeCapturedType)a).getLowerType() != null && ((ConeCapturedType)b).getLowerType() != null) {
                ConeKotlinType coneKotlinType2 = ((ConeCapturedType)a).getLowerType();
                Intrinsics.checkNotNull(coneKotlinType2);
                ConeKotlinType coneKotlinType3 = coneKotlinType2;
                coneKotlinType2 = ((ConeCapturedType)b).getLowerType();
                Intrinsics.checkNotNull(coneKotlinType2);
                int lowerTypeDiff = this.compare(coneKotlinType3, coneKotlinType2);
                if (lowerTypeDiff != 0) {
                    return lowerTypeDiff;
                }
            }
            if ((nullabilityDiff = this.compare(a.getNullability(), b.getNullability())) != 0) {
                return nullabilityDiff;
            }
            return ((ConeCapturedType)a).getConstructor().hashCode() - ((ConeCapturedType)b).getConstructor().hashCode();
        }
        if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
            boolean aHasLowerType = b instanceof ConeDefinitelyNotNullType;
            boolean bl = false;
            boolean hasLowerTypeDiff2222 = false;
            if (!aHasLowerType) {
                boolean bl10 = false;
                String hasLowerTypeDiff2222 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(hasLowerTypeDiff2222.toString());
            }
            return this.compare(((ConeDefinitelyNotNullType)a).getOriginal(), ((ConeDefinitelyNotNullType)b).getOriginal());
        }
        if (coneKotlinType instanceof ConeIntersectionType) {
            boolean aHasLowerType = b instanceof ConeIntersectionType;
            boolean bl = false;
            boolean hasLowerTypeDiff2222 = false;
            if (!aHasLowerType) {
                boolean bl11 = false;
                String hasLowerTypeDiff2222 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(hasLowerTypeDiff2222.toString());
            }
            int sizeDiff = ((ConeIntersectionType)a).getIntersectedTypes().size() - ((ConeIntersectionType)b).getIntersectedTypes().size();
            if (sizeDiff != 0) {
                return 0;
            }
            return a.hashCode() - b.hashCode();
        }
        if (coneKotlinType instanceof ConeStubType) {
            boolean sizeDiff = b instanceof ConeStubType;
            boolean bl = false;
            boolean hasLowerTypeDiff2222 = false;
            if (!sizeDiff) {
                boolean bl12 = false;
                String hasLowerTypeDiff2222 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(hasLowerTypeDiff2222.toString());
            }
            int nameDiff = ((ConeStubType)a).getVariable().getTypeConstructor().getName().compareTo(((ConeStubType)b).getVariable().getTypeConstructor().getName());
            if (nameDiff != 0) {
                return nameDiff;
            }
            return this.compare(a.getNullability(), b.getNullability());
        }
        if (coneKotlinType instanceof ConeIntegerLiteralType) {
            boolean nameDiff = b instanceof ConeIntegerLiteralType;
            boolean bl = false;
            boolean hasLowerTypeDiff2222 = false;
            if (!nameDiff) {
                boolean bl13 = false;
                String hasLowerTypeDiff2222 = "priority is inconsistent: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
                throw (Throwable)new IllegalArgumentException(hasLowerTypeDiff2222.toString());
            }
            long valueDiff = ((ConeIntegerLiteralType)a).getValue() - ((ConeIntegerLiteralType)b).getValue();
            if (valueDiff != 0L) {
                return (int)valueDiff;
            }
            int nullabilityDiff = this.compare(a.getNullability(), b.getNullability());
            if (nullabilityDiff != 0) {
                return nullabilityDiff;
            }
            return a.hashCode() - b.hashCode();
        }
        String string6 = "Unsupported type comparison: " + TypeRendererKt.render(a) + " v.s. " + TypeRendererKt.render(b);
        boolean bl = false;
        throw (Throwable)new IllegalStateException(string6.toString());
    }
}

