/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.dce;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsLocation;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.SourceInfoAwareJsNode;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SpecialFunction;
import org.jetbrains.kotlin.js.dce.Context;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\n\u0010\u0006\u001a\u00020\u0007*\u00020\b\u001a\f\u0010\t\u001a\u0004\u0018\u00010\b*\u00020\n\u001a\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\b\u0012\u0004\u0012\u00020\r0\f\u001a(\u0010\u000e\u001a\u00020\u000f*\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0011H\u0002\u001a\u0012\u0010\u0013\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0012\u0010\u0016\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u0012\u0010\u0017\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u0018\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u001b\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0007\u001a\u0012\u0010\u001d\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u001a\u001a\u0010\u001e\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0007\u001a\u0012\u0010\u001f\u001a\u00020\u0001*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0003\u00a8\u0006 "}, d2={"isSpecialFunction", "", "expr", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "specialFunction", "Lorg/jetbrains/kotlin/js/backend/ast/metadata/SpecialFunction;", "asString", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsLocation;", "extractLocation", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "extractRoots", "", "Lorg/jetbrains/kotlin/js/dce/Context$Node;", "extractRootsImpl", "", "target", "", "visited", "isAmdDefine", "Lorg/jetbrains/kotlin/js/dce/Context;", "function", "isDefineInlineFunction", "isDefineModule", "isKotlinFunction", "name", "isObjectDefineProperty", "isObjectFunction", "functionName", "isObjectGetOwnPropertyDescriptor", "isTopLevelFunction", "isWrapFunction", "js.dce"})
public final class UtilKt {
    public static final boolean isObjectDefineProperty(@NotNull Context $this$isObjectDefineProperty, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$isObjectDefineProperty, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilKt.isObjectFunction($this$isObjectDefineProperty, function2, "defineProperty");
    }

    public static final boolean isObjectGetOwnPropertyDescriptor(@NotNull Context $this$isObjectGetOwnPropertyDescriptor, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$isObjectGetOwnPropertyDescriptor, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilKt.isObjectFunction($this$isObjectGetOwnPropertyDescriptor, function2, "getOwnPropertyDescriptor");
    }

    public static final boolean isDefineModule(@NotNull Context $this$isDefineModule, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$isDefineModule, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilKt.isKotlinFunction($this$isDefineModule, function2, "defineModule");
    }

    public static final boolean isDefineInlineFunction(@NotNull Context $this$isDefineInlineFunction, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$isDefineInlineFunction, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilKt.isKotlinFunction($this$isDefineInlineFunction, function2, "defineInlineFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.DEFINE_INLINE_FUNCTION);
    }

    public static final boolean isWrapFunction(@NotNull Context $this$isWrapFunction, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$isWrapFunction, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilKt.isKotlinFunction($this$isWrapFunction, function2, "wrapFunction") || UtilKt.isSpecialFunction(function2, SpecialFunction.WRAP_FUNCTION);
    }

    public static final boolean isObjectFunction(@NotNull Context $this$isObjectFunction, @NotNull JsExpression function2, @NotNull String functionName) {
        Context.Node node;
        HasMetadata hasMetadata;
        Intrinsics.checkNotNullParameter($this$isObjectFunction, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(functionName, "functionName");
        if (!(function2 instanceof JsNameRef)) {
            return false;
        }
        if (!Intrinsics.areEqual(((JsNameRef)function2).getIdent(), functionName)) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        JsNameRef jsNameRef = hasMetadata = jsExpression instanceof JsNameRef ? (JsNameRef)jsExpression : null;
        if (hasMetadata == null) {
            return false;
        }
        JsNameRef receiver = hasMetadata;
        if ((hasMetadata = receiver.getName()) == null) {
            node = null;
        } else {
            jsExpression = hasMetadata;
            boolean bl = false;
            boolean bl2 = false;
            JsExpression it = jsExpression;
            boolean bl3 = false;
            node = $this$isObjectFunction.getNodes().get(it);
        }
        if (node != null) {
            return false;
        }
        return Intrinsics.areEqual(receiver.getIdent(), "Object");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKotlinFunction(@NotNull Context $this$isKotlinFunction, @NotNull JsExpression function2, @NotNull String name) {
        JsName jsName;
        Intrinsics.checkNotNullParameter($this$isKotlinFunction, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(function2 instanceof JsNameRef)) return false;
        if (!Intrinsics.areEqual(((JsNameRef)function2).getIdent(), name)) {
            return false;
        }
        JsExpression jsExpression = ((JsNameRef)function2).getQualifier();
        if (!(jsExpression instanceof JsNameRef)) return false;
        JsNameRef jsNameRef = (JsNameRef)jsExpression;
        Object object = jsNameRef;
        if (object == null) {
            return false;
        }
        JsName jsName2 = jsName = ((JsNameRef)object).getName();
        if (jsName == null) {
            return false;
        }
        Object object2 = jsName;
        JsName receiver = object2;
        object2 = $this$isKotlinFunction.getNodes();
        boolean bl = false;
        object = object2;
        boolean bl2 = false;
        if (!object.containsKey(receiver)) return false;
        object2 = receiver.getIdent();
        Intrinsics.checkNotNullExpressionValue(object2, "receiver.ident");
        bl = false;
        String string2 = ((String)object2).toLowerCase();
        Intrinsics.checkNotNullExpressionValue(string2, "(this as java.lang.String).toLowerCase()");
        if (!Intrinsics.areEqual(string2, "kotlin")) return false;
        return true;
    }

    public static final boolean isSpecialFunction(@NotNull JsExpression expr, @NotNull SpecialFunction specialFunction) {
        JsName jsName;
        Intrinsics.checkNotNullParameter(expr, "expr");
        Intrinsics.checkNotNullParameter((Object)specialFunction, "specialFunction");
        return expr instanceof JsNameRef && ((JsNameRef)expr).getQualifier() == null && ((jsName = ((JsNameRef)expr).getName()) == null ? null : MetadataProperties.getSpecialFunction(jsName)) == specialFunction;
    }

    public static final boolean isAmdDefine(@NotNull Context $this$isAmdDefine, @NotNull JsExpression function2) {
        Intrinsics.checkNotNullParameter($this$isAmdDefine, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        return UtilKt.isTopLevelFunction($this$isAmdDefine, function2, "define");
    }

    public static final boolean isTopLevelFunction(@NotNull Context $this$isTopLevelFunction, @NotNull JsExpression function2, @NotNull String name) {
        Intrinsics.checkNotNullParameter($this$isTopLevelFunction, "<this>");
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(name, "name");
        if (!(function2 instanceof JsNameRef) || ((JsNameRef)function2).getQualifier() != null) {
            return false;
        }
        return Intrinsics.areEqual(((JsNameRef)function2).getIdent(), name) && !CollectionsKt.contains((Iterable)$this$isTopLevelFunction.getNodes().keySet(), ((JsNameRef)function2).getName());
    }

    @Nullable
    public static final JsLocation extractLocation(@NotNull JsNode $this$extractLocation) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter($this$extractLocation, "<this>");
        JsNode jsNode = $this$extractLocation;
        JsLocation jsLocation = jsNode instanceof SourceInfoAwareJsNode ? ((object2 = ((SourceInfoAwareJsNode)$this$extractLocation).getSource()) instanceof JsLocation ? (JsLocation)object2 : null) : (jsNode instanceof JsExpressionStatement ? ((object = ((JsExpressionStatement)$this$extractLocation).getExpression().getSource()) instanceof JsLocation ? (JsLocation)object : null) : null);
        return jsLocation;
    }

    @NotNull
    public static final String asString(@NotNull JsLocation $this$asString) {
        Intrinsics.checkNotNullParameter($this$asString, "<this>");
        String string2 = $this$asString.getFile();
        int n = StringsKt.lastIndexOf$default((CharSequence)$this$asString.getFile(), "/", 0, false, 6, null) + 1;
        boolean bl = false;
        String string3 = string2;
        if (string3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkNotNullExpressionValue(string4, "(this as java.lang.String).substring(startIndex)");
        String simpleFileName = string4;
        return simpleFileName + ':' + ($this$asString.getStartLine() + 1);
    }

    @NotNull
    public static final Set<Context.Node> extractRoots(@NotNull Set<Context.Node> $this$extractRoots) {
        Intrinsics.checkNotNullParameter($this$extractRoots, "<this>");
        boolean bl = false;
        Set result2 = new LinkedHashSet();
        boolean bl2 = false;
        Set visited2 = new LinkedHashSet();
        Iterable $this$forEach$iv = $this$extractRoots;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Context.Node it = (Context.Node)element$iv;
            boolean bl3 = false;
            UtilKt.extractRootsImpl(it.getOriginal(), result2, visited2);
        }
        return result2;
    }

    private static final void extractRootsImpl(Context.Node $this$extractRootsImpl, Set<Context.Node> target, Set<Context.Node> visited2) {
        if (!visited2.add($this$extractRootsImpl.getOriginal())) {
            return;
        }
        Context.Qualifier qualifier = $this$extractRootsImpl.getOriginal().getQualifier();
        if (qualifier == null) {
            Collection collection = target;
            Context.Node node = $this$extractRootsImpl.getOriginal();
            boolean bl = false;
            collection.add(node);
        } else {
            UtilKt.extractRootsImpl(qualifier.getParent(), target, visited2);
        }
    }
}

