/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Component;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import mediathek.gui.messages.NotificationCenterChangeEvent;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.MessageBus;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.configuration2.Configuration;

public class PanelNotifications
extends JPanel {
    private JCheckBox cbShowNotifications;
    private JCheckBox cbNativeNotifications;

    public PanelNotifications() {
        this.initComponents();
        Configuration config = ApplicationConfiguration.getConfiguration();
        boolean showNotification = config.getBoolean("application.notifications.show", true);
        this.cbShowNotifications.setSelected(showNotification);
        this.cbShowNotifications.addActionListener(e -> {
            config.setProperty("application.notifications.show", this.cbShowNotifications.isSelected());
            MessageBus.getMessageBus().publishAsync(new NotificationCenterChangeEvent());
        });
        this.cbNativeNotifications.setEnabled(config.getBoolean("application.notifications.native_support", false));
        boolean showNativeNotifications = config.getBoolean("application.notifications.show_native", false);
        this.cbNativeNotifications.setSelected(showNativeNotifications);
        this.cbNativeNotifications.addActionListener(e -> {
            config.setProperty("application.notifications.show_native", this.cbNativeNotifications.isSelected());
            MessageBus.getMessageBus().publishAsync(new NotificationCenterChangeEvent());
        });
    }

    private void initComponents() {
        this.cbShowNotifications = new JCheckBox();
        this.cbNativeNotifications = new JCheckBox();
        this.setLayout(new MigLayout(new LC().hideMode(3), new AC().fill().gap().fill(), new AC().gap().gap()));
        this.cbShowNotifications.setText("Benachrichtigungen anzeigen");
        this.cbShowNotifications.setToolTipText("Zeige Programminformationen als Benachrichtigungen in einem Popup-Fenster an.");
        this.add((Component)this.cbShowNotifications, new CC().cell(0, 0));
        this.cbNativeNotifications.setText("Benachrichtigungen im Betriebssystem anzeigen");
        this.cbNativeNotifications.setToolTipText("Wenn das Betriebssystem unterst\u00fctzt wird, werden die Benachrichtigungen in den vom Betriebssystem bereitgestelltem Benachrichtigungssystem angezeigt anstatt in MediathekView.");
        this.add((Component)this.cbNativeNotifications, new CC().cell(0, 1));
    }
}

