/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

public class Footprint {
    private final int min;
    private final int max;

    public Footprint(int min, int max) {
        if (max < min) {
            throw new IllegalArgumentException();
        }
        assert (max >= min);
        this.min = min;
        this.max = max;
    }

    public String toString() {
        return "" + this.min + " -> " + this.max;
    }

    public Footprint intersection(Footprint other) {
        if (this.max < other.min) {
            return null;
        }
        if (this.min > other.max) {
            return null;
        }
        return new Footprint(Math.max(this.min, other.min), Math.min(this.max, other.max));
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }
}

