/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.version;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.TextBlockBackcolored;
import net.sourceforge.plantuml.ugraphic.AffineTransformType;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.ImageParameter;
import net.sourceforge.plantuml.ugraphic.PixelImage;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.version.License;
import net.sourceforge.plantuml.version.LicenseInfo;

public class PSystemLicense
extends AbstractPSystem
implements UDrawable {
    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        ImageParameter imageParameter = new ImageParameter(new ColorMapperIdentity(), false, null, 1.0, this.getMetadata(), null, ClockwiseTopRightBottomLeft.none(), null);
        ImageBuilder imageBuilder = ImageBuilder.build(imageParameter);
        imageBuilder.setUDrawable(this);
        return imageBuilder.writeImageTOBEMOVED(fileFormat, seed, os);
    }

    public static PSystemLicense create() throws IOException {
        return new PSystemLicense();
    }

    private TextBlockBackcolored getGraphicStrings(List<String> strings) {
        return GraphicStrings.createBlackOnWhite(strings);
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(License)");
    }

    @Override
    public void drawU(UGraphic ug) {
        LicenseInfo licenseInfo = LicenseInfo.retrieveQuick();
        BufferedImage logo = LicenseInfo.retrieveDistributorImage(licenseInfo);
        if (logo == null) {
            ArrayList<String> strings = new ArrayList<String>();
            strings.addAll(License.getCurrent().getText1(licenseInfo));
            strings.addAll(License.getCurrent().getText2(licenseInfo));
            this.getGraphicStrings(strings).drawU(ug);
        } else {
            ArrayList<String> strings1 = new ArrayList<String>();
            ArrayList<String> strings2 = new ArrayList<String>();
            strings1.addAll(License.getCurrent().getText1(licenseInfo));
            strings2.addAll(License.getCurrent().getText2(licenseInfo));
            TextBlockBackcolored result1 = this.getGraphicStrings(strings1);
            result1.drawU(ug);
            ug = ug.apply(UTranslate.dy(4.0 + result1.calculateDimension(ug.getStringBounder()).getHeight()));
            UImage im = new UImage(new PixelImage(logo, AffineTransformType.TYPE_BILINEAR));
            ug.apply(UTranslate.dx(20.0)).draw(im);
            ug = ug.apply(UTranslate.dy(im.getHeight()));
            TextBlockBackcolored result2 = this.getGraphicStrings(strings2);
            result2.drawU(ug);
        }
    }
}

