/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.common.ExtBasicSpinnerLayout;
import com.jgoodies.looks.plastic.PlasticArrowButton;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSpinnerUI;

public class PlasticSpinnerUI
extends BasicSpinnerUI {
    public static ComponentUI createUI(JComponent b) {
        return new PlasticSpinnerUI();
    }

    protected Component createArrowButton(int direction) {
        return new SpinnerArrowButton(direction);
    }

    @Override
    protected LayoutManager createLayout() {
        return new ExtBasicSpinnerLayout();
    }

    @Override
    protected JComponent createEditor() {
        JComponent editor = this.spinner.getEditor();
        PlasticSpinnerUI.configureEditorBorder(editor);
        return editor;
    }

    @Override
    protected void replaceEditor(JComponent oldEditor, JComponent newEditor) {
        this.spinner.remove(oldEditor);
        PlasticSpinnerUI.configureEditorBorder(newEditor);
        this.spinner.add((Component)newEditor, "Editor");
    }

    private static void configureEditorBorder(JComponent editor) {
        if (editor instanceof JSpinner.DefaultEditor) {
            JSpinner.DefaultEditor defaultEditor = (JSpinner.DefaultEditor)editor;
            JFormattedTextField editorField = defaultEditor.getTextField();
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        } else if (editor instanceof JPanel && editor.getBorder() == null && editor.getComponentCount() > 0) {
            JComponent editorField = (JComponent)editor.getComponent(0);
            Insets insets = UIManager.getInsets("Spinner.defaultEditorInsets");
            editorField.setBorder(new EmptyBorder(insets));
        }
    }

    private static final class SpinnerArrowButton
    extends PlasticArrowButton {
        private SpinnerArrowButton(int direction) {
            super(direction, UIManager.getInt("ScrollBar.width"), true);
        }

        @Override
        protected int calculateArrowHeight(int height, int width) {
            int arrowHeight = Math.min((height - 4) / 3, (width - 4) / 3);
            return Math.max(arrowHeight, 3);
        }

        @Override
        protected int calculateArrowOffset() {
            return 1;
        }

        @Override
        protected boolean isPaintingNorthBottom() {
            return true;
        }
    }
}

