/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class TableUtils {
    public static void pack(JTable table, boolean packColumns, boolean packRows, int padding) {
        Enumeration<TableColumn> cols = table.getColumnModel().getColumns();
        int[] rowHeights = new int[table.getRowCount()];
        while (cols.hasMoreElements()) {
            TableColumn tc = cols.nextElement();
            int colIndex = tc.getModelIndex();
            int width = 0;
            if (packColumns) {
                JTableHeader header;
                TableCellRenderer renderer = tc.getHeaderRenderer();
                if (renderer == null && (header = table.getTableHeader()) != null) {
                    renderer = header.getDefaultRenderer();
                }
                if (renderer != null) {
                    Component comp = renderer.getTableCellRendererComponent(table, tc.getHeaderValue(), false, false, 0, 0);
                    width = comp.getPreferredSize().width;
                }
            }
            for (int row = 0; row < table.getRowCount(); ++row) {
                TableCellRenderer renderer = table.getCellRenderer(row, colIndex);
                Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(row, colIndex), false, false, row, colIndex);
                Dimension prefSize = comp.getPreferredSize();
                if (packRows) {
                    rowHeights[row] = Math.max(rowHeights[row], prefSize.height);
                }
                if (!packColumns) continue;
                width = Math.max(width, prefSize.width);
            }
            if (!packColumns) continue;
            tc.setPreferredWidth(width);
        }
        if (packRows) {
            for (int row = 0; row < rowHeights.length; ++row) {
                table.setRowHeight(row, rowHeights[row] + 2 * padding);
            }
        }
    }
}

