/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor.ontology;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.protege.editor.owl.model.refactor.ontology.OntologyIDChangeStrategy;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.util.OWLEntityRenamer;

public class EntityIRIUpdaterOntologyChangeStrategy
implements OntologyIDChangeStrategy {
    @Override
    public List<OWLOntologyChange> getChangesForRename(OWLOntology ontology, OWLOntologyID from, OWLOntologyID to) {
        if (!this.isEntityRenamingChange(from, to)) {
            return Collections.emptyList();
        }
        HashMap<OWLEntity, IRI> renameMap = new HashMap<OWLEntity, IRI>();
        this.getRenameMap(ontology, from, to, renameMap, Long.MAX_VALUE);
        OWLEntityRenamer entityRenamer = new OWLEntityRenamer(ontology.getOWLOntologyManager(), Collections.singleton(ontology));
        return entityRenamer.changeIRI(renameMap);
    }

    private boolean isEntityRenamingChange(OWLOntologyID from, OWLOntologyID to) {
        return !from.isAnonymous() && !to.isAnonymous() && !from.equals((Object)to);
    }

    private void getRenameMap(OWLOntology ontology, OWLOntologyID fromId, OWLOntologyID toId, Map<OWLEntity, IRI> renameMap, long limit) {
        if (!this.isEntityRenamingChange(fromId, toId)) {
            return;
        }
        String fromBase = ((IRI)fromId.getOntologyIRI().get()).toString();
        String toBase = ((IRI)toId.getOntologyIRI().get()).toString();
        this.getEntitiesRenamings(ontology.getObjectPropertiesInSignature(false), fromBase, toBase, renameMap, limit);
        if ((long)renameMap.size() >= limit) {
            return;
        }
        this.getEntitiesRenamings(ontology.getDataPropertiesInSignature(false), fromBase, toBase, renameMap, limit);
        if ((long)renameMap.size() >= limit) {
            return;
        }
        this.getEntitiesRenamings(ontology.getAnnotationPropertiesInSignature(), fromBase, toBase, renameMap, limit);
        if ((long)renameMap.size() >= limit) {
            return;
        }
        this.getEntitiesRenamings(ontology.getClassesInSignature(false), fromBase, toBase, renameMap, limit);
        if ((long)renameMap.size() >= limit) {
            return;
        }
        this.getEntitiesRenamings(ontology.getIndividualsInSignature(false), fromBase, toBase, renameMap, limit);
        if ((long)renameMap.size() >= limit) {
            return;
        }
        this.getEntitiesRenamings(ontology.getDatatypesInSignature(false), fromBase, toBase, renameMap, limit);
    }

    public boolean hasEntitiesToRename(OWLOntology ontology, OWLOntologyID from, OWLOntologyID to) {
        HashMap<OWLEntity, IRI> renameMap = new HashMap<OWLEntity, IRI>();
        this.getRenameMap(ontology, from, to, renameMap, 1L);
        return !renameMap.isEmpty();
    }

    public Set<OWLEntity> getEntitiesToRename(OWLOntology ontology, OWLOntologyID from, OWLOntologyID to) {
        if (!this.isEntityRenamingChange(from, to)) {
            return Collections.emptySet();
        }
        HashMap<OWLEntity, IRI> renameMap = new HashMap<OWLEntity, IRI>();
        this.getRenameMap(ontology, from, to, renameMap, Long.MAX_VALUE);
        return renameMap.keySet();
    }

    private void getEntitiesRenamings(Set<? extends OWLEntity> entities, String base, String toBase, Map<OWLEntity, IRI> renameMap, long limit) {
        int counter = 0;
        for (OWLEntity oWLEntity : entities) {
            IRI entityIRI = oWLEntity.getIRI();
            if (entityIRI.length() <= base.length() || !entityIRI.subSequence(0, base.length()).equals(base)) continue;
            renameMap.put(oWLEntity, IRI.create((String)(toBase + entityIRI.subSequence(base.length(), entityIRI.length()))));
            if ((long)(++counter) < limit) continue;
            return;
        }
    }
}

