/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.styledstring;

import java.awt.Color;
import java.awt.font.TextAttribute;
import java.text.AttributedCharacterIterator;
import javax.swing.text.StyleConstants;
import org.protege.editor.owl.ui.renderer.styledstring.CSSConstants;
import org.protege.editor.owl.ui.renderer.styledstring.StyleAttribute;

public class ForegroundAttribute
extends StyleAttribute {
    private static final ForegroundAttribute BLACK = new ForegroundAttribute(Color.BLACK);
    private Color foreground;

    private ForegroundAttribute(Color foreground) {
        this.foreground = foreground;
    }

    public static ForegroundAttribute get(Color foreground) {
        return new ForegroundAttribute(foreground);
    }

    @Override
    public String getCSSPropertyName() {
        return CSSConstants.COLOR.getName();
    }

    @Override
    public String getCSSValue() {
        return String.format("#%06x", this.foreground.getRGB() & 0xFFFFFF);
    }

    @Override
    public AttributedCharacterIterator.Attribute getAttributedStringAttribute() {
        return TextAttribute.FOREGROUND;
    }

    @Override
    public Object getAttributesStringValue() {
        return this.foreground;
    }

    public Color getForeground() {
        return this.foreground;
    }

    public ForegroundAttribute getBlack() {
        return BLACK;
    }

    @Override
    public StyleConstants getTextAttribute() {
        return (StyleConstants.ColorConstants)StyleConstants.Foreground;
    }

    @Override
    public Object getTextValue() {
        return this.foreground;
    }

    public int hashCode() {
        return ForegroundAttribute.class.getSimpleName().hashCode() + this.foreground.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ForegroundAttribute)) {
            return false;
        }
        ForegroundAttribute other = (ForegroundAttribute)obj;
        return this.foreground.equals(other.foreground);
    }
}

