// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-avr.go from ATmega64M1.atdf, see http://packs.download.atmel.com/

// +build avr,atmega64m1

// Device information for the ATmega64M1.
package avr

import (
	"runtime/interrupt"
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	DEVICE = "ATmega64M1"
	ARCH   = "AVR8"
	FAMILY = "megaAVR"
)

// Interrupts
const (
	IRQ_RESET        = 0  // External Pin, Power-on Reset, Brown-out Reset, Watchdog Reset and JTAG AVR Reset
	IRQ_ANACOMP0     = 1  // Analog Comparator 0
	IRQ_ANACOMP1     = 2  // Analog Comparator 1
	IRQ_ANACOMP2     = 3  // Analog Comparator 2
	IRQ_ANACOMP3     = 4  // Analog Comparator 3
	IRQ_PSC_FAULT    = 5  // PSC Fault
	IRQ_PSC_EC       = 6  // PSC End of Cycle
	IRQ_INT0         = 7  // External Interrupt Request 0
	IRQ_INT1         = 8  // External Interrupt Request 1
	IRQ_INT2         = 9  // External Interrupt Request 2
	IRQ_INT3         = 10 // External Interrupt Request 3
	IRQ_TIMER1_CAPT  = 11 // Timer/Counter1 Capture Event
	IRQ_TIMER1_COMPA = 12 // Timer/Counter1 Compare Match A
	IRQ_TIMER1_COMPB = 13 // Timer/Counter1 Compare Match B
	IRQ_TIMER1_OVF   = 14 // Timer1/Counter1 Overflow
	IRQ_TIMER0_COMPA = 15 // Timer/Counter0 Compare Match A
	IRQ_TIMER0_COMPB = 16 // Timer/Counter0 Compare Match B
	IRQ_TIMER0_OVF   = 17 // Timer/Counter0 Overflow
	IRQ_CAN_INT      = 18 // CAN MOB, Burst, General Errors
	IRQ_CAN_TOVF     = 19 // CAN Timer Overflow
	IRQ_LIN_TC       = 20 // LIN Transfer Complete
	IRQ_LIN_ERR      = 21 // LIN Error
	IRQ_PCINT0       = 22 // Pin Change Interrupt Request 0
	IRQ_PCINT1       = 23 // Pin Change Interrupt Request 1
	IRQ_PCINT2       = 24 // Pin Change Interrupt Request 2
	IRQ_PCINT3       = 25 // Pin Change Interrupt Request 3
	IRQ_SPI_STC      = 26 // SPI Serial Transfer Complete
	IRQ_ADC          = 27 // ADC Conversion Complete
	IRQ_WDT          = 28 // Watchdog Time-Out Interrupt
	IRQ_EE_READY     = 29 // EEPROM Ready
	IRQ_SPM_READY    = 30 // Store Program Memory Read
	IRQ_max          = 30 // Highest interrupt number on this device.
)

// Map interrupt numbers to function names.
// These aren't real calls, they're removed by the compiler.
var (
	_ = interrupt.Register(IRQ_RESET, "__vector_RESET")
	_ = interrupt.Register(IRQ_ANACOMP0, "__vector_ANACOMP0")
	_ = interrupt.Register(IRQ_ANACOMP1, "__vector_ANACOMP1")
	_ = interrupt.Register(IRQ_ANACOMP2, "__vector_ANACOMP2")
	_ = interrupt.Register(IRQ_ANACOMP3, "__vector_ANACOMP3")
	_ = interrupt.Register(IRQ_PSC_FAULT, "__vector_PSC_FAULT")
	_ = interrupt.Register(IRQ_PSC_EC, "__vector_PSC_EC")
	_ = interrupt.Register(IRQ_INT0, "__vector_INT0")
	_ = interrupt.Register(IRQ_INT1, "__vector_INT1")
	_ = interrupt.Register(IRQ_INT2, "__vector_INT2")
	_ = interrupt.Register(IRQ_INT3, "__vector_INT3")
	_ = interrupt.Register(IRQ_TIMER1_CAPT, "__vector_TIMER1_CAPT")
	_ = interrupt.Register(IRQ_TIMER1_COMPA, "__vector_TIMER1_COMPA")
	_ = interrupt.Register(IRQ_TIMER1_COMPB, "__vector_TIMER1_COMPB")
	_ = interrupt.Register(IRQ_TIMER1_OVF, "__vector_TIMER1_OVF")
	_ = interrupt.Register(IRQ_TIMER0_COMPA, "__vector_TIMER0_COMPA")
	_ = interrupt.Register(IRQ_TIMER0_COMPB, "__vector_TIMER0_COMPB")
	_ = interrupt.Register(IRQ_TIMER0_OVF, "__vector_TIMER0_OVF")
	_ = interrupt.Register(IRQ_CAN_INT, "__vector_CAN_INT")
	_ = interrupt.Register(IRQ_CAN_TOVF, "__vector_CAN_TOVF")
	_ = interrupt.Register(IRQ_LIN_TC, "__vector_LIN_TC")
	_ = interrupt.Register(IRQ_LIN_ERR, "__vector_LIN_ERR")
	_ = interrupt.Register(IRQ_PCINT0, "__vector_PCINT0")
	_ = interrupt.Register(IRQ_PCINT1, "__vector_PCINT1")
	_ = interrupt.Register(IRQ_PCINT2, "__vector_PCINT2")
	_ = interrupt.Register(IRQ_PCINT3, "__vector_PCINT3")
	_ = interrupt.Register(IRQ_SPI_STC, "__vector_SPI_STC")
	_ = interrupt.Register(IRQ_ADC, "__vector_ADC")
	_ = interrupt.Register(IRQ_WDT, "__vector_WDT")
	_ = interrupt.Register(IRQ_EE_READY, "__vector_EE_READY")
	_ = interrupt.Register(IRQ_SPM_READY, "__vector_SPM_READY")
)

// Peripherals.
var (
	// Fuses
	EXTENDED = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2)))
	HIGH     = (*volatile.Register8)(unsafe.Pointer(uintptr(0x1)))
	LOW      = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// Lockbits
	LOCKBIT = (*volatile.Register8)(unsafe.Pointer(uintptr(0x0)))

	// I/O Port
	PORTB = (*volatile.Register8)(unsafe.Pointer(uintptr(0x25)))
	DDRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x24)))
	PINB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x23)))
	PORTC = (*volatile.Register8)(unsafe.Pointer(uintptr(0x28)))
	DDRC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x27)))
	PINC  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x26)))
	PORTD = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2b)))
	DDRD  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2a)))
	PIND  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x29)))
	PORTE = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2e)))
	DDRE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2d)))
	PINE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x2c)))

	// Controller Area Network
	CANGCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd8)))
	CANGSTA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd9)))
	CANGIT   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xda)))
	CANGIE   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdb)))
	CANEN2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdc)))
	CANEN1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdd)))
	CANIE2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xde)))
	CANIE1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xdf)))
	CANSIT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe0)))
	CANSIT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe1)))
	CANBT1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe2)))
	CANBT2   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe3)))
	CANBT3   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe4)))
	CANTCON  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe5)))
	CANTIML  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe6)))
	CANTIMH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe7)))
	CANTTCL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe8)))
	CANTTCH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xe9)))
	CANTEC   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xea)))
	CANREC   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xeb)))
	CANHPMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xec)))
	CANPAGE  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xed)))
	CANSTMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xee)))
	CANCDMOB = (*volatile.Register8)(unsafe.Pointer(uintptr(0xef)))
	CANIDT4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf0)))
	CANIDT3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf1)))
	CANIDT2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf2)))
	CANIDT1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf3)))
	CANIDM4  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf4)))
	CANIDM3  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf5)))
	CANIDM2  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf6)))
	CANIDM1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf7)))
	CANSTML  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf8)))
	CANSTMH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xf9)))
	CANMSG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xfa)))

	// Analog Comparator
	AC0CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x94)))
	AC1CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x95)))
	AC2CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x96)))
	AC3CON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x97)))
	ACSR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x50)))

	// Digital-to-Analog Converter
	DACH  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x92)))
	DACL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x91)))
	DACON = (*volatile.Register8)(unsafe.Pointer(uintptr(0x90)))

	// CPU Registers
	SPMCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x57)))
	SREG   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5f)))
	SPL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5d)))
	SPH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x5e)))
	MCUCR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x55)))
	MCUSR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x54)))
	OSCCAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x66)))
	CLKPR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x61)))
	SMCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x53)))
	GPIOR2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3a)))
	GPIOR1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x39)))
	GPIOR0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3e)))
	PLLCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x49)))
	PRR    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x64)))

	// Timer/Counter, 8-bit
	TIMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6e)))
	TIFR0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x35)))
	TCCR0A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x44)))
	TCCR0B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x45)))
	TCNT0  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x46)))
	OCR0A  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x47)))
	OCR0B  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x48)))

	// Timer/Counter, 16-bit
	TIMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6f)))
	TIFR1  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x36)))
	TCCR1A = (*volatile.Register8)(unsafe.Pointer(uintptr(0x80)))
	TCCR1B = (*volatile.Register8)(unsafe.Pointer(uintptr(0x81)))
	TCCR1C = (*volatile.Register8)(unsafe.Pointer(uintptr(0x82)))
	TCNT1L = (*volatile.Register8)(unsafe.Pointer(uintptr(0x84)))
	TCNT1H = (*volatile.Register8)(unsafe.Pointer(uintptr(0x85)))
	OCR1AL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x88)))
	OCR1AH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x89)))
	OCR1BL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8a)))
	OCR1BH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x8b)))
	ICR1L  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x86)))
	ICR1H  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x87)))

	// Analog-to-Digital Converter
	ADMUX   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7c)))
	ADCSRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7a)))
	ADCL    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x78)))
	ADCH    = (*volatile.Register8)(unsafe.Pointer(uintptr(0x79)))
	ADCSRB  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7b)))
	DIDR0   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7e)))
	DIDR1   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x7f)))
	AMP0CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x75)))
	AMP1CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x76)))
	AMP2CSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x77)))

	// Local Interconnect Network
	LINCR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc8)))
	LINSIR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xc9)))
	LINENIR = (*volatile.Register8)(unsafe.Pointer(uintptr(0xca)))
	LINERR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcb)))
	LINBTR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcc)))
	LINBRRL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcd)))
	LINBRRH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xce)))
	LINDLR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xcf)))
	LINIDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd0)))
	LINSEL  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd1)))
	LINDAT  = (*volatile.Register8)(unsafe.Pointer(uintptr(0xd2)))

	// Serial Peripheral Interface
	SPCR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4c)))
	SPSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4d)))
	SPDR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x4e)))

	// Watchdog Timer
	WDTCSR = (*volatile.Register8)(unsafe.Pointer(uintptr(0x60)))

	// External Interrupts
	EICRA  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x69)))
	EIMSK  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3d)))
	EIFR   = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3c)))
	PCICR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x68)))
	PCMSK3 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6d)))
	PCMSK2 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6c)))
	PCMSK1 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6b)))
	PCMSK0 = (*volatile.Register8)(unsafe.Pointer(uintptr(0x6a)))
	PCIFR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3b)))

	// EEPROM
	EEARL = (*volatile.Register8)(unsafe.Pointer(uintptr(0x41)))
	EEARH = (*volatile.Register8)(unsafe.Pointer(uintptr(0x42)))
	EEDR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x40)))
	EECR  = (*volatile.Register8)(unsafe.Pointer(uintptr(0x3f)))

	// Power Stage Controller
	PIFR     = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbc)))
	PIM      = (*volatile.Register8)(unsafe.Pointer(uintptr(0xbb)))
	PMIC2    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xba)))
	PMIC1    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb9)))
	PMIC0    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb8)))
	PCTL     = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb7)))
	POC      = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb6)))
	PCNF     = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb5)))
	PSYNC    = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb4)))
	POCR_RBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb2)))
	POCR_RBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb3)))
	POCR2SBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb0)))
	POCR2SBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xb1)))
	POCR2RAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xae)))
	POCR2RAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaf)))
	POCR2SAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xac)))
	POCR2SAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xad)))
	POCR1SBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xaa)))
	POCR1SBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xab)))
	POCR1RAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa8)))
	POCR1RAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa9)))
	POCR1SAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa6)))
	POCR1SAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa7)))
	POCR0SBL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa4)))
	POCR0SBH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa5)))
	POCR0RAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa2)))
	POCR0RAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa3)))
	POCR0SAL = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa0)))
	POCR0SAH = (*volatile.Register8)(unsafe.Pointer(uintptr(0xa1)))
)

// Bitfields for FUSE: Fuses
const (
	// EXTENDED
	EXTENDED_PSCRB     = 0x20 // PSC Reset Behavior
	EXTENDED_PSCRVA    = 0x10 // PSCOUTnA Reset Value
	EXTENDED_PSCRVB    = 0x8  // PSC0UTnB Reset Value
	EXTENDED_BODLEVEL0 = 0x1  // Brown-out Detector Trigger Level
	EXTENDED_BODLEVEL1 = 0x2  // Brown-out Detector Trigger Level
	EXTENDED_BODLEVEL2 = 0x4  // Brown-out Detector Trigger Level

	// HIGH
	HIGH_RSTDISBL = 0x80 // Reset Disabled (Enable PC6 as i/o pin)
	HIGH_DWEN     = 0x40 // Debug Wire enable
	HIGH_SPIEN    = 0x20 // Serial program downloading (SPI) enabled
	HIGH_WDTON    = 0x10 // Watch-dog Timer always on
	HIGH_EESAVE   = 0x8  // Preserve EEPROM through the Chip Erase cycle
	HIGH_BOOTSZ0  = 0x2  // Select Boot Size
	HIGH_BOOTSZ1  = 0x4  // Select Boot Size
	HIGH_BOOTRST  = 0x1  // Select Reset Vector

	// LOW
	LOW_CKDIV8     = 0x80 // Divide clock by 8 internally
	LOW_CKOUT      = 0x40 // Clock output on PORTD1
	LOW_SUT_CKSEL0 = 0x1  // Select Clock Source
	LOW_SUT_CKSEL1 = 0x2  // Select Clock Source
	LOW_SUT_CKSEL2 = 0x4  // Select Clock Source
	LOW_SUT_CKSEL3 = 0x8  // Select Clock Source
	LOW_SUT_CKSEL4 = 0x10 // Select Clock Source
	LOW_SUT_CKSEL5 = 0x20 // Select Clock Source
)

// Bitfields for LOCKBIT: Lockbits
const (
	// LOCKBIT
	LOCKBIT_LB0   = 0x1  // Memory Lock
	LOCKBIT_LB1   = 0x2  // Memory Lock
	LOCKBIT_BLB00 = 0x4  // Boot Loader Protection Mode
	LOCKBIT_BLB01 = 0x8  // Boot Loader Protection Mode
	LOCKBIT_BLB10 = 0x10 // Boot Loader Protection Mode
	LOCKBIT_BLB11 = 0x20 // Boot Loader Protection Mode
)

// Bitfields for CAN: Controller Area Network
const (
	// CANGCON: CAN General Control Register
	CANGCON_ABRQ   = 0x80 // Abort Request
	CANGCON_OVRQ   = 0x40 // Overload Frame Request
	CANGCON_TTC    = 0x20 // Time Trigger Communication
	CANGCON_SYNTTC = 0x10 // Synchronization of TTC
	CANGCON_LISTEN = 0x8  // Listening Mode
	CANGCON_TEST   = 0x4  // Test Mode
	CANGCON_ENASTB = 0x2  // Enable / Standby
	CANGCON_SWRES  = 0x1  // Software Reset Request

	// CANGSTA: CAN General Status Register
	CANGSTA_OVFG  = 0x40 // Overload Frame Flag
	CANGSTA_TXBSY = 0x10 // Transmitter Busy
	CANGSTA_RXBSY = 0x8  // Receiver Busy
	CANGSTA_ENFG  = 0x4  // Enable Flag
	CANGSTA_BOFF  = 0x2  // Bus Off Mode
	CANGSTA_ERRP  = 0x1  // Error Passive Mode

	// CANGIT: CAN General Interrupt Register Flags
	CANGIT_CANIT  = 0x80 // General Interrupt Flag
	CANGIT_BOFFIT = 0x40 // Bus Off Interrupt Flag
	CANGIT_OVRTIM = 0x20 // Overrun CAN Timer Flag
	CANGIT_BXOK   = 0x10 // Burst Receive Interrupt Flag
	CANGIT_SERG   = 0x8  // Stuff Error General Flag
	CANGIT_CERG   = 0x4  // CRC Error General Flag
	CANGIT_FERG   = 0x2  // Form Error General Flag
	CANGIT_AERG   = 0x1  // Ackknowledgement Error General Flag

	// CANGIE: CAN General Interrupt Enable Register
	CANGIE_ENIT   = 0x80 // Enable all Interrupts
	CANGIE_ENBOFF = 0x40 // Enable Bus Off Interrupt
	CANGIE_ENRX   = 0x20 // Enable Receive Interrupt
	CANGIE_ENTX   = 0x10 // Enable Transmitt Interrupt
	CANGIE_ENERR  = 0x8  // Enable MOb Error Interrupt
	CANGIE_ENBX   = 0x4  // Enable Burst Receive Interrupt
	CANGIE_ENERG  = 0x2  // Enable General Error Interrupt
	CANGIE_ENOVRT = 0x1  // Enable CAN Timer Overrun Interrupt

	// CANEN2: Enable MOb Register 2
	CANEN2_ENMOB0 = 0x1  // Enable MObs
	CANEN2_ENMOB1 = 0x2  // Enable MObs
	CANEN2_ENMOB2 = 0x4  // Enable MObs
	CANEN2_ENMOB3 = 0x8  // Enable MObs
	CANEN2_ENMOB4 = 0x10 // Enable MObs
	CANEN2_ENMOB5 = 0x20 // Enable MObs

	// CANIE2: Enable Interrupt MOb Register 2
	CANIE2_IEMOB0 = 0x1  // Interrupt Enable  MObs
	CANIE2_IEMOB1 = 0x2  // Interrupt Enable  MObs
	CANIE2_IEMOB2 = 0x4  // Interrupt Enable  MObs
	CANIE2_IEMOB3 = 0x8  // Interrupt Enable  MObs
	CANIE2_IEMOB4 = 0x10 // Interrupt Enable  MObs
	CANIE2_IEMOB5 = 0x20 // Interrupt Enable  MObs

	// CANSIT2: CAN Status Interrupt MOb Register 2
	CANSIT2_SIT0 = 0x1  // Status of Interrupt MObs
	CANSIT2_SIT1 = 0x2  // Status of Interrupt MObs
	CANSIT2_SIT2 = 0x4  // Status of Interrupt MObs
	CANSIT2_SIT3 = 0x8  // Status of Interrupt MObs
	CANSIT2_SIT4 = 0x10 // Status of Interrupt MObs
	CANSIT2_SIT5 = 0x20 // Status of Interrupt MObs

	// CANBT1: CAN Bit Timing Register 1
	CANBT1_BRP0 = 0x2  // Baud Rate Prescaler bits
	CANBT1_BRP1 = 0x4  // Baud Rate Prescaler bits
	CANBT1_BRP2 = 0x8  // Baud Rate Prescaler bits
	CANBT1_BRP3 = 0x10 // Baud Rate Prescaler bits
	CANBT1_BRP4 = 0x20 // Baud Rate Prescaler bits
	CANBT1_BRP5 = 0x40 // Baud Rate Prescaler bits

	// CANBT2: CAN Bit Timing Register 2
	CANBT2_SJW0 = 0x20 // Re-Sync Jump Width bits
	CANBT2_SJW1 = 0x40 // Re-Sync Jump Width bits
	CANBT2_PRS0 = 0x2  // Propagation Time Segment bits
	CANBT2_PRS1 = 0x4  // Propagation Time Segment bits
	CANBT2_PRS2 = 0x8  // Propagation Time Segment bits

	// CANBT3: CAN Bit Timing Register 3
	CANBT3_PHS20 = 0x10 // Phase Segment 2 bits
	CANBT3_PHS21 = 0x20 // Phase Segment 2 bits
	CANBT3_PHS22 = 0x40 // Phase Segment 2 bits
	CANBT3_PHS10 = 0x2  // Phase Segment 1 bits
	CANBT3_PHS11 = 0x4  // Phase Segment 1 bits
	CANBT3_PHS12 = 0x8  // Phase Segment 1 bits
	CANBT3_SMP   = 0x1  // Sample Type

	// CANHPMOB: Highest Priority MOb Register
	CANHPMOB_HPMOB0 = 0x10 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB1 = 0x20 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB2 = 0x40 // Highest Priority MOb Number bits
	CANHPMOB_HPMOB3 = 0x80 // Highest Priority MOb Number bits
	CANHPMOB_CGP0   = 0x1  // CAN General Purpose bits
	CANHPMOB_CGP1   = 0x2  // CAN General Purpose bits
	CANHPMOB_CGP2   = 0x4  // CAN General Purpose bits
	CANHPMOB_CGP3   = 0x8  // CAN General Purpose bits

	// CANPAGE: Page MOb Register
	CANPAGE_MOBNB0 = 0x10 // MOb Number bits
	CANPAGE_MOBNB1 = 0x20 // MOb Number bits
	CANPAGE_MOBNB2 = 0x40 // MOb Number bits
	CANPAGE_MOBNB3 = 0x80 // MOb Number bits
	CANPAGE_AINC   = 0x8  // MOb Data Buffer Auto Increment (Active Low)
	CANPAGE_INDX0  = 0x1  // Data Buffer Index bits
	CANPAGE_INDX1  = 0x2  // Data Buffer Index bits
	CANPAGE_INDX2  = 0x4  // Data Buffer Index bits

	// CANSTMOB: MOb Status Register
	CANSTMOB_DLCW = 0x80 // Data Length Code Warning on MOb
	CANSTMOB_TXOK = 0x40 // Transmit OK on MOb
	CANSTMOB_RXOK = 0x20 // Receive OK on MOb
	CANSTMOB_BERR = 0x10 // Bit Error on MOb
	CANSTMOB_SERR = 0x8  // Stuff Error on MOb
	CANSTMOB_CERR = 0x4  // CRC Error on MOb
	CANSTMOB_FERR = 0x2  // Form Error on MOb
	CANSTMOB_AERR = 0x1  // Ackknowledgement Error on MOb

	// CANCDMOB: MOb Control and DLC Register
	CANCDMOB_CONMOB0 = 0x40 // MOb Config bits
	CANCDMOB_CONMOB1 = 0x80 // MOb Config bits
	CANCDMOB_RPLV    = 0x20 // Reply Valid
	CANCDMOB_IDE     = 0x10 // Identifier Extension
	CANCDMOB_DLC0    = 0x1  // Data Length Code bits
	CANCDMOB_DLC1    = 0x2  // Data Length Code bits
	CANCDMOB_DLC2    = 0x4  // Data Length Code bits
	CANCDMOB_DLC3    = 0x8  // Data Length Code bits

	// CANIDT4: Identifier Tag Register 4
	CANIDT4_IDT0   = 0x8
	CANIDT4_IDT1   = 0x10
	CANIDT4_IDT2   = 0x20
	CANIDT4_IDT3   = 0x40
	CANIDT4_IDT4   = 0x80
	CANIDT4_RTRTAG = 0x4
	CANIDT4_RB1TAG = 0x2
	CANIDT4_RB0TAG = 0x1
)

// Bitfields for AC: Analog Comparator
const (
	// AC0CON: Analog Comparator 0 Control Register
	AC0CON_AC0EN   = 0x80 // Analog Comparator 0 Enable Bit
	AC0CON_AC0IE   = 0x40 // Analog Comparator 0 Interrupt Enable Bit
	AC0CON_AC0IS0  = 0x10 // Analog Comparator 0  Interrupt Select Bits
	AC0CON_AC0IS1  = 0x20 // Analog Comparator 0  Interrupt Select Bits
	AC0CON_ACCKSEL = 0x8  // Analog Comparator Clock Select
	AC0CON_AC0M0   = 0x1  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M1   = 0x2  // Analog Comparator 0 Multiplexer Register
	AC0CON_AC0M2   = 0x4  // Analog Comparator 0 Multiplexer Register

	// AC1CON: Analog Comparator 1 Control Register
	AC1CON_AC1EN  = 0x80 // Analog Comparator 1 Enable Bit
	AC1CON_AC1IE  = 0x40 // Analog Comparator 1 Interrupt Enable Bit
	AC1CON_AC1IS0 = 0x10 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1IS1 = 0x20 // Analog Comparator 1  Interrupt Select Bit
	AC1CON_AC1ICE = 0x8  // Analog Comparator 1 Interrupt Capture Enable Bit
	AC1CON_AC1M0  = 0x1  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M1  = 0x2  // Analog Comparator 1 Multiplexer Register
	AC1CON_AC1M2  = 0x4  // Analog Comparator 1 Multiplexer Register

	// AC2CON: Analog Comparator 2 Control Register
	AC2CON_AC2EN  = 0x80 // Analog Comparator 2 Enable Bit
	AC2CON_AC2IE  = 0x40 // Analog Comparator 2 Interrupt Enable Bit
	AC2CON_AC2IS0 = 0x10 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2IS1 = 0x20 // Analog Comparator 2  Interrupt Select Bit
	AC2CON_AC2M0  = 0x1  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M1  = 0x2  // Analog Comparator 2 Multiplexer Register
	AC2CON_AC2M2  = 0x4  // Analog Comparator 2 Multiplexer Register

	// AC3CON: Analog Comparator 3 Control Register
	AC3CON_AC3EN  = 0x80 // Analog Comparator 3 Enable Bit
	AC3CON_AC3IE  = 0x40 // Analog Comparator 3 Interrupt Enable Bit
	AC3CON_AC3IS0 = 0x10 // Analog Comparator 3  Interrupt Select Bit
	AC3CON_AC3IS1 = 0x20 // Analog Comparator 3  Interrupt Select Bit
	AC3CON_AC3M0  = 0x1  // Analog Comparator 3 Multiplexer Register
	AC3CON_AC3M1  = 0x2  // Analog Comparator 3 Multiplexer Register
	AC3CON_AC3M2  = 0x4  // Analog Comparator 3 Multiplexer Register

	// ACSR: Analog Comparator Status Register
	ACSR_AC3IF = 0x80 // Analog Comparator 3 Interrupt Flag Bit
	ACSR_AC2IF = 0x40 // Analog Comparator 2 Interrupt Flag Bit
	ACSR_AC1IF = 0x20 // Analog Comparator 1  Interrupt Flag Bit
	ACSR_AC0IF = 0x10 // Analog Comparator 0 Interrupt Flag Bit
	ACSR_AC3O  = 0x8  // Analog Comparator 3 Output Bit
	ACSR_AC2O  = 0x4  // Analog Comparator 2 Output Bit
	ACSR_AC1O  = 0x2  // Analog Comparator 1 Output Bit
	ACSR_AC0O  = 0x1  // Analog Comparator 0 Output Bit
)

// Bitfields for DAC: Digital-to-Analog Converter
const (
	// DACH: DAC Data Register High Byte
	DACH_DACH0 = 0x1  // DAC Data Register High Byte Bits
	DACH_DACH1 = 0x2  // DAC Data Register High Byte Bits
	DACH_DACH2 = 0x4  // DAC Data Register High Byte Bits
	DACH_DACH3 = 0x8  // DAC Data Register High Byte Bits
	DACH_DACH4 = 0x10 // DAC Data Register High Byte Bits
	DACH_DACH5 = 0x20 // DAC Data Register High Byte Bits
	DACH_DACH6 = 0x40 // DAC Data Register High Byte Bits
	DACH_DACH7 = 0x80 // DAC Data Register High Byte Bits

	// DACL: DAC Data Register Low Byte
	DACL_DACL0 = 0x1  // DAC Data Register Low Byte Bits
	DACL_DACL1 = 0x2  // DAC Data Register Low Byte Bits
	DACL_DACL2 = 0x4  // DAC Data Register Low Byte Bits
	DACL_DACL3 = 0x8  // DAC Data Register Low Byte Bits
	DACL_DACL4 = 0x10 // DAC Data Register Low Byte Bits
	DACL_DACL5 = 0x20 // DAC Data Register Low Byte Bits
	DACL_DACL6 = 0x40 // DAC Data Register Low Byte Bits
	DACL_DACL7 = 0x80 // DAC Data Register Low Byte Bits

	// DACON: DAC Control Register
	DACON_DAATE = 0x80 // DAC Auto Trigger Enable Bit
	DACON_DATS0 = 0x10 // DAC Trigger Selection Bits
	DACON_DATS1 = 0x20 // DAC Trigger Selection Bits
	DACON_DATS2 = 0x40 // DAC Trigger Selection Bits
	DACON_DALA  = 0x4  // DAC Left Adjust
	DACON_DAEN  = 0x1  // DAC Enable Bit
)

// Bitfields for CPU: CPU Registers
const (
	// SPMCSR: Store Program Memory Control Register
	SPMCSR_SPMIE  = 0x80 // SPM Interrupt Enable
	SPMCSR_RWWSB  = 0x40 // Read While Write Section Busy
	SPMCSR_SIGRD  = 0x20 // Signature Row Read
	SPMCSR_RWWSRE = 0x10 // Read While Write section read enable
	SPMCSR_BLBSET = 0x8  // Boot Lock Bit Set
	SPMCSR_PGWRT  = 0x4  // Page Write
	SPMCSR_PGERS  = 0x2  // Page Erase
	SPMCSR_SPMEN  = 0x1  // Store Program Memory Enable

	// SREG: Status Register
	SREG_I = 0x80 // Global Interrupt Enable
	SREG_T = 0x40 // Bit Copy Storage
	SREG_H = 0x20 // Half Carry Flag
	SREG_S = 0x10 // Sign Bit
	SREG_V = 0x8  // Two's Complement Overflow Flag
	SREG_N = 0x4  // Negative Flag
	SREG_Z = 0x2  // Zero Flag
	SREG_C = 0x1  // Carry Flag

	// MCUCR: MCU Control Register
	MCUCR_SPIPS = 0x80 // SPI Pin Select
	MCUCR_PUD   = 0x10 // Pull-up disable
	MCUCR_IVSEL = 0x2  // Interrupt Vector Select
	MCUCR_IVCE  = 0x1  // Interrupt Vector Change Enable

	// MCUSR: MCU Status Register
	MCUSR_WDRF  = 0x8 // Watchdog Reset Flag
	MCUSR_BORF  = 0x4 // Brown-out Reset Flag
	MCUSR_EXTRF = 0x2 // External Reset Flag
	MCUSR_PORF  = 0x1 // Power-on reset flag

	// OSCCAL: Oscillator Calibration Value
	OSCCAL_OSCCAL0 = 0x1  // Oscillator Calibration
	OSCCAL_OSCCAL1 = 0x2  // Oscillator Calibration
	OSCCAL_OSCCAL2 = 0x4  // Oscillator Calibration
	OSCCAL_OSCCAL3 = 0x8  // Oscillator Calibration
	OSCCAL_OSCCAL4 = 0x10 // Oscillator Calibration
	OSCCAL_OSCCAL5 = 0x20 // Oscillator Calibration
	OSCCAL_OSCCAL6 = 0x40 // Oscillator Calibration
	OSCCAL_OSCCAL7 = 0x80 // Oscillator Calibration

	// CLKPR
	CLKPR_CLKPCE = 0x80
	CLKPR_CLKPS0 = 0x1
	CLKPR_CLKPS1 = 0x2
	CLKPR_CLKPS2 = 0x4
	CLKPR_CLKPS3 = 0x8

	// SMCR: Sleep Mode Control Register
	SMCR_SM0 = 0x2 // Sleep Mode Select bits
	SMCR_SM1 = 0x4 // Sleep Mode Select bits
	SMCR_SM2 = 0x8 // Sleep Mode Select bits
	SMCR_SE  = 0x1 // Sleep Enable

	// GPIOR2: General Purpose IO Register 2
	GPIOR2_GPIOR0 = 0x1  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR1 = 0x2  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR2 = 0x4  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR3 = 0x8  // General Purpose IO Register 2 bis
	GPIOR2_GPIOR4 = 0x10 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR5 = 0x20 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR6 = 0x40 // General Purpose IO Register 2 bis
	GPIOR2_GPIOR7 = 0x80 // General Purpose IO Register 2 bis

	// GPIOR1: General Purpose IO Register 1
	GPIOR1_GPIOR0 = 0x1  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR1 = 0x2  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR2 = 0x4  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR3 = 0x8  // General Purpose IO Register 1 bis
	GPIOR1_GPIOR4 = 0x10 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR5 = 0x20 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR6 = 0x40 // General Purpose IO Register 1 bis
	GPIOR1_GPIOR7 = 0x80 // General Purpose IO Register 1 bis

	// GPIOR0: General Purpose IO Register 0
	GPIOR0_GPIOR07 = 0x80 // General Purpose IO Register 0 bit 7
	GPIOR0_GPIOR06 = 0x40 // General Purpose IO Register 0 bit 6
	GPIOR0_GPIOR05 = 0x20 // General Purpose IO Register 0 bit 5
	GPIOR0_GPIOR04 = 0x10 // General Purpose IO Register 0 bit 4
	GPIOR0_GPIOR03 = 0x8  // General Purpose IO Register 0 bit 3
	GPIOR0_GPIOR02 = 0x4  // General Purpose IO Register 0 bit 2
	GPIOR0_GPIOR01 = 0x2  // General Purpose IO Register 0 bit 1
	GPIOR0_GPIOR00 = 0x1  // General Purpose IO Register 0 bit 0

	// PLLCSR: PLL Control And Status Register
	PLLCSR_PLLF  = 0x4 // PLL Factor
	PLLCSR_PLLE  = 0x2 // PLL Enable
	PLLCSR_PLOCK = 0x1 // PLL Lock Detector

	// PRR: Power Reduction Register
	PRR_PRCAN  = 0x40 // Power Reduction CAN
	PRR_PRPSC  = 0x20 // Power Reduction PSC
	PRR_PRTIM1 = 0x10 // Power Reduction Timer/Counter1
	PRR_PRTIM0 = 0x8  // Power Reduction Timer/Counter0
	PRR_PRSPI  = 0x4  // Power Reduction Serial Peripheral Interface
	PRR_PRLIN  = 0x2  // Power Reduction LIN UART
	PRR_PRADC  = 0x1  // Power Reduction ADC
)

// Bitfields for TC8: Timer/Counter, 8-bit
const (
	// TIMSK0: Timer/Counter0 Interrupt Mask Register
	TIMSK0_OCIE0B = 0x4 // Timer/Counter0 Output Compare Match B Interrupt Enable
	TIMSK0_OCIE0A = 0x2 // Timer/Counter0 Output Compare Match A Interrupt Enable
	TIMSK0_TOIE0  = 0x1 // Timer/Counter0 Overflow Interrupt Enable

	// TIFR0: Timer/Counter0 Interrupt Flag register
	TIFR0_OCF0B = 0x4 // Timer/Counter0 Output Compare Flag 0B
	TIFR0_OCF0A = 0x2 // Timer/Counter0 Output Compare Flag 0A
	TIFR0_TOV0  = 0x1 // Timer/Counter0 Overflow Flag

	// TCCR0A: Timer/Counter  Control Register A
	TCCR0A_COM0A0 = 0x40 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0A1 = 0x80 // Compare Output Mode, Phase Correct PWM Mode
	TCCR0A_COM0B0 = 0x10 // Compare Output Mode, Fast PWm
	TCCR0A_COM0B1 = 0x20 // Compare Output Mode, Fast PWm
	TCCR0A_WGM00  = 0x1  // Waveform Generation Mode
	TCCR0A_WGM01  = 0x2  // Waveform Generation Mode

	// TCCR0B: Timer/Counter Control Register B
	TCCR0B_FOC0A = 0x80 // Force Output Compare A
	TCCR0B_FOC0B = 0x40 // Force Output Compare B
	TCCR0B_WGM02 = 0x8
	TCCR0B_CS00  = 0x1 // Clock Select
	TCCR0B_CS01  = 0x2 // Clock Select
	TCCR0B_CS02  = 0x4 // Clock Select
)

// Bitfields for TC16: Timer/Counter, 16-bit
const (
	// TIMSK1: Timer/Counter Interrupt Mask Register
	TIMSK1_ICIE1  = 0x20 // Timer/Counter1 Input Capture Interrupt Enable
	TIMSK1_OCIE1B = 0x4  // Timer/Counter1 Output CompareB Match Interrupt Enable
	TIMSK1_OCIE1A = 0x2  // Timer/Counter1 Output CompareA Match Interrupt Enable
	TIMSK1_TOIE1  = 0x1  // Timer/Counter1 Overflow Interrupt Enable

	// TIFR1: Timer/Counter Interrupt Flag register
	TIFR1_ICF1  = 0x20 // Input Capture Flag 1
	TIFR1_OCF1B = 0x4  // Output Compare Flag 1B
	TIFR1_OCF1A = 0x2  // Output Compare Flag 1A
	TIFR1_TOV1  = 0x1  // Timer/Counter1 Overflow Flag

	// TCCR1A: Timer/Counter1 Control Register A
	TCCR1A_COM1A0 = 0x40 // Compare Output Mode 1A, bits
	TCCR1A_COM1A1 = 0x80 // Compare Output Mode 1A, bits
	TCCR1A_COM1B0 = 0x10 // Compare Output Mode 1B, bits
	TCCR1A_COM1B1 = 0x20 // Compare Output Mode 1B, bits
	TCCR1A_WGM10  = 0x1  // Waveform Generation Mode
	TCCR1A_WGM11  = 0x2  // Waveform Generation Mode

	// TCCR1B: Timer/Counter1 Control Register B
	TCCR1B_ICNC1 = 0x80 // Input Capture 1 Noise Canceler
	TCCR1B_ICES1 = 0x40 // Input Capture 1 Edge Select
	TCCR1B_WGM10 = 0x8  // Waveform Generation Mode
	TCCR1B_WGM11 = 0x10 // Waveform Generation Mode
	TCCR1B_CS10  = 0x1  // Prescaler source of Timer/Counter 1
	TCCR1B_CS11  = 0x2  // Prescaler source of Timer/Counter 1
	TCCR1B_CS12  = 0x4  // Prescaler source of Timer/Counter 1

	// TCCR1C: Timer/Counter1 Control Register C
	TCCR1C_FOC1A = 0x80
	TCCR1C_FOC1B = 0x40
)

// Bitfields for ADC: Analog-to-Digital Converter
const (
	// ADMUX: The ADC multiplexer Selection Register
	ADMUX_REFS0 = 0x40 // Reference Selection Bits
	ADMUX_REFS1 = 0x80 // Reference Selection Bits
	ADMUX_ADLAR = 0x20 // Left Adjust Result
	ADMUX_MUX0  = 0x1  // Analog Channel and Gain Selection Bits
	ADMUX_MUX1  = 0x2  // Analog Channel and Gain Selection Bits
	ADMUX_MUX2  = 0x4  // Analog Channel and Gain Selection Bits
	ADMUX_MUX3  = 0x8  // Analog Channel and Gain Selection Bits
	ADMUX_MUX4  = 0x10 // Analog Channel and Gain Selection Bits

	// ADCSRA: The ADC Control and Status register
	ADCSRA_ADEN  = 0x80 // ADC Enable
	ADCSRA_ADSC  = 0x40 // ADC Start Conversion
	ADCSRA_ADATE = 0x20 // ADC Auto Trigger Enable
	ADCSRA_ADIF  = 0x10 // ADC Interrupt Flag
	ADCSRA_ADIE  = 0x8  // ADC Interrupt Enable
	ADCSRA_ADPS0 = 0x1  // ADC  Prescaler Select Bits
	ADCSRA_ADPS1 = 0x2  // ADC  Prescaler Select Bits
	ADCSRA_ADPS2 = 0x4  // ADC  Prescaler Select Bits

	// ADCSRB: ADC Control and Status Register B
	ADCSRB_ADHSM  = 0x80 // ADC High Speed Mode
	ADCSRB_ISRCEN = 0x40 // Current Source Enable
	ADCSRB_AREFEN = 0x20 // Analog Reference pin Enable
	ADCSRB_ADTS0  = 0x1  // ADC Auto Trigger Sources
	ADCSRB_ADTS1  = 0x2  // ADC Auto Trigger Sources
	ADCSRB_ADTS2  = 0x4  // ADC Auto Trigger Sources
	ADCSRB_ADTS3  = 0x8  // ADC Auto Trigger Sources

	// DIDR0: Digital Input Disable Register 0
	DIDR0_ADC7D = 0x80 // ADC7 Digital input Disable
	DIDR0_ADC6D = 0x40 // ADC6 Digital input Disable
	DIDR0_ADC5D = 0x20 // ADC5 Digital input Disable
	DIDR0_ADC4D = 0x10 // ADC4 Digital input Disable
	DIDR0_ADC3D = 0x8  // ADC3 Digital input Disable
	DIDR0_ADC2D = 0x4  // ADC2 Digital input Disable
	DIDR0_ADC1D = 0x2  // ADC1 Digital input Disable
	DIDR0_ADC0D = 0x1  // ADC0 Digital input Disable

	// DIDR1: Digital Input Disable Register 0
	DIDR1_AMP2PD = 0x40 // AMP2P Pin Digital input Disable
	DIDR1_ACMP0D = 0x20 // ACMP0 Pin Digital input Disable
	DIDR1_AMP0PD = 0x10 // AMP0P Pin Digital input Disable
	DIDR1_AMP0ND = 0x8  // AMP0N Pin Digital input Disable
	DIDR1_ADC10D = 0x4  // ADC10 Pin Digital input Disable
	DIDR1_ADC9D  = 0x2  // ADC9 Pin Digital input Disable
	DIDR1_ADC8D  = 0x1  // ADC8 Pin Digital input Disable

	// AMP0CSR
	AMP0CSR_AMP0EN  = 0x80
	AMP0CSR_AMP0IS  = 0x40
	AMP0CSR_AMP0G0  = 0x10
	AMP0CSR_AMP0G1  = 0x20
	AMP0CSR_AMPCMP0 = 0x8 // Amplifier 0 - Comparator 0 Connection
	AMP0CSR_AMP0TS0 = 0x1
	AMP0CSR_AMP0TS1 = 0x2
	AMP0CSR_AMP0TS2 = 0x4

	// AMP1CSR
	AMP1CSR_AMP1EN  = 0x80
	AMP1CSR_AMP1IS  = 0x40
	AMP1CSR_AMP1G0  = 0x10
	AMP1CSR_AMP1G1  = 0x20
	AMP1CSR_AMPCMP1 = 0x8 // Amplifier 1 - Comparator 1 Connection
	AMP1CSR_AMP1TS0 = 0x1
	AMP1CSR_AMP1TS1 = 0x2
	AMP1CSR_AMP1TS2 = 0x4

	// AMP2CSR
	AMP2CSR_AMP2EN  = 0x80
	AMP2CSR_AMP2IS  = 0x40
	AMP2CSR_AMP2G0  = 0x10
	AMP2CSR_AMP2G1  = 0x20
	AMP2CSR_AMPCMP2 = 0x8 // Amplifier 2 - Comparator 2 Connection
	AMP2CSR_AMP2TS0 = 0x1
	AMP2CSR_AMP2TS1 = 0x2
	AMP2CSR_AMP2TS2 = 0x4
)

// Bitfields for LINUART: Local Interconnect Network
const (
	// LINCR: LIN Control Register
	LINCR_LSWRES = 0x80 // Software Reset
	LINCR_LIN13  = 0x40 // LIN Standard
	LINCR_LCONF0 = 0x10 // LIN Configuration bits
	LINCR_LCONF1 = 0x20 // LIN Configuration bits
	LINCR_LENA   = 0x8  // LIN or UART Enable
	LINCR_LCMD0  = 0x1  // LIN Command and Mode bits
	LINCR_LCMD1  = 0x2  // LIN Command and Mode bits
	LINCR_LCMD2  = 0x4  // LIN Command and Mode bits

	// LINSIR: LIN Status and Interrupt Register
	LINSIR_LIDST0 = 0x20 // Identifier Status bits
	LINSIR_LIDST1 = 0x40 // Identifier Status bits
	LINSIR_LIDST2 = 0x80 // Identifier Status bits
	LINSIR_LBUSY  = 0x10 // Busy Signal
	LINSIR_LERR   = 0x8  // Error Interrupt
	LINSIR_LIDOK  = 0x4  // Identifier Interrupt
	LINSIR_LTXOK  = 0x2  // Transmit Performed Interrupt
	LINSIR_LRXOK  = 0x1  // Receive Performed Interrupt

	// LINENIR: LIN Enable Interrupt Register
	LINENIR_LENERR  = 0x8 // Enable Error Interrupt
	LINENIR_LENIDOK = 0x4 // Enable Identifier Interrupt
	LINENIR_LENTXOK = 0x2 // Enable Transmit Performed Interrupt
	LINENIR_LENRXOK = 0x1 // Enable Receive Performed Interrupt

	// LINERR: LIN Error Register
	LINERR_LABORT = 0x80 // Abort Flag
	LINERR_LTOERR = 0x40 // Frame Time Out Error Flag
	LINERR_LOVERR = 0x20 // Overrun Error Flag
	LINERR_LFERR  = 0x10 // Framing Error Flag
	LINERR_LSERR  = 0x8  // Synchronization Error Flag
	LINERR_LPERR  = 0x4  // Parity Error Flag
	LINERR_LCERR  = 0x2  // Checksum Error Flag
	LINERR_LBERR  = 0x1  // Bit Error Flag

	// LINBTR: LIN Bit Timing Register
	LINBTR_LDISR = 0x80 // Disable Bit Timing Resynchronization
	LINBTR_LBT0  = 0x1  // LIN Bit Timing bits
	LINBTR_LBT1  = 0x2  // LIN Bit Timing bits
	LINBTR_LBT2  = 0x4  // LIN Bit Timing bits
	LINBTR_LBT3  = 0x8  // LIN Bit Timing bits
	LINBTR_LBT4  = 0x10 // LIN Bit Timing bits
	LINBTR_LBT5  = 0x20 // LIN Bit Timing bits

	// LINBRRL: LIN Baud Rate Low Register
	LINBRRL_LDIV0 = 0x1
	LINBRRL_LDIV1 = 0x2
	LINBRRL_LDIV2 = 0x4
	LINBRRL_LDIV3 = 0x8
	LINBRRL_LDIV4 = 0x10
	LINBRRL_LDIV5 = 0x20
	LINBRRL_LDIV6 = 0x40
	LINBRRL_LDIV7 = 0x80

	// LINBRRH: LIN Baud Rate High Register
	LINBRRH_LDIV0 = 0x1
	LINBRRH_LDIV1 = 0x2
	LINBRRH_LDIV2 = 0x4
	LINBRRH_LDIV3 = 0x8

	// LINDLR: LIN Data Length Register
	LINDLR_LTXDL0 = 0x10 // LIN Transmit Data Length bits
	LINDLR_LTXDL1 = 0x20 // LIN Transmit Data Length bits
	LINDLR_LTXDL2 = 0x40 // LIN Transmit Data Length bits
	LINDLR_LTXDL3 = 0x80 // LIN Transmit Data Length bits
	LINDLR_LRXDL0 = 0x1  // LIN Receive Data Length bits
	LINDLR_LRXDL1 = 0x2  // LIN Receive Data Length bits
	LINDLR_LRXDL2 = 0x4  // LIN Receive Data Length bits
	LINDLR_LRXDL3 = 0x8  // LIN Receive Data Length bits

	// LINIDR: LIN Identifier Register
	LINIDR_LP0  = 0x40 // Parity bits
	LINIDR_LP1  = 0x80 // Parity bits
	LINIDR_LID0 = 0x1  // Identifier bit 5 or Data Length bits
	LINIDR_LID1 = 0x2  // Identifier bit 5 or Data Length bits
	LINIDR_LID2 = 0x4  // Identifier bit 5 or Data Length bits
	LINIDR_LID3 = 0x8  // Identifier bit 5 or Data Length bits
	LINIDR_LID4 = 0x10 // Identifier bit 5 or Data Length bits
	LINIDR_LID5 = 0x20 // Identifier bit 5 or Data Length bits

	// LINSEL: LIN Data Buffer Selection Register
	LINSEL_LAINC  = 0x8 // Auto Increment of Data Buffer Index (Active Low)
	LINSEL_LINDX0 = 0x1 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX1 = 0x2 // FIFO LIN Data Buffer Index bits
	LINSEL_LINDX2 = 0x4 // FIFO LIN Data Buffer Index bits

	// LINDAT: LIN Data Register
	LINDAT_LDATA0 = 0x1
	LINDAT_LDATA1 = 0x2
	LINDAT_LDATA2 = 0x4
	LINDAT_LDATA3 = 0x8
	LINDAT_LDATA4 = 0x10
	LINDAT_LDATA5 = 0x20
	LINDAT_LDATA6 = 0x40
	LINDAT_LDATA7 = 0x80
)

// Bitfields for SPI: Serial Peripheral Interface
const (
	// SPCR: SPI Control Register
	SPCR_SPIE = 0x80 // SPI Interrupt Enable
	SPCR_SPE  = 0x40 // SPI Enable
	SPCR_DORD = 0x20 // Data Order
	SPCR_MSTR = 0x10 // Master/Slave Select
	SPCR_CPOL = 0x8  // Clock polarity
	SPCR_CPHA = 0x4  // Clock Phase
	SPCR_SPR0 = 0x1  // SPI Clock Rate Selects
	SPCR_SPR1 = 0x2  // SPI Clock Rate Selects

	// SPSR: SPI Status Register
	SPSR_SPIF  = 0x80 // SPI Interrupt Flag
	SPSR_WCOL  = 0x40 // Write Collision Flag
	SPSR_SPI2X = 0x1  // Double SPI Speed Bit
)

// Bitfields for WDT: Watchdog Timer
const (
	// WDTCSR: Watchdog Timer Control Register
	WDTCSR_WDIF = 0x80 // Watchdog Timeout Interrupt Flag
	WDTCSR_WDIE = 0x40 // Watchdog Timeout Interrupt Enable
	WDTCSR_WDP0 = 0x1  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP1 = 0x2  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP2 = 0x4  // Watchdog Timer Prescaler Bits
	WDTCSR_WDP3 = 0x20 // Watchdog Timer Prescaler Bits
	WDTCSR_WDCE = 0x10 // Watchdog Change Enable
	WDTCSR_WDE  = 0x8  // Watch Dog Enable
)

// Bitfields for EXINT: External Interrupts
const (
	// EICRA: External Interrupt Control Register
	EICRA_ISC30 = 0x40 // External Interrupt Sense Control Bit
	EICRA_ISC31 = 0x80 // External Interrupt Sense Control Bit
	EICRA_ISC20 = 0x10 // External Interrupt Sense Control Bit
	EICRA_ISC21 = 0x20 // External Interrupt Sense Control Bit
	EICRA_ISC10 = 0x4  // External Interrupt Sense Control 1 Bits
	EICRA_ISC11 = 0x8  // External Interrupt Sense Control 1 Bits
	EICRA_ISC00 = 0x1  // External Interrupt Sense Control 0 Bits
	EICRA_ISC01 = 0x2  // External Interrupt Sense Control 0 Bits

	// EIMSK: External Interrupt Mask Register
	EIMSK_INT0 = 0x1 // External Interrupt Request 3 Enable
	EIMSK_INT1 = 0x2 // External Interrupt Request 3 Enable
	EIMSK_INT2 = 0x4 // External Interrupt Request 3 Enable
	EIMSK_INT3 = 0x8 // External Interrupt Request 3 Enable

	// EIFR: External Interrupt Flag Register
	EIFR_INTF0 = 0x1 // External Interrupt Flags
	EIFR_INTF1 = 0x2 // External Interrupt Flags
	EIFR_INTF2 = 0x4 // External Interrupt Flags
	EIFR_INTF3 = 0x8 // External Interrupt Flags

	// PCICR: Pin Change Interrupt Control Register
	PCICR_PCIE0 = 0x1 // Pin Change Interrupt Enables
	PCICR_PCIE1 = 0x2 // Pin Change Interrupt Enables
	PCICR_PCIE2 = 0x4 // Pin Change Interrupt Enables
	PCICR_PCIE3 = 0x8 // Pin Change Interrupt Enables

	// PCMSK3: Pin Change Mask Register 3
	PCMSK3_PCINT0 = 0x1 // Pin Change Enable Masks
	PCMSK3_PCINT1 = 0x2 // Pin Change Enable Masks
	PCMSK3_PCINT2 = 0x4 // Pin Change Enable Masks

	// PCMSK2: Pin Change Mask Register 2
	PCMSK2_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK2_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK2_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK2_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK2_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK2_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK2_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK2_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCMSK1: Pin Change Mask Register 1
	PCMSK1_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK1_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK1_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK1_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK1_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK1_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK1_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK1_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCMSK0: Pin Change Mask Register 0
	PCMSK0_PCINT0 = 0x1  // Pin Change Enable Masks
	PCMSK0_PCINT1 = 0x2  // Pin Change Enable Masks
	PCMSK0_PCINT2 = 0x4  // Pin Change Enable Masks
	PCMSK0_PCINT3 = 0x8  // Pin Change Enable Masks
	PCMSK0_PCINT4 = 0x10 // Pin Change Enable Masks
	PCMSK0_PCINT5 = 0x20 // Pin Change Enable Masks
	PCMSK0_PCINT6 = 0x40 // Pin Change Enable Masks
	PCMSK0_PCINT7 = 0x80 // Pin Change Enable Masks

	// PCIFR: Pin Change Interrupt Flag Register
	PCIFR_PCIF0 = 0x1 // Pin Change Interrupt Flags
	PCIFR_PCIF1 = 0x2 // Pin Change Interrupt Flags
	PCIFR_PCIF2 = 0x4 // Pin Change Interrupt Flags
	PCIFR_PCIF3 = 0x8 // Pin Change Interrupt Flags
)

// Bitfields for EEPROM: EEPROM
const (
	// EECR: EEPROM Control Register
	EECR_EEPM0 = 0x10
	EECR_EEPM1 = 0x20
	EECR_EERIE = 0x8 // EEProm Ready Interrupt Enable
	EECR_EEMWE = 0x4 // EEPROM Master Write Enable
	EECR_EEWE  = 0x2 // EEPROM Write Enable
	EECR_EERE  = 0x1 // EEPROM Read Enable
)

// Bitfields for PSC: Power Stage Controller
const (
	// PIFR: PSC Interrupt Flag Register
	PIFR_PEV0 = 0x2 // PSC External Event 2 Interrupt
	PIFR_PEV1 = 0x4 // PSC External Event 2 Interrupt
	PIFR_PEV2 = 0x8 // PSC External Event 2 Interrupt
	PIFR_PEOP = 0x1 // PSC End of Cycle Interrupt

	// PIM: PSC Interrupt Mask Register
	PIM_PEVE0 = 0x2 // External Event 2 Interrupt Enable
	PIM_PEVE1 = 0x4 // External Event 2 Interrupt Enable
	PIM_PEVE2 = 0x8 // External Event 2 Interrupt Enable
	PIM_PEOPE = 0x1 // PSC End of Cycle Interrupt Enable

	// PMIC2: PSC Module 2 Input Control Register
	PMIC2_POVEN2 = 0x80 // PSC Module 2 Overlap Enable
	PMIC2_PISEL2 = 0x40 // PSC Module 2 Input Select
	PMIC2_PELEV2 = 0x20 // PSC Module 2 Input Level Selector
	PMIC2_PFLTE2 = 0x10 // PSC Module 2 Input Filter Enable
	PMIC2_PAOC2  = 0x8  // PSC Module 2 Asynchronous Output Control
	PMIC2_PRFM20 = 0x1  // PSC Module 2 Input Mode bits
	PMIC2_PRFM21 = 0x2  // PSC Module 2 Input Mode bits
	PMIC2_PRFM22 = 0x4  // PSC Module 2 Input Mode bits

	// PMIC1: PSC Module 1 Input Control Register
	PMIC1_POVEN1 = 0x80 // PSC Module 1 Overlap Enable
	PMIC1_PISEL1 = 0x40 // PSC Module 1 Input Select
	PMIC1_PELEV1 = 0x20 // PSC Module 1 Input Level Selector
	PMIC1_PFLTE1 = 0x10 // PSC Module 1 Input Filter Enable
	PMIC1_PAOC1  = 0x8  // PSC Module 1 Asynchronous Output Control
	PMIC1_PRFM10 = 0x1  // PSC Module 1 Input Mode bits
	PMIC1_PRFM11 = 0x2  // PSC Module 1 Input Mode bits
	PMIC1_PRFM12 = 0x4  // PSC Module 1 Input Mode bits

	// PMIC0: PSC Module 0 Input Control Register
	PMIC0_POVEN0 = 0x80 // PSC Module 0 Overlap Enable
	PMIC0_PISEL0 = 0x40 // PSC Module 0 Input Select
	PMIC0_PELEV0 = 0x20 // PSC Module 0 Input Level Selector
	PMIC0_PFLTE0 = 0x10 // PSC Module 0 Input Filter Enable
	PMIC0_PAOC0  = 0x8  // PSC Module 0 Asynchronous Output Control
	PMIC0_PRFM00 = 0x1  // PSC Module 0 Input Mode bits
	PMIC0_PRFM01 = 0x2  // PSC Module 0 Input Mode bits
	PMIC0_PRFM02 = 0x4  // PSC Module 0 Input Mode bits

	// PCTL: PSC Control Register
	PCTL_PPRE0   = 0x40 // PSC Prescaler Select bits
	PCTL_PPRE1   = 0x80 // PSC Prescaler Select bits
	PCTL_PCLKSEL = 0x20 // PSC Input Clock Select
	PCTL_PCCYC   = 0x2  // PSC Complete Cycle
	PCTL_PRUN    = 0x1  // PSC Run

	// POC: PSC Output Configuration
	POC_POEN2B = 0x20 // PSC Output 2B Enable
	POC_POEN2A = 0x10 // PSC Output 2A Enable
	POC_POEN1B = 0x8  // PSC Output 1B Enable
	POC_POEN1A = 0x4  // PSC Output 1A Enable
	POC_POEN0B = 0x2  // PSC Output 0B Enable
	POC_POEN0A = 0x1  // PSC Output 0A Enable

	// PCNF: PSC Configuration Register
	PCNF_PULOCK = 0x20 // PSC Update Lock
	PCNF_PMODE  = 0x10 // PSC Mode
	PCNF_POPB   = 0x8  // PSC Output B Polarity
	PCNF_POPA   = 0x4  // PSC Output A Polarity

	// PSYNC: PSC Synchro Configuration
	PSYNC_PSYNC20 = 0x10 // Selection of Synchronization Out for ADC
	PSYNC_PSYNC21 = 0x20 // Selection of Synchronization Out for ADC
	PSYNC_PSYNC10 = 0x4  // Selection of Synchronization Out for ADC
	PSYNC_PSYNC11 = 0x8  // Selection of Synchronization Out for ADC
	PSYNC_PSYNC00 = 0x1  // Selection of Synchronization Out for ADC
	PSYNC_PSYNC01 = 0x2  // Selection of Synchronization Out for ADC
)
