/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.out.CommonOut;
import gps.log.out.GPSFile;

public final class GPSWPTFile
extends GPSFile {
    private int posDigits;
    private int heightDigits;
    private final StringBuffer rec = new StringBuffer(1024);

    @Override
    public final void initialiseFile(BT747Path bT747Path, String string, int n) {
        super.initialiseFile(bT747Path, string, n);
        this.posDigits = this.getParamObject().hasParam("pos-digits") ? this.getParamObject().getIntParam("pos-digits") : 6;
        if (this.getParamObject().hasParam("height-digits")) {
            this.heightDigits = this.getParamObject().getIntParam("height-digits");
            return;
        }
        this.heightDigits = 3;
    }

    @Override
    public final void writeFileHeader(String string) {
        super.writeFileHeader(string);
        this.writeTxt("BT747 Track Point File http://www.bt747.org Version 2.2.1\r\nWGS 84\r\nReserved 3\r\n\r\n");
    }

    @Override
    protected final boolean recordIsNeeded(GPSRecord gPSRecord) {
        return this.ptFilters[0].doFilter(gPSRecord);
    }

    @Override
    public final void writeRecord(GPSRecord gPSRecord) {
        super.writeRecord(gPSRecord);
        if (gPSRecord != null && this.ptFilters[1].doFilter(gPSRecord)) {
            this.rec.setLength(0);
            this.rec.append("-1,");
            this.rec.append(CommonOut.getRCRtype(gPSRecord));
            this.rec.append(',');
            if (gPSRecord.hasLatitude() && this.selectedFileFields.hasLatitude()) {
                this.rec.append(JavaLibBridge.toString(gPSRecord.getLatitude(), this.posDigits));
            }
            this.rec.append(',');
            if (gPSRecord.hasLongitude() && this.selectedFileFields.hasLongitude()) {
                this.rec.append(JavaLibBridge.toString(gPSRecord.getLongitude(), this.posDigits));
            }
            this.rec.append(',');
            if (gPSRecord.hasUtc() && this.selectedFileFields.hasUtc()) {
                this.rec.append(JavaLibBridge.toString(((double)gPSRecord.getUtc() + (gPSRecord.hasMillisecond() && this.selectedFileFields.hasMillisecond() ? (double)gPSRecord.milisecond / 1000.0 : 0.0)) / 86400.0 + 25569.0, 7));
            }
            this.rec.append(',');
            this.rec.append(gPSRecord.getRcr());
            this.rec.append(',');
            this.rec.append("1,");
            this.rec.append(',');
            this.rec.append(',');
            this.rec.append(',');
            if (gPSRecord.hasUtc()) {
                String string = "";
                string = string + this.t.getYear() + "-" + (this.t.getMonth() < 10 ? "0" : "") + this.t.getMonth() + "-" + (this.t.getDay() < 10 ? "0" : "") + this.t.getDay() + " " + (this.t.getHour() < 10 ? "0" : "") + this.t.getHour() + ":" + (this.t.getMinute() < 10 ? "0" : "") + this.t.getMinute() + ":" + (this.t.getSecond() < 10 ? "0" : "") + this.t.getSecond();
                if (gPSRecord.hasMillisecond() && this.selectedFileFields.hasMillisecond()) {
                    string = string + ".";
                    string = string + (gPSRecord.milisecond < 100 ? "0" : "");
                    string = string + (gPSRecord.milisecond < 10 ? "0" : "");
                    string = string + gPSRecord.milisecond;
                }
                this.rec.append(string);
                this.rec.append(' ');
            }
            this.rec.append(CommonOut.getRcrSymbolText(gPSRecord));
            this.rec.append(',');
            if (gPSRecord.hasHeight() && this.selectedFileFields.hasHeight()) {
                this.rec.append(JavaLibBridge.toString(gPSRecord.getHeight(), this.heightDigits));
                this.rec.append(',');
            } else {
                this.rec.append("-777,");
            }
            this.rec.append(',');
            this.rec.append(',');
            this.rec.append(',');
            this.rec.append(',');
            this.rec.append(',');
            this.rec.append(',');
            if (gPSRecord.hasVoxStr()) {
                this.rec.append(gPSRecord.getVoxStr());
            }
            this.rec.append(',');
            this.rec.append(',');
            this.rec.append("\r\n");
            this.writeTxt(this.rec.toString());
            this.rec.setLength(0);
        }
    }
}

