/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.util;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.StringTokenizer;
import org.fibs.geotag.Settings;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class Coordinates {
    private static final I18n i18n = I18nFactory.getI18n(Coordinates.class);
    public static final String[] FORMAT_NAMES = new String[]{"\u00b1D.dd\u00b0", "\u00b1D\u00b0M.mm\u2032", "\u00b1D\u00b0M\u2032S.ss\u2033", "H D.dd\u00b0", "H D\u00b0M.mm\u2032", "H D\u00b0M\u2032S.ss\u2033"};
    public static final String EAST = i18n.tr("E");
    public static final String WEST = i18n.tr("W");
    public static final String NORTH = i18n.tr("N");
    public static final String SOUTH = i18n.tr("S");

    private Coordinates() {
    }

    public static String format(double value, boolean isLongitude) {
        FORMAT format = FORMAT.values()[Settings.get(Settings.SETTING.COORDINATES_FORMAT, 0)];
        return Coordinates.format(format, value, isLongitude);
    }

    private static String buildPrefix(FORMAT format, double signum, boolean isLongitude) {
        String prefix = "";
        switch (format) {
            case SIGNED_DEGREES: 
            case SIGNED_DEGREES_MINUTES: 
            case SIGNED_DEGREES_MINUTES_SECONDS: {
                if (signum < 0.0) {
                    prefix = "-";
                    break;
                }
                prefix = "";
                break;
            }
            case DEGREES: 
            case DEGREES_MINUTES: 
            case DEGREES_MINUTES_SECONDS: {
                prefix = signum < 0.0 ? (isLongitude ? WEST : SOUTH) : (isLongitude ? EAST : NORTH);
                prefix = String.valueOf(prefix) + ' ';
                break;
            }
        }
        return prefix;
    }

    public static String format(FORMAT format, double value, boolean isLongitude) {
        double signum = Math.signum(value);
        String prefix = Coordinates.buildPrefix(format, signum, isLongitude);
        String coordinates = "";
        double absValue = Math.abs(value);
        switch (format) {
            case SIGNED_DEGREES: 
            case DEGREES: {
                coordinates = String.format("%.7f%s", new Double(absValue), "\u00b0");
                break;
            }
            case SIGNED_DEGREES_MINUTES: 
            case DEGREES_MINUTES: {
                double degrees = Math.floor(absValue);
                double minutes = (absValue - degrees) * 60.0;
                coordinates = String.format("%d%s%08.5f%s", (int)degrees, "\u00b0", new Double(minutes), "\u2032");
                break;
            }
            case SIGNED_DEGREES_MINUTES_SECONDS: 
            case DEGREES_MINUTES_SECONDS: {
                double degrees = Math.floor(absValue);
                double minutes = Math.floor((absValue - degrees) * 60.0);
                double seconds = (absValue - degrees - minutes / 60.0) * 3600.0;
                coordinates = String.format("%d%s%02d%s%05.2f%s", (int)degrees, "\u00b0", (int)minutes, "\u2032", new Double(seconds), "\u2033");
                break;
            }
        }
        return String.valueOf(prefix) + coordinates;
    }

    public static double parse(String value, boolean isLongitude) {
        double parsed = Double.NaN;
        String text = value;
        if (text == null || text.length() == 0) {
            return parsed;
        }
        int signum = 1;
        char first = text.charAt(0);
        if (first == EAST.charAt(0) && isLongitude) {
            text = text.substring(1);
        } else if (first == WEST.charAt(0) && isLongitude) {
            signum = -1;
            text = text.substring(1);
        } else if (first == NORTH.charAt(0) && !isLongitude) {
            text = text.substring(1);
        } else if (first == SOUTH.charAt(0) && !isLongitude) {
            signum = -1;
            text = text.substring(1);
        } else if (first == '-') {
            signum = -1;
            text = text.substring(1);
        }
        StringBuilder delimiters = new StringBuilder();
        delimiters.append(' ');
        delimiters.append('\'');
        delimiters.append('\"');
        delimiters.append("\u00b0");
        delimiters.append("\u2032");
        delimiters.append("\u2033");
        char delimiter = 'A';
        while (delimiter <= 'Z') {
            delimiters.append(delimiter);
            delimiter = (char)(delimiter + '\u0001');
        }
        delimiter = 'a';
        while (delimiter <= 'z') {
            delimiters.append(delimiter);
            delimiter = (char)(delimiter + '\u0001');
        }
        StringTokenizer tokenizer = new StringTokenizer(text, delimiters.toString());
        double degrees = 0.0;
        double minutes = 0.0;
        double seconds = 0.0;
        try {
            DecimalFormat decimalformat = new DecimalFormat();
            if (tokenizer.countTokens() == 1) {
                degrees = decimalformat.parse(tokenizer.nextToken()).doubleValue();
            } else if (tokenizer.countTokens() == 2) {
                degrees = Integer.parseInt(tokenizer.nextToken());
                minutes = decimalformat.parse(tokenizer.nextToken()).doubleValue();
            } else if (tokenizer.countTokens() == 3) {
                degrees = Integer.parseInt(tokenizer.nextToken());
                minutes = Integer.parseInt(tokenizer.nextToken());
                seconds = decimalformat.parse(tokenizer.nextToken()).doubleValue();
            } else {
                return parsed;
            }
            parsed = (double)signum * (degrees + minutes / 60.0 + seconds / 3600.0);
        }
        catch (NumberFormatException decimalformat) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return parsed;
    }

    public static enum FORMAT {
        SIGNED_DEGREES,
        SIGNED_DEGREES_MINUTES,
        SIGNED_DEGREES_MINUTES_SECONDS,
        DEGREES,
        DEGREES_MINUTES,
        DEGREES_MINUTES_SECONDS;

    }
}

