/*
 * Decompiled with CFR 0.152.
 */
package tim.prune;

import java.io.File;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tim.prune.DataStatus;
import tim.prune.FunctionLibrary;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.data.Checker;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.LatLonRectangle;
import tim.prune.data.NumberUtils;
import tim.prune.data.Photo;
import tim.prune.data.PhotoList;
import tim.prune.data.PointCreateOptions;
import tim.prune.data.RecentFile;
import tim.prune.data.SourceInfo;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.data.Unit;
import tim.prune.function.AsyncMediaLoader;
import tim.prune.function.SelectTracksFunction;
import tim.prune.function.edit.FieldEditList;
import tim.prune.function.edit.PointEditor;
import tim.prune.function.settings.SaveConfig;
import tim.prune.gui.MenuManager;
import tim.prune.gui.SidebarController;
import tim.prune.gui.UndoManager;
import tim.prune.gui.Viewport;
import tim.prune.gui.colour.ColourerCaretaker;
import tim.prune.gui.colour.PointColourer;
import tim.prune.load.FileLoader;
import tim.prune.load.JpegLoader;
import tim.prune.load.MediaLinkInfo;
import tim.prune.load.TrackNameList;
import tim.prune.save.ExifSaver;
import tim.prune.save.FileSaver;
import tim.prune.tips.TipManager;
import tim.prune.undo.UndoAddAltitudeOffset;
import tim.prune.undo.UndoAddTimeOffset;
import tim.prune.undo.UndoCreatePoint;
import tim.prune.undo.UndoCutAndMove;
import tim.prune.undo.UndoDeletePoint;
import tim.prune.undo.UndoEditPoint;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoInsert;
import tim.prune.undo.UndoLoad;
import tim.prune.undo.UndoLoadPhotos;
import tim.prune.undo.UndoMergeTrackSegments;
import tim.prune.undo.UndoOperation;
import tim.prune.undo.UndoReverseSection;
import tim.prune.undo.UndoStack;

public class App {
    private JFrame _frame = null;
    private Track _track = null;
    private TrackInfo _trackInfo = null;
    private int _lastSavePosition = 0;
    private MenuManager _menuManager = null;
    private SidebarController _sidebarController = null;
    private FileLoader _fileLoader = null;
    private JpegLoader _jpegLoader = null;
    private FileSaver _fileSaver = null;
    private UndoStack _undoStack = null;
    private ColourerCaretaker _colCaretaker = null;
    private boolean _mangleTimestampsConfirmed = false;
    private Viewport _viewport = null;
    private ArrayList<File> _dataFiles = null;
    private boolean _autoAppendNextFile = false;
    private boolean _busyLoading = false;
    private AppMode _appMode = AppMode.NORMAL;

    public App(JFrame jFrame) {
        this._frame = jFrame;
        this._undoStack = new UndoStack();
        this._track = new Track();
        this._trackInfo = new TrackInfo(this._track);
        FunctionLibrary.initialise(this);
        this._colCaretaker = new ColourerCaretaker(this);
        UpdateMessageBroker.addSubscriber(this._colCaretaker);
        this._colCaretaker.setColourer(Config.getPointColourer());
    }

    public TrackInfo getTrackInfo() {
        return this._trackInfo;
    }

    public JFrame getFrame() {
        return this._frame;
    }

    public boolean hasDataUnsaved() {
        return this._undoStack.size() > this._lastSavePosition && (this._track.getNumPoints() > 0 || this._trackInfo.getPhotoList().hasModifiedMedia());
    }

    public UndoStack getUndoStack() {
        return this._undoStack;
    }

    public void updatePointColourer() {
        if (this._colCaretaker != null) {
            this._colCaretaker.setColourer(Config.getPointColourer());
        }
    }

    public PointColourer getPointColourer() {
        if (this._colCaretaker == null) {
            return null;
        }
        return this._colCaretaker.getColourer();
    }

    public void showTip(int n) {
        String string = TipManager.fireTipTrigger(n);
        if (string != null && !string.equals("")) {
            JOptionPane.showMessageDialog(this._frame, I18nManager.getText(string), I18nManager.getText("tip.title"), 1);
        }
    }

    public void loadDataFiles(ArrayList<File> arrayList) {
        if (arrayList == null || arrayList.size() == 0) {
            this._dataFiles = null;
        } else {
            this._dataFiles = arrayList;
            File file = this._dataFiles.get(0);
            this._dataFiles.remove(0);
            if (this._fileLoader == null) {
                this._fileLoader = new FileLoader(this, this._frame);
            }
            this._autoAppendNextFile = false;
            this._fileLoader.openFile(file);
        }
    }

    public void completeFunction(UndoOperation undoOperation, String string) {
        this._undoStack.add(undoOperation);
        UpdateMessageBroker.informSubscribers(string);
        this.setCurrentMode(AppMode.NORMAL);
    }

    public void setMenuManager(MenuManager menuManager) {
        this._menuManager = menuManager;
    }

    public void openFile() {
        if (this._fileLoader == null) {
            this._fileLoader = new FileLoader(this, this._frame);
        }
        this._fileLoader.openFile();
    }

    public void addPhotos() {
        if (this._jpegLoader == null) {
            this._jpegLoader = new JpegLoader(this, this._frame);
        }
        this._jpegLoader.openDialog(new LatLonRectangle(this._track.getLatRange(), this._track.getLonRange()));
    }

    public void saveFile() {
        if (this._track == null) {
            this.showErrorMessage("error.save.dialogtitle", "error.save.nodata");
        } else {
            if (this._fileSaver == null) {
                this._fileSaver = new FileSaver(this, this._frame);
            }
            char c = ',';
            if (this._fileLoader != null) {
                c = this._fileLoader.getLastUsedDelimiter();
            }
            this._fileSaver.showDialog(c);
        }
    }

    public void exit() {
        this._frame.toFront();
        this._frame.requestFocus();
        Object[] objectArray = new Object[]{I18nManager.getText("button.exit"), I18nManager.getText("button.cancel")};
        if (!this.hasDataUnsaved() || JOptionPane.showOptionDialog(this._frame, I18nManager.getText("dialog.exit.confirm.text"), I18nManager.getText("dialog.exit.confirm.title"), 0, 2, null, objectArray, objectArray[1]) == 0) {
            if (Config.getConfigBoolean("prune.autosavesettings")) {
                new SaveConfig(this).silentSave();
            }
            System.exit(0);
        }
    }

    public void editCurrentPoint() {
        DataPoint dataPoint;
        if (this._track != null && (dataPoint = this._trackInfo.getCurrentPoint()) != null) {
            PointEditor pointEditor = new PointEditor(this, this._frame);
            pointEditor.showDialog(this._track, dataPoint);
        }
    }

    public void completePointEdit(FieldEditList fieldEditList, FieldEditList fieldEditList2) {
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        if (fieldEditList != null && fieldEditList.getNumEdits() > 0 && dataPoint != null) {
            UndoEditPoint undoEditPoint = new UndoEditPoint(dataPoint, fieldEditList2);
            if (this._track.editPoint(dataPoint, fieldEditList, false)) {
                this._undoStack.add(undoEditPoint);
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.point.edit"));
            }
        }
    }

    public void deleteCurrentPoint() {
        if (this._track == null) {
            return;
        }
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        if (dataPoint != null) {
            int n;
            boolean bl = false;
            Photo photo = dataPoint.getPhoto();
            if (photo != null) {
                n = JOptionPane.showConfirmDialog(this._frame, String.valueOf(I18nManager.getText("dialog.deletepoint.deletephoto")) + " " + photo.getName(), I18nManager.getText("dialog.deletepoint.title"), 1);
                if (n == 2 || n == -1) {
                    return;
                }
                if (n == 0) {
                    bl = true;
                }
            }
            n = this._trackInfo.getSelection().getCurrentPointIndex();
            int n2 = this._trackInfo.getPhotoList().getPhotoIndex(photo);
            int n3 = this._trackInfo.getAudioList().getAudioIndex(dataPoint.getAudio());
            DataPoint dataPoint2 = this._trackInfo.getTrack().getNextTrackPoint(n + 1);
            UndoDeletePoint undoDeletePoint = new UndoDeletePoint(n, dataPoint, n2, n3, dataPoint2 != null && dataPoint2.getSegmentStart());
            undoDeletePoint.setAtBoundaryOfSelectedRange(n == this._trackInfo.getSelection().getStart() || n == this._trackInfo.getSelection().getEnd());
            if (this._trackInfo.deletePoint()) {
                this._undoStack.add(undoDeletePoint);
                if (photo != null) {
                    if (bl) {
                        this._trackInfo.getPhotoList().deletePhoto(n2);
                    } else {
                        photo.setDataPoint(null);
                    }
                    UpdateMessageBroker.informSubscribers((byte)16);
                }
                if (n3 > -1) {
                    this._trackInfo.getAudioList().deleteAudio(n3);
                }
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.deletepoint.single"));
                UpdateMessageBroker.informSubscribers((byte)1);
            }
        }
    }

    public void reverseRange() {
        block5: {
            int n;
            int n2;
            block4: {
                n2 = this._trackInfo.getSelection().getStart();
                if (!this._track.hasData(Field.TIMESTAMP, n2, n = this._trackInfo.getSelection().getEnd()) || this._mangleTimestampsConfirmed) break block4;
                if (JOptionPane.showConfirmDialog(this._frame, I18nManager.getText("dialog.confirmreversetrack.text"), I18nManager.getText("dialog.confirmreversetrack.title"), 0) != 0) break block5;
                this._mangleTimestampsConfirmed = true;
                if (!true) break block5;
            }
            UndoReverseSection undoReverseSection = new UndoReverseSection(this._track, n2, n);
            if (this._track.reverseRange(n2, n)) {
                this._undoStack.add(undoReverseSection);
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.reverserange"));
            }
        }
    }

    public void finishAddTimeOffsetSeconds(long l) {
        int n = this._trackInfo.getSelection().getStart();
        int n2 = this._trackInfo.getSelection().getEnd();
        UndoAddTimeOffset undoAddTimeOffset = new UndoAddTimeOffset(n, n2, l);
        if (this._trackInfo.getTrack().addTimeOffsetSeconds(n, n2, l, false)) {
            this._undoStack.add(undoAddTimeOffset);
            UpdateMessageBroker.informSubscribers((byte)2);
            UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.addtimeoffset"));
        }
    }

    public void finishAddAltitudeOffset(String string, Unit unit) {
        if (string == null || string.equals("") || unit == null) {
            return;
        }
        UndoAddAltitudeOffset undoAddAltitudeOffset = new UndoAddAltitudeOffset(this._trackInfo);
        int n = this._trackInfo.getSelection().getStart();
        int n2 = this._trackInfo.getSelection().getEnd();
        int n3 = NumberUtils.getDecimalPlaces(string);
        boolean bl = false;
        try {
            double d = Double.parseDouble(string);
            bl = this._trackInfo.getTrack().addAltitudeOffset(n, n2, d, unit, n3);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (bl) {
            this._undoStack.add(undoAddAltitudeOffset);
            this._trackInfo.getSelection().markInvalid();
            UpdateMessageBroker.informSubscribers((byte)2);
            UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.addaltitudeoffset"));
        }
    }

    public void mergeTrackSegments() {
        if (this._trackInfo.getSelection().hasRangeSelected()) {
            int n = this._trackInfo.getSelection().getStart();
            int n2 = this._trackInfo.getSelection().getEnd();
            UndoMergeTrackSegments undoMergeTrackSegments = new UndoMergeTrackSegments(this._track, n, n2);
            if (this._trackInfo.mergeTrackSegments(n, n2)) {
                this._undoStack.add(undoMergeTrackSegments);
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.mergetracksegments"));
            }
        }
    }

    public void averageSelection() {
        DataPoint dataPoint = this._track.getNextTrackPoint(this._trackInfo.getSelection().getEnd() + 1);
        boolean bl = false;
        if (dataPoint != null) {
            bl = dataPoint.getSegmentStart();
        }
        UndoInsert undoInsert = new UndoInsert(this._trackInfo.getSelection().getEnd() + 1, 1, dataPoint != null, bl);
        if (this._trackInfo.average()) {
            this._undoStack.add(undoInsert);
        }
    }

    public void createPoint(DataPoint dataPoint) {
        this.createPoint(dataPoint, true);
    }

    public void createPoint(DataPoint dataPoint, boolean bl) {
        UndoCreatePoint undoCreatePoint = new UndoCreatePoint();
        this._undoStack.add(undoCreatePoint);
        dataPoint.setSegmentStart(bl);
        this._track.appendPoints(new DataPoint[]{dataPoint});
        this._track.extendFieldList(dataPoint.getFieldList());
        this._trackInfo.selectPoint(this._trackInfo.getTrack().getNumPoints() - 1);
        UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.createpoint"));
    }

    public void createPoint(DataPoint dataPoint, int n) {
        UndoInsert undoInsert = new UndoInsert(n, 1);
        this._undoStack.add(undoInsert);
        this._track.insertPoint(dataPoint, n);
        this._track.extendFieldList(dataPoint.getFieldList());
        this._trackInfo.selectPoint(n);
        int n2 = this._trackInfo.getSelection().getStart();
        int n3 = this._trackInfo.getSelection().getEnd();
        if (n2 < n && n3 >= n) {
            this._trackInfo.getSelection().selectRange(n2, n3 + 1);
        }
        UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.createpoint"));
    }

    public void cutAndMoveSelection() {
        block8: {
            int n;
            int n2;
            int n3;
            block7: {
                n3 = this._trackInfo.getSelection().getStart();
                n2 = this._trackInfo.getSelection().getEnd();
                n = this._trackInfo.getSelection().getCurrentPointIndex();
                if (!this._track.hasData(Field.TIMESTAMP, n3, n2) || this._mangleTimestampsConfirmed) break block7;
                if (JOptionPane.showConfirmDialog(this._frame, I18nManager.getText("dialog.confirmcutandmove.text"), I18nManager.getText("dialog.confirmcutandmove.title"), 0) != 0) break block8;
                this._mangleTimestampsConfirmed = true;
                if (!true) break block8;
            }
            DataPoint dataPoint = this._track.getNextTrackPoint(n3, n2);
            DataPoint dataPoint2 = this._track.getNextTrackPoint(n2 + 1);
            DataPoint dataPoint3 = this._track.getNextTrackPoint(n);
            UndoCutAndMove undoCutAndMove = new UndoCutAndMove(this._track, n3, n2, n);
            if (this._track.cutAndMoveSection(n3, n2, n)) {
                if (dataPoint != null) {
                    dataPoint.setSegmentStart(true);
                }
                if (dataPoint2 != null) {
                    dataPoint2.setSegmentStart(true);
                }
                if (dataPoint3 != null) {
                    dataPoint3.setSegmentStart(true);
                }
                this._undoStack.add(undoCutAndMove);
                this._trackInfo.getSelection().selectRange(-1, -1);
                UpdateMessageBroker.informSubscribers();
                UpdateMessageBroker.informSubscribers(I18nManager.getText("confirm.cutandmove"));
            }
        }
    }

    public void selectNone() {
        this._trackInfo.getSelection().clearAll();
        this._track.clearDeletionMarkers();
    }

    public void informDataLoaded(Field[] fieldArray, Object[][] objectArray, SourceInfo sourceInfo, TrackNameList trackNameList) {
        this.informDataLoaded(fieldArray, objectArray, null, sourceInfo, trackNameList, null);
    }

    public void informDataLoaded(Field[] fieldArray, Object[][] objectArray, PointCreateOptions pointCreateOptions, SourceInfo sourceInfo, TrackNameList trackNameList) {
        this.informDataLoaded(fieldArray, objectArray, pointCreateOptions, sourceInfo, trackNameList, null);
    }

    public void informDataLoaded(Field[] fieldArray, Object[][] objectArray, PointCreateOptions pointCreateOptions, SourceInfo sourceInfo, TrackNameList trackNameList, MediaLinkInfo mediaLinkInfo) {
        String[] stringArray;
        Track track = new Track();
        track.load(fieldArray, objectArray, pointCreateOptions);
        if (track.getNumPoints() <= 0) {
            String string = sourceInfo == null ? "error.load.nopointsintext" : "error.load.nopoints";
            this.showErrorMessage("error.load.dialogtitle", string);
            this.loadNextFile();
            return;
        }
        if (Checker.isDoubledTrack(track)) {
            JOptionPane.showMessageDialog(this._frame, I18nManager.getText("dialog.open.contentsdoubled"), I18nManager.getText("function.open"), 2);
        }
        this._busyLoading = true;
        if (mediaLinkInfo != null && (stringArray = mediaLinkInfo.getLinkArray()) != null) {
            new AsyncMediaLoader(this, mediaLinkInfo.getZipFile(), stringArray, track, sourceInfo.getFile()).begin();
        }
        if (trackNameList != null && trackNameList.getNumTracks() > 1) {
            new SelectTracksFunction(this, track, sourceInfo, trackNameList).begin();
        } else {
            this.informDataLoaded(track, sourceInfo);
        }
        this.setCurrentMode(AppMode.NORMAL);
    }

    public void informDataLoaded(Track track, SourceInfo sourceInfo) {
        if (this._track.getNumPoints() > 0) {
            int n = 0;
            n = this._autoAppendNextFile ? 0 : JOptionPane.showConfirmDialog(this._frame, I18nManager.getText("dialog.openappend.text"), I18nManager.getText("dialog.openappend.title"), 1);
            this._autoAppendNextFile = false;
            if (n == 0) {
                UndoLoad undoLoad = new UndoLoad(this._track.getNumPoints(), track.getNumPoints());
                undoLoad.setNumPhotosAudios(this._trackInfo.getPhotoList().getNumPhotos(), this._trackInfo.getAudioList().getNumAudios());
                this._undoStack.add(undoLoad);
                this._track.combine(track);
                if (sourceInfo != null) {
                    sourceInfo.populatePointObjects(this._track, track.getNumPoints());
                    this._trackInfo.getFileInfo().addSource(sourceInfo);
                }
            } else if (n == 1) {
                PhotoList photoList = null;
                if (this._trackInfo.getPhotoList().hasCorrelatedPhotos()) {
                    photoList = this._trackInfo.getPhotoList().cloneList();
                }
                UndoLoad undoLoad = new UndoLoad(this._trackInfo, track.getNumPoints(), photoList);
                undoLoad.setNumPhotosAudios(this._trackInfo.getPhotoList().getNumPhotos(), this._trackInfo.getAudioList().getNumAudios());
                this._undoStack.add(undoLoad);
                this._lastSavePosition = this._undoStack.size();
                this._trackInfo.getSelection().clearAll();
                this._track.load(track);
                if (sourceInfo != null) {
                    sourceInfo.populatePointObjects(this._track, this._track.getNumPoints());
                    this._trackInfo.getFileInfo().replaceSource(sourceInfo);
                }
                this._trackInfo.getPhotoList().removeCorrelatedPhotos();
                this._trackInfo.getAudioList().removeCorrelatedAudios();
            }
        } else {
            UndoLoad undoLoad = new UndoLoad(this._trackInfo, track.getNumPoints(), null);
            undoLoad.setNumPhotosAudios(this._trackInfo.getPhotoList().getNumPhotos(), this._trackInfo.getAudioList().getNumAudios());
            this._undoStack.add(undoLoad);
            this._lastSavePosition = this._undoStack.size();
            this._trackInfo.getSelection().clearAll();
            this._track.load(track);
            if (sourceInfo != null) {
                sourceInfo.populatePointObjects(this._track, this._track.getNumPoints());
                this._trackInfo.getFileInfo().addSource(sourceInfo);
            }
        }
        if (sourceInfo != null) {
            boolean bl = sourceInfo.getFileType() != SourceInfo.FILE_TYPE.GPSBABEL;
            Config.getRecentFileList().addFile(new RecentFile(sourceInfo.getFile(), bl));
            UpdateMessageBroker.informSubscribers(String.valueOf(I18nManager.getText("confirm.loadfile")) + " '" + sourceInfo.getName() + "'");
        }
        UpdateMessageBroker.informSubscribers();
        this._menuManager.informFileLoaded();
        this._busyLoading = false;
        this.loadNextFile();
    }

    public void informNoDataLoaded() {
        this.loadNextFile();
    }

    public void autoAppendNextFile() {
        this._autoAppendNextFile = true;
    }

    private void loadNextFile() {
        if (this._dataFiles == null || this._dataFiles.size() == 0) {
            this._dataFiles = null;
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    File file = (File)App.this._dataFiles.get(0);
                    App.this._dataFiles.remove(0);
                    App.this._autoAppendNextFile = true;
                    App.this._fileLoader.openFile(file);
                }
            }).start();
        }
    }

    public void informPhotosLoaded(Set<Photo> set) {
        if (set != null && !set.isEmpty()) {
            int[] nArray = this._trackInfo.addPhotos(set);
            int n = nArray[0];
            int n2 = nArray[1];
            if (n > 0) {
                this._undoStack.add(new UndoLoadPhotos(n, n2));
            }
            if (n == 1) {
                UpdateMessageBroker.informSubscribers(n + " " + I18nManager.getText("confirm.jpegload.single"));
            } else {
                UpdateMessageBroker.informSubscribers(n + " " + I18nManager.getText("confirm.jpegload.multi"));
            }
            UpdateMessageBroker.informSubscribers();
            if (n2 > 0) {
                this._menuManager.informFileLoaded();
            }
        }
    }

    public void saveExif() {
        ExifSaver exifSaver = new ExifSaver(this._frame);
        exifSaver.saveExifInformation(this._trackInfo.getPhotoList());
    }

    public void informDataSaved() {
        this._lastSavePosition = this._undoStack.size();
    }

    public void beginUndo() {
        if (this._undoStack.isEmpty()) {
            JOptionPane.showMessageDialog(this._frame, I18nManager.getText("dialog.undo.none.text"), I18nManager.getText("dialog.undo.none.title"), 1);
        } else {
            new UndoManager(this, this._frame).show();
        }
    }

    public void clearUndo() {
        if (this._undoStack == null || this._undoStack.isEmpty()) {
            return;
        }
        boolean bl = this.hasDataUnsaved();
        int n = JOptionPane.showConfirmDialog(this._frame, I18nManager.getText("dialog.clearundo.text"), I18nManager.getText("dialog.clearundo.title"), 0);
        if (n == 0) {
            this._undoStack.clear();
            this._lastSavePosition = 0;
            if (bl) {
                this._lastSavePosition = -1;
            }
            UpdateMessageBroker.informSubscribers();
        }
    }

    public void undoActions(int n) {
        try {
            int n2 = 0;
            while (n2 < n) {
                this._undoStack.popOperation().performUndo(this._trackInfo);
                ++n2;
            }
            String string = n + " " + (n == 1 ? I18nManager.getText("confirm.undo.single") : I18nManager.getText("confirm.undo.multi"));
            UpdateMessageBroker.informSubscribers(string);
        }
        catch (UndoException undoException) {
            this.showErrorMessageNoLookup("error.undofailed.title", String.valueOf(I18nManager.getText("error.undofailed.text")) + " : " + undoException.getMessage());
            this._undoStack.clear();
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        UpdateMessageBroker.informSubscribers();
    }

    public DataStatus getCurrentDataStatus() {
        return new DataStatus(this._undoStack.size(), this._undoStack.getNumUndos());
    }

    public void showErrorMessage(String string, String string2) {
        JOptionPane.showMessageDialog(this._frame, I18nManager.getText(string2), I18nManager.getText(string), 0);
    }

    public void showErrorMessageNoLookup(String string, String string2) {
        JOptionPane.showMessageDialog(this._frame, string2, I18nManager.getText(string), 0);
    }

    public void setViewport(Viewport viewport) {
        this._viewport = viewport;
    }

    public Viewport getViewport() {
        return this._viewport;
    }

    public void setSidebarController(SidebarController sidebarController) {
        this._sidebarController = sidebarController;
    }

    public void toggleSidebars() {
        this._sidebarController.toggle();
    }

    public boolean isBusyLoading() {
        return this._busyLoading;
    }

    public AppMode getCurrentMode() {
        return this._appMode;
    }

    public void setCurrentMode(AppMode appMode) {
        this._appMode = appMode;
    }

    public static enum AppMode {
        NORMAL,
        DRAWRECT;

    }
}

