/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.config;

import java.awt.Color;

public abstract class ColourUtils {
    public static Color colourFromHex(String string) {
        Color color = null;
        if (string != null && string.length() == 6) {
            try {
                int n = ColourUtils.convertToInt(string.substring(0, 2));
                int n2 = ColourUtils.convertToInt(string.substring(2, 4));
                int n3 = ColourUtils.convertToInt(string.substring(4, 6));
                color = new Color(n, n2, n3);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color;
    }

    private static int convertToInt(String string) {
        int n = Integer.parseInt(string, 16);
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    public static String makeHexCode(Color color) {
        return String.valueOf(ColourUtils.convertToHex(color.getRed())) + ColourUtils.convertToHex(color.getGreen()) + ColourUtils.convertToHex(color.getBlue());
    }

    private static String convertToHex(int n) {
        String string = Integer.toHexString(n);
        return n < 16 ? "0" + string : string;
    }
}

