/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.RecentFile;

public class RecentFileList {
    private RecentFile[] _files = null;
    private static final int DEFAULT_SIZE = 6;
    private static final int MAX_SIZE = 20;

    public RecentFileList() {
        this._files = new RecentFile[6];
    }

    public RecentFileList(String string) {
        this._files = null;
        int n = 0;
        if (string != null && string.length() > 0) {
            String[] stringArray = string.split(";");
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                RecentFile recentFile;
                String string2 = stringArray[n3];
                if (n == 0) {
                    int n4 = 6;
                    try {
                        n4 = Integer.parseInt(string2);
                        if (n4 < 1 || n4 > 20) {
                            n4 = 6;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    this._files = new RecentFile[n4];
                    ++n;
                } else if (n <= this._files.length && (recentFile = new RecentFile(string2)).isValid()) {
                    this._files[n - 1] = recentFile;
                    ++n;
                }
                ++n3;
            }
        }
        if (this._files == null) {
            this._files = new RecentFile[6];
        }
    }

    public int getSize() {
        if (this._files == null) {
            return 0;
        }
        return this._files.length;
    }

    public int getNumEntries() {
        if (this._files == null) {
            return 0;
        }
        int n = 0;
        RecentFile[] recentFileArray = this._files;
        int n2 = this._files.length;
        int n3 = 0;
        while (n3 < n2) {
            RecentFile recentFile = recentFileArray[n3];
            if (recentFile != null && recentFile.isValid()) {
                ++n;
            }
            ++n3;
        }
        return n;
    }

    public String getConfigString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        int n = this.getSize();
        stringBuilder.append("" + n);
        RecentFile[] recentFileArray = this._files;
        int n2 = this._files.length;
        int n3 = 0;
        while (n3 < n2) {
            RecentFile recentFile = recentFileArray[n3];
            stringBuilder.append(';');
            if (recentFile != null) {
                stringBuilder.append(recentFile.getConfigString());
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public void addFile(RecentFile recentFile) {
        RecentFile[] recentFileArray = new RecentFile[this._files.length];
        int n = 0;
        if (recentFile != null && recentFile.isValid()) {
            recentFileArray[n] = recentFile;
            ++n;
        }
        RecentFile[] recentFileArray2 = this._files;
        int n2 = this._files.length;
        int n3 = 0;
        while (n3 < n2) {
            RecentFile recentFile2 = recentFileArray2[n3];
            if (recentFile2 != null && recentFile2.isValid() && (recentFile == null || !recentFile2.isSameFile(recentFile))) {
                recentFileArray[n] = recentFile2;
                if (++n >= recentFileArray.length) break;
            }
            ++n3;
        }
        this._files = recentFileArray;
    }

    public void verifyAll() {
        this.addFile(null);
    }

    public RecentFile getFile(int n) {
        if (n < 0 || n >= this._files.length) {
            return null;
        }
        return this._files[n];
    }

    public void resizeList(int n) {
        if (n > 0 && n <= 20) {
            RecentFile[] recentFileArray = new RecentFile[n];
            int n2 = this._files.length;
            if (n < n2) {
                n2 = n;
            }
            System.arraycopy(this._files, 0, recentFileArray, 0, n2);
            this._files = recentFileArray;
        }
    }
}

