/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.gui.datatransfer.data.OsmLayerTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTagTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.PrimitiveTransferData;
import org.openstreetmap.josm.gui.datatransfer.data.TagTransferData;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class PrimitiveTransferable
implements Transferable {
    private static final List<DataFlavor> PRIMITIVE_FLAVORS = Arrays.asList(PrimitiveTransferData.DATA_FLAVOR, TagTransferData.FLAVOR, DataFlavor.stringFlavor);
    private final PrimitiveTransferData primitives;
    private final OsmDataLayer sourceLayer;

    public PrimitiveTransferable(PrimitiveTransferData primitives) {
        this(primitives, null);
    }

    public PrimitiveTransferable(PrimitiveTransferData primitives, OsmDataLayer sourceLayer) {
        this.primitives = primitives;
        this.sourceLayer = sourceLayer;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        ArrayList<DataFlavor> flavors = new ArrayList<DataFlavor>(PRIMITIVE_FLAVORS);
        if (this.sourceLayer != null) {
            flavors.addAll(OsmLayerTransferData.FLAVORS);
        }
        return flavors.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        DataFlavor[] flavors = this.getTransferDataFlavors();
        return Arrays.stream(flavors).anyMatch(flavor::equals);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        if (DataFlavor.stringFlavor.equals(flavor)) {
            return this.getStringData();
        }
        if (PrimitiveTransferData.DATA_FLAVOR.equals(flavor)) {
            return this.primitives;
        }
        if (PrimitiveTagTransferData.FLAVOR.equals(flavor)) {
            return new PrimitiveTagTransferData(this.primitives);
        }
        if (TagTransferData.FLAVOR.equals(flavor)) {
            return new TagTransferData(this.primitives.getDirectlyAdded());
        }
        if (this.sourceLayer != null && OsmLayerTransferData.FLAVORS.contains(flavor)) {
            return new OsmLayerTransferData(null, this.sourceLayer);
        }
        throw new UnsupportedFlavorException(flavor);
    }

    protected String getStringData() {
        StringBuilder sb = new StringBuilder();
        for (PrimitiveData primitive : this.primitives.getDirectlyAdded()) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(OsmPrimitiveType.from(primitive).getAPIName()).append(' ').append(primitive.getId());
        }
        return DefaultNameFormatter.removeBiDiCharacters(sb.toString());
    }
}

