/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.mappaint;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.tools.Pair;

public class DividedScale<T> {
    private final List<Double> bd;
    private final List<T> data;

    protected DividedScale() {
        this.bd = new ArrayList<Double>();
        this.bd.add(0.0);
        this.bd.add(Double.POSITIVE_INFINITY);
        this.data = new ArrayList<T>();
        this.data.add(null);
    }

    protected DividedScale(DividedScale<T> s) {
        this.bd = new ArrayList<Double>(s.bd);
        this.data = new ArrayList<T>(s.data);
    }

    public T get(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + scale);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < scale) || !(scale <= this.bd.get(i + 1))) continue;
            return this.data.get(i);
        }
        throw new AssertionError();
    }

    public Pair<T, Range> getWithRange(double scale) {
        if (scale <= 0.0) {
            throw new IllegalArgumentException("scale must be <= 0 but is " + scale);
        }
        for (int i = 0; i < this.data.size(); ++i) {
            if (!(this.bd.get(i) < scale) || !(scale <= this.bd.get(i + 1))) continue;
            return new Pair<T, Range>(this.data.get(i), new Range(this.bd.get(i), this.bd.get(i + 1)));
        }
        throw new AssertionError();
    }

    public DividedScale<T> put(T o, Range r) {
        DividedScale<T> s = new DividedScale<T>(this);
        super.putImpl(o, r.getLower(), r.getUpper());
        s.consistencyTest();
        return s;
    }

    private void putImpl(T o, double lower, double upper) {
        int i = 0;
        while (this.bd.get(i) < lower) {
            ++i;
        }
        if (this.bd.get(i) == lower) {
            if (upper > this.bd.get(i + 1)) {
                throw new RangeViolatedError("the new range must be within a single subrange (1)");
            }
            if (this.data.get(i) != null) {
                throw new RangeViolatedError("the new range must be within a subrange that has no data");
            }
            if (this.bd.get(i + 1) == upper) {
                this.data.set(i, o);
            } else {
                this.bd.add(i + 1, upper);
                this.data.add(i, o);
            }
        } else {
            if (this.bd.get(i) < upper) {
                throw new RangeViolatedError("the new range must be within a single subrange (2)");
            }
            if (this.data.get(i - 1) != null) {
                throw new AssertionError();
            }
            this.bd.add(i, lower);
            this.data.add(i, o);
            if (this.bd.get(i + 1) > upper) {
                this.bd.add(i + 1, upper);
                this.data.add(i + 1, null);
            }
        }
    }

    public void consistencyTest() {
        if (this.bd.size() < 2) {
            throw new AssertionError(this.bd);
        }
        if (this.data.isEmpty()) {
            throw new AssertionError(this.data);
        }
        if (this.bd.size() != this.data.size() + 1) {
            throw new AssertionError();
        }
        if (this.bd.get(0) != 0.0) {
            throw new AssertionError();
        }
        if (this.bd.get(this.bd.size() - 1) != Double.POSITIVE_INFINITY) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.data.size() - 1; ++i) {
            if (this.bd.get(i) >= this.bd.get(i + 1)) {
                throw new AssertionError();
            }
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DividedScale that = (DividedScale)obj;
        return Objects.equals(this.bd, that.bd) && Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.bd, this.data);
    }

    public String toString() {
        return "DS{" + this.bd + ' ' + this.data + '}';
    }

    public static class RangeViolatedError
    extends RuntimeException {
        public RangeViolatedError(String message) {
            super(message);
        }
    }
}

