/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.intrinsics;

import com.google.common.collect.ImmutableSet;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.backend.jvm.intrinsics.AndAnd;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayGet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArrayIterator;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySet;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ArraySize;
import org.jetbrains.kotlin.backend.jvm.intrinsics.BinaryOp;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Clone;
import org.jetbrains.kotlin.backend.jvm.intrinsics.CompareTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumValueOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.EnumValues;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ExplicitEquals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetJavaObjectType;
import org.jetbrains.kotlin.backend.jvm.intrinsics.GetJavaPrimitiveType;
import org.jetbrains.kotlin.backend.jvm.intrinsics.HashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Ieee754Equals;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Increment;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IntrinsicMethod;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Inv;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrDataClassArrayMemberHashCode;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrDataClassArrayMemberToString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrIllegalArgumentException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IrNoWhenBranchMatchedException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IsArrayOf;
import org.jetbrains.kotlin.backend.jvm.intrinsics.IteratorNext;
import org.jetbrains.kotlin.backend.jvm.intrinsics.JavaClassProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.KClassJavaProperty;
import org.jetbrains.kotlin.backend.jvm.intrinsics.MonitorInstruction;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NewArray;
import org.jetbrains.kotlin.backend.jvm.intrinsics.Not;
import org.jetbrains.kotlin.backend.jvm.intrinsics.NumberCast;
import org.jetbrains.kotlin.backend.jvm.intrinsics.OrOr;
import org.jetbrains.kotlin.backend.jvm.intrinsics.PrimitiveComparison;
import org.jetbrains.kotlin.backend.jvm.intrinsics.RangeTo;
import org.jetbrains.kotlin.backend.jvm.intrinsics.SignatureString;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringGetChar;
import org.jetbrains.kotlin.backend.jvm.intrinsics.StringPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.ThrowKotlinNothingValueException;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryMinus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnaryPlus;
import org.jetbrains.kotlin.backend.jvm.intrinsics.UnsafeCoerce;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.descriptors.IrBuiltIns;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u000212B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u0018H\u0002J*\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J2\u0010\u001d\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\u001bH\u0002J*\u0010\"\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0002J*\u0010#\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u00182\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0012\u001a\u00020(J\u001a\u0010)\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u0018H\u0002J6\u0010*\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020+0\u00190\u00182\u0012\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020-0\b2\u0006\u0010.\u001a\u00020/H\u0002J*\u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\u00190\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0002R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods;", "", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "symbols", "Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "(Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;)V", "intrinsicsMap", "", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "getIrBuiltIns", "()Lorg/jetbrains/kotlin/ir/descriptors/IrBuiltIns;", "kotlinJvm", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinJvmInternalUnsafe", "getSymbols", "()Lorg/jetbrains/kotlin/backend/jvm/JvmSymbols;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "getSymbol", "(Lorg/jetbrains/kotlin/builtins/PrimitiveType;)Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "arrayMethods", "", "Lkotlin/Pair;", "elementClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "arrayClass", "binaryFunForPrimitives", "name", "", "intrinsic", "parameter", "binaryFunForPrimitivesAcrossPrimitives", "binaryOp", "methodName", "opcode", "", "getIntrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "numberConversionMethods", "primitiveComparisonIntrinsics", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/PrimitiveComparison;", "typeToIrFun", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "operator", "Lorg/jetbrains/kotlin/lexer/KtSingleValueToken;", "unaryFunForPrimitives", "Companion", "Key", "backend.jvm"})
public final class IrIntrinsicMethods {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final JvmSymbols symbols;
    @NotNull
    private final FqName kotlinJvm;
    @NotNull
    private final FqName kotlinJvmInternalUnsafe;
    @NotNull
    private final Map<Key, IntrinsicMethod> intrinsicsMap;
    @NotNull
    public static final String INTRINSICS_CLASS_NAME = "kotlin/jvm/internal/Intrinsics";
    @NotNull
    private static final Increment INC = new Increment(1);
    @NotNull
    private static final Increment DEC = new Increment(-1);
    @NotNull
    private static final ExplicitEquals EXPLICIT_EQUALS = new ExplicitEquals();

    /*
     * WARNING - void declaration
     */
    public IrIntrinsicMethods(@NotNull IrBuiltIns irBuiltIns, @NotNull JvmSymbols symbols2) {
        Collection<Pair> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(irBuiltIns, "irBuiltIns");
        Intrinsics.checkNotNullParameter(symbols2, "symbols");
        this.irBuiltIns = irBuiltIns;
        this.symbols = symbols2;
        this.kotlinJvm = new FqName("kotlin.jvm");
        this.kotlinJvmInternalUnsafe = new FqName("kotlin.jvm.internal.unsafe");
        Object object = new Pair[29];
        object[0] = TuplesKt.to(new Key(this.kotlinJvm, new FqName("T"), "<get-javaClass>", CollectionsKt.emptyList()), JavaClassProperty.INSTANCE);
        object[1] = TuplesKt.to(new Key(this.kotlinJvm, StandardNames.FqNames.kClass.toSafe(), "<get-javaObjectType>", CollectionsKt.emptyList()), GetJavaObjectType.INSTANCE);
        object[2] = TuplesKt.to(new Key(this.kotlinJvm, StandardNames.FqNames.kClass.toSafe(), "<get-javaPrimitiveType>", CollectionsKt.emptyList()), GetJavaPrimitiveType.INSTANCE);
        object[3] = TuplesKt.to(new Key(this.kotlinJvm, StandardNames.FqNames.kClass.toSafe(), "<get-java>", CollectionsKt.emptyList()), KClassJavaProperty.INSTANCE);
        object[4] = TuplesKt.to(new Key(this.kotlinJvmInternalUnsafe, null, "access$monitorEnter", CollectionsKt.listOf(StandardNames.FqNames.any.toSafe())), MonitorInstruction.MONITOR_ENTER);
        object[5] = TuplesKt.to(new Key(this.kotlinJvmInternalUnsafe, null, "access$monitorExit", CollectionsKt.listOf(StandardNames.FqNames.any.toSafe())), MonitorInstruction.MONITOR_EXIT);
        object[6] = TuplesKt.to(new Key(this.kotlinJvm, StandardNames.FqNames.array.toSafe(), "isArrayOf", CollectionsKt.emptyList()), IsArrayOf.INSTANCE);
        object[7] = TuplesKt.to(new Key(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "arrayOfNulls", CollectionsKt.listOf(StandardNames.FqNames._int.toSafe())), NewArray.INSTANCE);
        FqName fqName2 = StandardNames.FqNames.cloneable.toSafe();
        Intrinsics.checkNotNullExpressionValue(fqName2, "cloneable.toSafe()");
        object[8] = TuplesKt.to(new Key(fqName2, null, "clone", CollectionsKt.emptyList()), Clone.INSTANCE);
        boolean bl = false;
        object[9] = TuplesKt.to(new Key(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "enumValues", CollectionsKt.emptyList()), EnumValues.INSTANCE);
        object[10] = TuplesKt.to(new Key(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, null, "enumValueOf", CollectionsKt.listOf(StandardNames.FqNames.string.toSafe())), EnumValueOf.INSTANCE);
        object[11] = TuplesKt.to(new Key(StandardNames.BUILT_INS_PACKAGE_FQ_NAME, StandardNames.FqNames.string.toSafe(), "plus", CollectionsKt.listOf(StandardNames.FqNames.any.toSafe())), StringPlus.INSTANCE);
        Object object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqSymbol());
        Intrinsics.checkNotNull(object2);
        Key key = object2;
        object2 = KtTokens.EQEQ;
        Intrinsics.checkNotNullExpressionValue(object2, "EQEQ");
        object[12] = TuplesKt.to(key, new Equals((IElementType)object2));
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getEqeqeqSymbol());
        Intrinsics.checkNotNull(object2);
        Object object3 = object2;
        object2 = KtTokens.EQEQEQ;
        Intrinsics.checkNotNullExpressionValue(object2, "EQEQEQ");
        object[13] = TuplesKt.to(object3, new Equals((IElementType)object2));
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getFloatClass());
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        object2 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol);
        Intrinsics.checkNotNull(object2);
        Object object4 = object2;
        object2 = Type.FLOAT_TYPE;
        Intrinsics.checkNotNullExpressionValue(object2, "FLOAT_TYPE");
        object[14] = TuplesKt.to(object4, new Ieee754Equals((Type)object2));
        irSimpleFunctionSymbol = this.irBuiltIns.getIeee754equalsFunByOperandType().get(this.irBuiltIns.getDoubleClass());
        Intrinsics.checkNotNull(irSimpleFunctionSymbol);
        object2 = IrIntrinsicMethods.Companion.toKey(irSimpleFunctionSymbol);
        Intrinsics.checkNotNull(object2);
        Object object5 = object2;
        object2 = Type.DOUBLE_TYPE;
        Intrinsics.checkNotNullExpressionValue(object2, "DOUBLE_TYPE");
        object[15] = TuplesKt.to(object5, new Ieee754Equals((Type)object2));
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getBooleanNotSymbol());
        Intrinsics.checkNotNull(object2);
        object[16] = TuplesKt.to(object2, Not.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getNoWhenBranchMatchedExceptionSymbol());
        Intrinsics.checkNotNull(object2);
        object[17] = TuplesKt.to(object2, IrNoWhenBranchMatchedException.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getIllegalArgumentExceptionSymbol());
        Intrinsics.checkNotNull(object2);
        object[18] = TuplesKt.to(object2, IrIllegalArgumentException.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getAndandSymbol());
        Intrinsics.checkNotNull(object2);
        object[19] = TuplesKt.to(object2, AndAnd.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getOrorSymbol());
        Intrinsics.checkNotNull(object2);
        object[20] = TuplesKt.to(object2, OrOr.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getDataClassArrayMemberHashCodeSymbol());
        Intrinsics.checkNotNull(object2);
        object[21] = TuplesKt.to(object2, IrDataClassArrayMemberHashCode.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.irBuiltIns.getDataClassArrayMemberToStringSymbol());
        Intrinsics.checkNotNull(object2);
        object[22] = TuplesKt.to(object2, IrDataClassArrayMemberToString.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.symbols.getUnsafeCoerceIntrinsic());
        Intrinsics.checkNotNull(object2);
        object[23] = TuplesKt.to(object2, UnsafeCoerce.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.symbols.getSignatureStringIntrinsic());
        Intrinsics.checkNotNull(object2);
        object[24] = TuplesKt.to(object2, SignatureString.INSTANCE);
        object2 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowNullPointerException());
        Intrinsics.checkNotNull(object2);
        Object object6 = object2;
        object2 = Type.getObjectType("java/lang/NullPointerException");
        Intrinsics.checkNotNullExpressionValue(object2, "getObjectType(\"java/lang/NullPointerException\")");
        object[25] = TuplesKt.to(object6, new ThrowException((Type)object2));
        object2 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowTypeCastException());
        Intrinsics.checkNotNull(object2);
        Object object7 = object2;
        object2 = Type.getObjectType("kotlin/TypeCastException");
        Intrinsics.checkNotNullExpressionValue(object2, "getObjectType(\"kotlin/TypeCastException\")");
        object[26] = TuplesKt.to(object7, new ThrowException((Type)object2));
        object2 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowUnsupportedOperationException());
        Intrinsics.checkNotNull(object2);
        Object object8 = object2;
        object2 = Type.getObjectType("java/lang/UnsupportedOperationException");
        Intrinsics.checkNotNullExpressionValue(object2, "getObjectType(\"java/lang/UnsupportedOperationException\")");
        object[27] = TuplesKt.to(object8, new ThrowException((Type)object2));
        object2 = IrIntrinsicMethods.Companion.toKey(this.symbols.getThrowKotlinNothingValueException());
        Intrinsics.checkNotNull(object2);
        object[28] = TuplesKt.to(object2, ThrowKotlinNothingValueException.INSTANCE);
        Collection collection2 = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf(object), (Iterable)this.numberConversionMethods()), (Iterable)this.unaryFunForPrimitives("plus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryPlus", UnaryPlus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("minus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("unaryMinus", UnaryMinus.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inv", Inv.INSTANCE)), (Iterable)this.unaryFunForPrimitives("inc", INC)), (Iterable)this.unaryFunForPrimitives("dec", DEC)), (Iterable)this.unaryFunForPrimitives("hashCode", HashCode.INSTANCE)), (Iterable)this.binaryFunForPrimitives("equals", EXPLICIT_EQUALS, this.irBuiltIns.getAnyClass())), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("rangeTo", RangeTo.INSTANCE)), (Iterable)this.binaryOp("plus", 96)), (Iterable)this.binaryOp("minus", 100)), (Iterable)this.binaryOp("times", 104)), (Iterable)this.binaryOp("div", 108)), (Iterable)this.binaryOp("mod", 112)), (Iterable)this.binaryOp("rem", 112)), (Iterable)this.binaryOp("shl", 120)), (Iterable)this.binaryOp("shr", 122)), (Iterable)this.binaryOp("ushr", 124)), (Iterable)this.binaryOp("and", 126)), (Iterable)this.binaryOp("or", 128)), (Iterable)this.binaryOp("xor", 130)), (Iterable)this.binaryFunForPrimitivesAcrossPrimitives("compareTo", CompareTo.INSTANCE)), IrIntrinsicMethods.Companion.createKeyMapping(Not.INSTANCE, this.irBuiltIns.getBooleanClass(), "not", new IrClassifierSymbol[0]));
        object = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        Collection collection3 = CollectionsKt.plus(collection2, IrIntrinsicMethods.Companion.createKeyMapping(StringGetChar.INSTANCE, this.irBuiltIns.getStringClass(), "get", (IrClassifierSymbol[])object));
        object = this.symbols.getPrimitiveIteratorsByType().values();
        Collection collection4 = collection3;
        IrIntrinsicMethods irIntrinsicMethods = this;
        boolean $i$f$map = false;
        irSimpleFunctionSymbol = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void iteratorClass;
            IrClassSymbol irClassSymbol = (IrClassSymbol)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            Pair pair = IrIntrinsicMethods.Companion.createKeyMapping(IteratorNext.INSTANCE, (IrClassSymbol)iteratorClass, "next", new IrClassifierSymbol[0]);
            collection.add(pair);
        }
        collection = (List)destination$iv$iv;
        Collection collection5 = CollectionsKt.plus((Collection)CollectionsKt.plus(collection4, (Iterable)collection), (Iterable)this.arrayMethods());
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map = this.irBuiltIns.getLessFunByOperandType();
        object = KtTokens.LT;
        Intrinsics.checkNotNullExpressionValue(object, "LT");
        Collection collection6 = CollectionsKt.plus(collection5, (Iterable)this.primitiveComparisonIntrinsics(map, (KtSingleValueToken)object));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map2 = this.irBuiltIns.getLessOrEqualFunByOperandType();
        object = KtTokens.LTEQ;
        Intrinsics.checkNotNullExpressionValue(object, "LTEQ");
        Collection collection7 = CollectionsKt.plus(collection6, (Iterable)this.primitiveComparisonIntrinsics(map2, (KtSingleValueToken)object));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map3 = this.irBuiltIns.getGreaterFunByOperandType();
        object = KtTokens.GT;
        Intrinsics.checkNotNullExpressionValue(object, "GT");
        Collection collection8 = CollectionsKt.plus(collection7, (Iterable)this.primitiveComparisonIntrinsics(map3, (KtSingleValueToken)object));
        Map<IrClassifierSymbol, IrSimpleFunctionSymbol> map4 = this.irBuiltIns.getGreaterOrEqualFunByOperandType();
        object = KtTokens.GTEQ;
        Intrinsics.checkNotNullExpressionValue(object, "GTEQ");
        irIntrinsicMethods.intrinsicsMap = MapsKt.toMap(CollectionsKt.plus(collection8, (Iterable)this.primitiveComparisonIntrinsics(map4, (KtSingleValueToken)object)));
    }

    @NotNull
    public final IrBuiltIns getIrBuiltIns() {
        return this.irBuiltIns;
    }

    @NotNull
    public final JvmSymbols getSymbols() {
        return this.symbols;
    }

    private final IrClassSymbol getSymbol(PrimitiveType $this$symbol) {
        IrType irType = this.irBuiltIns.getPrimitiveTypeToIrType().get((Object)$this$symbol);
        Intrinsics.checkNotNull(irType);
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(irType);
        Intrinsics.checkNotNull(irClassSymbol);
        return irClassSymbol;
    }

    @Nullable
    public final IntrinsicMethod getIntrinsic(@NotNull IrFunctionSymbol symbol2) {
        Intrinsics.checkNotNullParameter(symbol2, "symbol");
        Map<Key, IntrinsicMethod> map = this.intrinsicsMap;
        Key key = IrIntrinsicMethods.Companion.toKey(symbol2);
        boolean bl = false;
        return map.get(key);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> unaryFunForPrimitives(String name, IntrinsicMethod intrinsic) {
        void $this$mapTo$iv$iv;
        PrimitiveType[] $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var8_8 = $this$mapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void type2;
            void item$iv$iv;
            void var12_12 = item$iv$iv = var8_8[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Pair pair = IrIntrinsicMethods.Companion.createKeyMapping(intrinsic, this.getSymbol((PrimitiveType)type2), name, new IrClassifierSymbol[0]);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitivesAcrossPrimitives(String name, IntrinsicMethod intrinsic) {
        void $this$flatMapTo$iv$iv;
        PrimitiveType[] $this$flatMap$iv = PrimitiveType.values();
        boolean $i$f$flatMap = false;
        PrimitiveType[] primitiveTypeArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var8_8 = $this$flatMapTo$iv$iv;
        int n = ((void)var8_8).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void parameter = element$iv$iv = var8_8[i];
            boolean bl = false;
            Iterable list$iv$iv = this.binaryFunForPrimitives(name, intrinsic, this.getSymbol((PrimitiveType)parameter));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> binaryFunForPrimitives(String name, IntrinsicMethod intrinsic, IrClassifierSymbol parameter) {
        void $this$mapTo$iv$iv;
        PrimitiveType[] $this$map$iv = PrimitiveType.values();
        boolean $i$f$map = false;
        PrimitiveType[] primitiveTypeArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        void var9_9 = $this$mapTo$iv$iv;
        int n = ((void)var9_9).length;
        for (int i = 0; i < n; ++i) {
            void type2;
            void item$iv$iv;
            void var13_13 = item$iv$iv = var9_9[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrClassifierSymbol[] irClassifierSymbolArray = new IrClassifierSymbol[]{parameter};
            Pair pair = IrIntrinsicMethods.Companion.createKeyMapping(intrinsic, this.getSymbol((PrimitiveType)type2), name, irClassifierSymbolArray);
            collection.add(pair);
        }
        return (List)destination$iv$iv;
    }

    private final List<Pair<Key, IntrinsicMethod>> binaryOp(String methodName, int opcode) {
        return this.binaryFunForPrimitivesAcrossPrimitives(methodName, new BinaryOp(opcode));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = PrimitiveType.NUMBER_TYPES;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PrimitiveType type2 = (PrimitiveType)((Object)element$iv$iv);
            boolean bl = false;
            Iterable list$iv$iv = IrIntrinsicMethods.Companion.numberConversionMethods(this.getSymbol(type2));
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)IrIntrinsicMethods.Companion.numberConversionMethods(this.irBuiltIns.getNumberClass()));
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, IntrinsicMethod>> arrayMethods() {
        void $this$flatMapTo$iv$iv;
        Map<PrimitiveType, IrClassSymbol> $this$flatMap$iv = this.symbols.getPrimitiveArrays();
        boolean $i$f$flatMap = false;
        Map<PrimitiveType, IrClassSymbol> map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        boolean bl = false;
        Iterator iterator2 = var6_6.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry $dstr$key$value = element$iv$iv = iterator2.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$key$value;
            boolean bl3 = false;
            PrimitiveType key = (PrimitiveType)((Object)entry.getKey());
            Map.Entry entry2 = $dstr$key$value;
            boolean bl4 = false;
            IrClassSymbol value2 = (IrClassSymbol)entry2.getValue();
            Iterable list$iv$iv = this.arrayMethods(this.getSymbol(key), value2);
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)this.arrayMethods((IrClassifierSymbol)CollectionsKt.single(((IrClass)this.symbols.getArray().getOwner()).getTypeParameters()).getSymbol(), this.symbols.getArray()));
    }

    private final List<Pair<Key, IntrinsicMethod>> arrayMethods(IrClassifierSymbol elementClass, IrClassSymbol arrayClass) {
        Pair[] pairArray = new Pair[6];
        pairArray[0] = IrIntrinsicMethods.Companion.createKeyMapping(ArraySize.INSTANCE, arrayClass, "<get-size>", new IrClassifierSymbol[0]);
        IrClassifierSymbol[] irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        pairArray[1] = IrIntrinsicMethods.Companion.createKeyMapping(NewArray.INSTANCE, arrayClass, "<init>", irClassifierSymbolArray);
        irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass(), elementClass};
        pairArray[2] = IrIntrinsicMethods.Companion.createKeyMapping(ArraySet.INSTANCE, arrayClass, "set", irClassifierSymbolArray);
        irClassifierSymbolArray = new IrClassifierSymbol[]{this.irBuiltIns.getIntClass()};
        pairArray[3] = IrIntrinsicMethods.Companion.createKeyMapping(ArrayGet.INSTANCE, arrayClass, "get", irClassifierSymbolArray);
        pairArray[4] = IrIntrinsicMethods.Companion.createKeyMapping(Clone.INSTANCE, arrayClass, "clone", new IrClassifierSymbol[0]);
        pairArray[5] = IrIntrinsicMethods.Companion.createKeyMapping(ArrayIterator.INSTANCE, arrayClass, "iterator", new IrClassifierSymbol[0]);
        return CollectionsKt.listOf(pairArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Pair<Key, PrimitiveComparison>> primitiveComparisonIntrinsics(Map<IrClassifierSymbol, ? extends IrSimpleFunctionSymbol> typeToIrFun, KtSingleValueToken operator) {
        void $this$mapNotNullTo$iv$iv;
        PrimitiveType[] $this$mapNotNull$iv = PrimitiveType.values();
        boolean $i$f$mapNotNull = false;
        PrimitiveType[] primitiveTypeArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        void var10_10 = $this$forEach$iv$iv$iv;
        int n = ((void)var10_10).length;
        for (int i = 0; i < n; ++i) {
            Pair<Object, PrimitiveComparison> pair;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = var10_10[i];
            boolean bl = false;
            void primitiveType = element$iv$iv;
            boolean bl2 = false;
            IrType irType = this.getIrBuiltIns().getPrimitiveTypeToIrType().get(primitiveType);
            Intrinsics.checkNotNull(irType);
            IrClassifierSymbol irPrimitiveClassifier = IrTypesKt.getClassifierOrFail(irType);
            Object object = typeToIrFun.get(irPrimitiveClassifier);
            if (object == null) {
                pair = null;
            } else {
                IrSimpleFunctionSymbol irFunSymbol = object;
                object = IrIntrinsicMethods.Companion.toKey(irFunSymbol);
                Intrinsics.checkNotNull(object);
                pair = TuplesKt.to(object, new PrimitiveComparison((PrimitiveType)primitiveType, operator));
            }
            if (pair == null) continue;
            Pair<Object, PrimitiveComparison> pair2 = pair;
            boolean bl3 = false;
            boolean bl4 = false;
            Pair<Object, PrimitiveComparison> it$iv$iv = pair2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0003J;\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0006H\u00d6\u0001R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0019\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "", "owner", "Lorg/jetbrains/kotlin/name/FqName;", "receiverParameterTypeName", "name", "", "valueParameterTypeNames", "", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;Ljava/util/List;)V", "getName", "()Ljava/lang/String;", "getOwner", "()Lorg/jetbrains/kotlin/name/FqName;", "getReceiverParameterTypeName", "getValueParameterTypeNames", "()Ljava/util/List;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "backend.jvm"})
    public static final class Key {
        @NotNull
        private final FqName owner;
        @Nullable
        private final FqName receiverParameterTypeName;
        @NotNull
        private final String name;
        @NotNull
        private final List<FqName> valueParameterTypeNames;

        public Key(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(valueParameterTypeNames, "valueParameterTypeNames");
            this.owner = owner;
            this.receiverParameterTypeName = receiverParameterTypeName;
            this.name = name;
            this.valueParameterTypeNames = valueParameterTypeNames;
        }

        @NotNull
        public final FqName getOwner() {
            return this.owner;
        }

        @Nullable
        public final FqName getReceiverParameterTypeName() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final List<FqName> getValueParameterTypeNames() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final FqName component1() {
            return this.owner;
        }

        @Nullable
        public final FqName component2() {
            return this.receiverParameterTypeName;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        @NotNull
        public final List<FqName> component4() {
            return this.valueParameterTypeNames;
        }

        @NotNull
        public final Key copy(@NotNull FqName owner, @Nullable FqName receiverParameterTypeName, @NotNull String name, @NotNull List<FqName> valueParameterTypeNames) {
            Intrinsics.checkNotNullParameter(owner, "owner");
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(valueParameterTypeNames, "valueParameterTypeNames");
            return new Key(owner, receiverParameterTypeName, name, valueParameterTypeNames);
        }

        public static /* synthetic */ Key copy$default(Key key, FqName fqName2, FqName fqName3, String string2, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = key.owner;
            }
            if ((n & 2) != 0) {
                fqName3 = key.receiverParameterTypeName;
            }
            if ((n & 4) != 0) {
                string2 = key.name;
            }
            if ((n & 8) != 0) {
                list2 = key.valueParameterTypeNames;
            }
            return key.copy(fqName2, fqName3, string2, list2);
        }

        @NotNull
        public String toString() {
            return "Key(owner=" + this.owner + ", receiverParameterTypeName=" + this.receiverParameterTypeName + ", name=" + this.name + ", valueParameterTypeNames=" + this.valueParameterTypeNames + ')';
        }

        public int hashCode() {
            int result2 = this.owner.hashCode();
            result2 = result2 * 31 + (this.receiverParameterTypeName == null ? 0 : this.receiverParameterTypeName.hashCode());
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + ((Object)this.valueParameterTypeNames).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key key = (Key)other;
            if (!Intrinsics.areEqual(this.owner, key.owner)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.receiverParameterTypeName, key.receiverParameterTypeName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.name, key.name)) {
                return false;
            }
            return Intrinsics.areEqual(this.valueParameterTypeNames, key.valueParameterTypeNames);
        }
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JE\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\t2\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0014H\u0002J\"\u0010\u001a\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b0\u001b2\u0006\u0010\u001c\u001a\u00020\u0010H\u0002J\u000e\u0010\u001d\u001a\u0004\u0018\u00010\f*\u00020\u001eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Companion;", "", "()V", "DEC", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/Increment;", "EXPLICIT_EQUALS", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/ExplicitEquals;", "INC", "INTRINSICS_CLASS_NAME", "", "createKeyMapping", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IrIntrinsicMethods$Key;", "Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;", "intrinsic", "klass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "name", "args", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "(Lorg/jetbrains/kotlin/backend/jvm/intrinsics/IntrinsicMethod;Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;Ljava/lang/String;[Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;)Lkotlin/Pair;", "getParameterFqName", "Lorg/jetbrains/kotlin/name/FqName;", "parameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "numberConversionMethods", "", "numberClass", "toKey", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "backend.jvm"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Key toKey(IrFunctionSymbol $this$toKey) {
            Collection<FqName> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object;
            FqName fqName2;
            IrDeclarationParent parent2 = $this$toKey.getOwner().getParent();
            if (parent2 instanceof IrClass && IrUtilsKt.isFileClass((IrDeclaration)((Object)parent2))) {
                fqName2 = ((IrPackageFragment)((IrClass)parent2).getParent()).getFqName();
            } else if (parent2 instanceof IrClass) {
                object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)parent2));
                if (object == null) {
                    return null;
                }
                fqName2 = object;
            } else if (parent2 instanceof IrPackageFragment) {
                fqName2 = ((IrPackageFragment)parent2).getFqName();
            } else {
                return null;
            }
            FqName ownerFqName = fqName2;
            FqName fqName3 = this.getParameterFqName($this$toKey.getOwner().getExtensionReceiverParameter());
            object = $this$toKey.getOwner().getName().asString();
            Intrinsics.checkNotNullExpressionValue(object, "owner.name.asString()");
            Object object2 = object;
            object = $this$toKey.getOwner().getValueParameters();
            Object object3 = object2;
            FqName fqName4 = fqName3;
            FqName fqName5 = ownerFqName;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void p0;
                IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName6 = this.getParameterFqName((IrValueParameter)p0);
                collection.add(fqName6);
            }
            Collection<FqName> collection2 = collection = (List)destination$iv$iv;
            Object object4 = object3;
            FqName fqName7 = fqName4;
            FqName fqName8 = fqName5;
            return new Key(fqName8, fqName7, (String)object4, (List<FqName>)collection2);
        }

        private final FqName getParameterFqName(IrValueParameter parameter) {
            IrType irType;
            IrValueParameter irValueParameter = parameter;
            return this.getParameterFqName(irValueParameter == null ? null : ((irType = irValueParameter.getType()) == null ? null : IrTypesKt.getClassifierOrNull(irType)));
        }

        private final FqName getParameterFqName(IrClassifierSymbol parameter) {
            FqName fqName2;
            IrClassifierSymbol irClassifierSymbol = parameter;
            if (irClassifierSymbol == null) {
                fqName2 = null;
            } else {
                IrSymbolOwner irSymbolOwner = irClassifierSymbol.getOwner();
                if (irSymbolOwner == null) {
                    fqName2 = null;
                } else {
                    IrSymbolOwner irSymbolOwner2 = irSymbolOwner;
                    boolean bl = false;
                    boolean bl2 = false;
                    IrSymbolOwner it = irSymbolOwner2;
                    boolean bl3 = false;
                    IrSymbolOwner irSymbolOwner3 = it;
                    fqName2 = irSymbolOwner3 instanceof IrClass ? IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((Object)it)) : (irSymbolOwner3 instanceof IrTypeParameter ? new FqName(((IrTypeParameter)it).getName().asString()) : null);
                }
            }
            return fqName2;
        }

        /*
         * WARNING - void declaration
         */
        private final Pair<Key, IntrinsicMethod> createKeyMapping(IntrinsicMethod intrinsic, IrClassSymbol klass, String name, IrClassifierSymbol ... args) {
            Collection<FqName> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IrClassifierSymbol[] irClassifierSymbolArray = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)klass.getOwner());
            Intrinsics.checkNotNull(irClassifierSymbolArray);
            IrClassifierSymbol[] irClassifierSymbolArray2 = irClassifierSymbolArray;
            irClassifierSymbolArray = args;
            String string2 = name;
            FqName fqName2 = null;
            IrClassifierSymbol[] irClassifierSymbolArray3 = irClassifierSymbolArray2;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            void var10_13 = $this$mapTo$iv$iv;
            int n = ((void)var10_13).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var14_17 = item$iv$iv = var10_13[i];
                collection = destination$iv$iv;
                boolean bl = false;
                FqName fqName3 = this.getParameterFqName((IrClassifierSymbol)it);
                collection.add(fqName3);
            }
            Collection<FqName> collection2 = collection = (List)destination$iv$iv;
            String string3 = string2;
            FqName fqName4 = fqName2;
            IrClassifierSymbol[] irClassifierSymbolArray4 = irClassifierSymbolArray3;
            return TuplesKt.to(new Key((FqName)irClassifierSymbolArray4, fqName4, string3, (List<FqName>)collection2), intrinsic);
        }

        /*
         * WARNING - void declaration
         */
        private final List<Pair<Key, IntrinsicMethod>> numberConversionMethods(IrClassSymbol numberClass) {
            void $this$mapTo$iv$iv;
            ImmutableSet<Name> immutableSet = OperatorConventions.NUMBER_CONVERSIONS;
            Intrinsics.checkNotNullExpressionValue(immutableSet, "NUMBER_CONVERSIONS");
            Iterable $this$map$iv = immutableSet;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void method;
                Name name = (Name)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IntrinsicMethod intrinsicMethod = NumberCast.INSTANCE;
                String string2 = method.asString();
                Intrinsics.checkNotNullExpressionValue(string2, "method.asString()");
                Pair<Key, IntrinsicMethod> pair = this.createKeyMapping(intrinsicMethod, numberClass, string2, new IrClassifierSymbol[0]);
                collection.add(pair);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

