/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import java.util.ArrayList;
import java.util.List;

public final class FreezableList<E>
extends TransformedList<E, E> {
    private boolean frozen = false;
    private List<E> frozenData = new ArrayList();

    public FreezableList(EventList<E> source2) {
        super(source2);
        source2.addListEventListener(this);
    }

    @Override
    public E get(int index) {
        if (this.frozen) {
            return this.frozenData.get(index);
        }
        return this.source.get(index);
    }

    @Override
    public int size() {
        if (this.frozen) {
            return this.frozenData.size();
        }
        return this.source.size();
    }

    @Override
    protected boolean isWritable() {
        return !this.frozen;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Cannot freeze a list that is already frozen");
        }
        this.source.removeListEventListener(this);
        this.frozenData.addAll(this.source);
        this.frozen = true;
    }

    public void thaw() {
        int i;
        if (!this.frozen) {
            throw new IllegalStateException("Cannot thaw a list that is not frozen");
        }
        this.updates.beginEvent();
        int size = this.frozenData.size();
        for (i = 0; i < size; ++i) {
            this.updates.elementDeleted(0, this.frozenData.get(i));
        }
        size = this.source.size();
        for (i = 0; i < size; ++i) {
            this.updates.elementInserted(0, this.source.get(i));
        }
        this.frozenData.clear();
        this.frozen = false;
        this.source.addListEventListener(this);
        this.updates.commitEvent();
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        if (!this.frozen) {
            this.updates.forwardEvent(listChanges);
        }
    }
}

