/*
 * Decompiled with CFR 0.152.
 */
package mediathek.daten;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import javax.swing.JFrame;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.gui.dialog.DialogOk;
import mediathek.gui.dialogEinstellungen.PanelProgrammPfade;
import mediathek.gui.messages.ProgramSetChangedEvent;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.models.TModel;
import org.apache.commons.lang3.StringUtils;

public class ListePset
extends LinkedList<DatenPset> {
    public static final String MUSTER_PFAD_ZIEL = "ZIELPFAD";
    public static final String MUSTER_PFAD_VLC = "PFAD_VLC";
    public static final String MUSTER_PFAD_FFMPEG = "PFAD_FFMPEG";
    public String version = "";

    public DatenPset getPsetAbspielen() {
        for (DatenPset datenPset : this) {
            if (!Boolean.parseBoolean(datenPset.arr[7])) continue;
            return datenPset;
        }
        return null;
    }

    public DatenPset getPsetAbo(String name) {
        DatenPset ret = null;
        if (this.isEmpty()) {
            ret = null;
        } else if (this.size() == 1) {
            ret = (DatenPset)this.getFirst();
        } else {
            ListePset ps;
            for (DatenPset pset : this) {
                if (!pset.istAbo() || !pset.arr[0].equals(name)) continue;
                ret = pset;
            }
            if (ret == null && (ps = this.getListeAbo()).size() > 0 && (ret = (DatenPset)this.getListeAbo().getFirst()) == null) {
                ret = (DatenPset)this.getFirst();
            }
        }
        return ret;
    }

    public ListePset getListeSpeichern() {
        return this.stream().filter(datenPset -> Boolean.parseBoolean(datenPset.arr[8])).collect(Collectors.toCollection(ListePset::new));
    }

    public ListePset getListeButton() {
        return this.stream().filter(datenPset -> Boolean.parseBoolean(datenPset.arr[9])).collect(Collectors.toCollection(ListePset::new));
    }

    public ListePset getListeAbo() {
        return this.stream().filter(datenPset -> Boolean.parseBoolean(datenPset.arr[10])).collect(Collectors.toCollection(ListePset::new));
    }

    public String[] getObjectDataCombo() {
        int i = 0;
        String[] object = new String[this.size()];
        for (DatenPset datenPset : this) {
            object[i] = datenPset.arr[0];
            ++i;
        }
        return object;
    }

    public int auf(int idx, boolean auf) {
        DatenPset prog = (DatenPset)this.remove(idx);
        int neu = idx;
        if (auf) {
            if (neu > 0) {
                --neu;
            }
        } else if (neu < this.size()) {
            ++neu;
        }
        this.add(neu, prog);
        Daten.getInstance().getMessageBus().publishAsync(new ProgramSetChangedEvent());
        return neu;
    }

    public boolean addPset(DatenPset datenPset) {
        boolean abspielen = false;
        for (DatenPset datenPset1 : this) {
            if (!Boolean.parseBoolean(datenPset1.arr[7])) continue;
            abspielen = true;
            break;
        }
        if (abspielen) {
            datenPset.arr[7] = Boolean.FALSE.toString();
        }
        boolean ret = this.add(datenPset);
        Daten.getInstance().getMessageBus().publishAsync(new ProgramSetChangedEvent());
        return ret;
    }

    public boolean addPset(ListePset liste) {
        boolean ret = true;
        for (DatenPset entry : liste) {
            if (this.addPset(entry)) continue;
            ret = false;
        }
        Daten.getInstance().getMessageBus().publishAsync(new ProgramSetChangedEvent());
        return ret;
    }

    public static void progMusterErsetzen(JFrame parent, ListePset liste) {
        for (DatenPset pSet : liste) {
            ListePset.progMusterErsetzen(parent, pSet);
        }
        Daten.getInstance().getMessageBus().publishAsync(new ProgramSetChangedEvent());
    }

    private static void progMusterErsetzen(JFrame parent, DatenPset pSet) {
        DatenProg prog;
        int p;
        pSet.arr[4] = StringUtils.replace(pSet.arr[4], MUSTER_PFAD_ZIEL, GuiFunktionen.getStandardDownloadPath());
        String vlc = "";
        String ffmpeg = "";
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_VLC) && !prog.arr[3].contains(MUSTER_PFAD_VLC)) continue;
            vlc = ListePset.getPfadVlc(parent);
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            if (!prog.arr[2].contains(MUSTER_PFAD_FFMPEG) && !prog.arr[3].contains(MUSTER_PFAD_FFMPEG)) continue;
            ffmpeg = ListePset.getPfadFFmpeg(parent);
            break;
        }
        for (p = 0; p < pSet.getListeProg().size(); ++p) {
            prog = pSet.getProg(p);
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_VLC, Matcher.quoteReplacement(vlc));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_VLC, Matcher.quoteReplacement(vlc));
            prog.arr[2] = prog.arr[2].replaceAll(MUSTER_PFAD_FFMPEG, Matcher.quoteReplacement(ffmpeg));
            prog.arr[3] = prog.arr[3].replaceAll(MUSTER_PFAD_FFMPEG, Matcher.quoteReplacement(ffmpeg));
        }
    }

    private static String getPfadVlc(JFrame parent) {
        if (MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC).isEmpty()) {
            new DialogOk(null, true, new PanelProgrammPfade(parent, true, false), "Pfade Standardprogramme").setVisible(true);
        }
        return MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC);
    }

    private static String getPfadFFmpeg(JFrame parent) {
        if (MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG).isEmpty()) {
            new DialogOk(null, true, new PanelProgrammPfade(parent, false, true), "Pfade Standardprogramme").setVisible(true);
        }
        return MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG);
    }

    public TModel getModel() {
        TModel model;
        int i = 0;
        if (this.size() > 0) {
            Iterator iterator2 = this.iterator();
            Object[][] object = new Object[this.size()][22];
            while (iterator2.hasNext()) {
                DatenPset datenPset = (DatenPset)iterator2.next();
                object[i] = datenPset.arr;
                ++i;
            }
            model = new TModel(object, DatenPset.COLUMN_NAMES);
        } else {
            model = new TModel(new Object[0][22], DatenPset.COLUMN_NAMES);
        }
        return model;
    }

    public ArrayList<String> getListProg() {
        return this.stream().map(DatenPset::toString).collect(Collectors.toCollection(ArrayList::new));
    }
}

