/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.swing;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0010\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0002J\u0014\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u00060\u0016j\u0002`\u0017H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lmediathek/tool/swing/ThreadCheckingRepaintManager;", "Ljavax/swing/RepaintManager;", "()V", "checkIsShowing", "", "isCompleteCheck", "addDirtyRegion", "", "jComponent", "Ljavax/swing/JComponent;", "i", "", "i1", "i2", "i3", "addInvalidComponent", "checkIfComponentIsShowing", "c", "checkThreadViolations", "getStrackTraceAsString", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "MediathekView"})
public final class ThreadCheckingRepaintManager
extends RepaintManager {
    private final boolean isCompleteCheck;
    private final boolean checkIsShowing;

    @Override
    public synchronized void addInvalidComponent(@NotNull JComponent jComponent) {
        Intrinsics.checkNotNullParameter(jComponent, "jComponent");
        this.checkThreadViolations(jComponent);
        super.addInvalidComponent(jComponent);
    }

    @Override
    public synchronized void addDirtyRegion(@NotNull JComponent jComponent, int i, int i1, int i2, int i3) {
        Intrinsics.checkNotNullParameter(jComponent, "jComponent");
        this.checkThreadViolations(jComponent);
        super.addDirtyRegion(jComponent, i, i1, i2, i3);
    }

    private final void checkThreadViolations(JComponent c) {
        if (!SwingUtilities.isEventDispatchThread() && (this.isCompleteCheck || this.checkIfComponentIsShowing(c))) {
            StackTraceElement[] stackTrace;
            Exception exception = new Exception();
            boolean repaint = false;
            boolean fromSwing = false;
            for (StackTraceElement st : stackTrace = exception.getStackTrace()) {
                if (repaint) {
                    StackTraceElement stackTraceElement = st;
                    Intrinsics.checkNotNullExpressionValue(stackTraceElement, "st");
                    String string = stackTraceElement.getClassName();
                    Intrinsics.checkNotNullExpressionValue(string, "st.className");
                    if (StringsKt.startsWith$default(string, "javax.swing.", false, 2, null)) {
                        fromSwing = true;
                    }
                }
                StackTraceElement stackTraceElement = st;
                Intrinsics.checkNotNullExpressionValue(stackTraceElement, "st");
                if (!Intrinsics.areEqual("repaint", stackTraceElement.getMethodName())) continue;
                repaint = true;
            }
            if (repaint && !fromSwing) {
                return;
            }
            String string = "----------Wrong Thread START";
            int n = 0;
            System.out.println((Object)string);
            string = this.getStrackTraceAsString(exception);
            n = 0;
            System.out.println((Object)string);
            string = "----------Wrong Thread END";
            n = 0;
            System.out.println((Object)string);
        }
    }

    private final boolean checkIfComponentIsShowing(JComponent c) {
        return this.checkIsShowing ? c.isShowing() : true;
    }

    private final String getStrackTraceAsString(Exception e) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(byteArrayOutputStream);
        e.printStackTrace(printStream);
        printStream.flush();
        String string = byteArrayOutputStream.toString();
        Intrinsics.checkNotNullExpressionValue(string, "byteArrayOutputStream.toString()");
        return string;
    }

    public ThreadCheckingRepaintManager() {
        this.isCompleteCheck = true;
    }
}

