/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import com.jwetherell.openmap.common.LatLonPoint;
import com.jwetherell.openmap.common.UTMPoint;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.StringTokenizer;
import net.osmand.data.LatLon;
import net.osmand.data.LocationPoint;
import net.osmand.plus.OsmandSettings;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;

public class PointDescription {
    private String type = "";
    private String name = "";
    private String typeName;
    private double lat = 0.0;
    private double lon = 0.0;
    public static final String POINT_TYPE_FAVORITE = "favorite";
    public static final String POINT_TYPE_WPT = "wpt";
    public static final String POINT_TYPE_POI = "poi";
    public static final String POINT_TYPE_ADDRESS = "address";
    public static final String POINT_TYPE_OSM_NOTE = "osm_note";
    public static final String POINT_TYPE_MARKER = "marker";
    public static final String POINT_TYPE_PARKING_MARKER = "parking_marker";
    public static final String POINT_TYPE_AUDIO_NOTE = "audionote";
    public static final String POINT_TYPE_VIDEO_NOTE = "videonote";
    public static final String POINT_TYPE_PHOTO_NOTE = "photonote";
    public static final String POINT_TYPE_LOCATION = "location";
    public static final String POINT_TYPE_MY_LOCATION = "my_location";
    public static final String POINT_TYPE_ALARM = "alarm";
    public static final String POINT_TYPE_TARGET = "destination";
    public static final String POINT_TYPE_MAP_MARKER = "map_marker";
    public static final String POINT_TYPE_OSM_BUG = "bug";
    public static final String POINT_TYPE_WORLD_REGION = "world_region";
    public static final String POINT_TYPE_GPX_ITEM = "gpx_item";
    public static final String POINT_TYPE_WORLD_REGION_SHOW_ON_MAP = "world_region_show_on_map";
    public static final String POINT_TYPE_BLOCKED_ROAD = "blocked_road";
    public static final PointDescription LOCATION_POINT = new PointDescription("location", "");
    public static final int FORMAT_DEGREES = 0;
    public static final int FORMAT_MINUTES = 1;
    public static final int FORMAT_SECONDS = 2;
    public static final int UTM_FORMAT = 3;
    private static final char DELIM = ':';

    public PointDescription(double lat, double lon) {
        this(POINT_TYPE_LOCATION, "");
        this.lat = lat;
        this.lon = lon;
    }

    public PointDescription(String type, String name) {
        this.type = type;
        this.name = name;
        if (this.name == null) {
            this.name = "";
        }
    }

    public PointDescription(String type, String typeName, String name) {
        this.type = type;
        this.name = name;
        this.typeName = typeName;
        if (this.name == null) {
            this.name = "";
        }
    }

    public void setLat(double lat) {
        this.lat = lat;
    }

    public void setLon(double lon) {
        this.lon = lon;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getName() {
        return this.name;
    }

    public String getSimpleName(OsmWindow ctx, boolean addTypeName) {
        if (this.isLocation()) {
            if (!Algorithms.isEmpty(this.name) && !this.name.equals(ctx.getString(53))) {
                return this.name;
            }
            return PointDescription.getLocationName(ctx, this.lat, this.lon, true).replace('\n', ' ');
        }
        if (!Algorithms.isEmpty(this.typeName)) {
            if (Algorithms.isEmpty(this.name)) {
                return this.typeName;
            }
            if (addTypeName) {
                return this.typeName.trim() + ": " + this.name;
            }
        }
        return this.name;
    }

    public String getFullPlainName(OsmWindow ctx) {
        if (this.isLocation()) {
            return PointDescription.getLocationName(ctx, this.lat, this.lon, false);
        }
        String typeName = this.typeName;
        if (this.isFavorite()) {
            typeName = ctx.getString(735);
        } else if (this.isPoi()) {
            typeName = ctx.getString(784);
        } else if (this.isWpt()) {
            return ctx.getString(1513);
        }
        if (!Algorithms.isEmpty(typeName)) {
            if (Algorithms.isEmpty(this.name)) {
                return typeName;
            }
            return typeName.trim() + ": " + this.name;
        }
        return this.name;
    }

    public static String getLocationName(OsmWindow ctx, double lat, double lon, boolean sh) {
        OsmandSettings st = ctx.getSettings();
        int f = st.COORDINATES_FORMAT.get();
        if (f == 3) {
            UTMPoint pnt = new UTMPoint(new LatLonPoint(lat, lon));
            return pnt.zone_number + "" + pnt.zone_letter + " " + (long)pnt.northing + " " + (long)pnt.easting;
        }
        try {
            return ctx.getString(sh ? 1745 : 1669, PointDescription.convert(lat, f), PointDescription.convert(lon, f));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return ctx.getString(sh ? 1745 : 1669, 0, 0);
        }
    }

    public boolean contextMenuDisabled() {
        return POINT_TYPE_WORLD_REGION_SHOW_ON_MAP.equals(this.type);
    }

    public boolean isLocation() {
        return POINT_TYPE_LOCATION.equals(this.type);
    }

    public boolean isAddress() {
        return POINT_TYPE_ADDRESS.equals(this.type);
    }

    public boolean isWpt() {
        return POINT_TYPE_WPT.equals(this.type);
    }

    public boolean isPoi() {
        return POINT_TYPE_POI.equals(this.type);
    }

    public boolean isFavorite() {
        return POINT_TYPE_FAVORITE.equals(this.type);
    }

    public boolean isAudioNote() {
        return POINT_TYPE_AUDIO_NOTE.equals(this.type);
    }

    public boolean isVideoNote() {
        return POINT_TYPE_VIDEO_NOTE.equals(this.type);
    }

    public boolean isPhotoNote() {
        return POINT_TYPE_PHOTO_NOTE.equals(this.type);
    }

    public boolean isDestination() {
        return POINT_TYPE_TARGET.equals(this.type);
    }

    public boolean isMapMarker() {
        return POINT_TYPE_MAP_MARKER.equals(this.type);
    }

    public boolean isParking() {
        return POINT_TYPE_PARKING_MARKER.equals(this.type);
    }

    public boolean isMyLocation() {
        return POINT_TYPE_MY_LOCATION.equals(this.type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.typeName == null ? 0 : this.typeName.hashCode());
        result = 31 * result + (this.lat == 0.0 ? 0 : new Double(this.lat).hashCode());
        result = 31 * result + (this.lon == 0.0 ? 0 : new Double(this.lon).hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PointDescription other = (PointDescription)obj;
        return Algorithms.objectEquals(other.name, this.name) && Algorithms.objectEquals(other.type, this.type) && Algorithms.objectEquals(other.lat, this.lat) && Algorithms.objectEquals(other.lon, this.lon) && Algorithms.objectEquals(other.typeName, this.typeName);
    }

    public static String getSimpleName(LocationPoint o, OsmWindow ctx) {
        PointDescription pd = o.getPointDescription(ctx);
        return pd.getSimpleName(ctx, true);
    }

    public boolean isSearchingAddress(OsmWindow ctx) {
        return !Algorithms.isEmpty(this.name) && this.isLocation() && this.name.equals(PointDescription.getSearchAddressStr(ctx));
    }

    public static String getSearchAddressStr(OsmWindow ctx) {
        return ctx.getString(1860) + ctx.getString(1679);
    }

    public static String getAddressNotFoundStr(OsmWindow ctx) {
        return ctx.getString(53);
    }

    public static String serializeToString(PointDescription p) {
        if (p == null) {
            return "";
        }
        String tp = p.type;
        if (!Algorithms.isEmpty(p.typeName)) {
            tp = tp + '.' + p.typeName;
        }
        return tp + "#" + p.name;
    }

    public static PointDescription deserializeFromString(String s, LatLon l) {
        int in;
        PointDescription pd = null;
        if (s != null && s.length() > 0 && (in = s.indexOf(35)) >= 0) {
            String nm = s.substring(in + 1).trim();
            String tp = s.substring(0, in);
            pd = tp.contains(".") ? new PointDescription(tp.substring(0, tp.indexOf(46)), tp.substring(tp.indexOf(46) + 1), nm) : new PointDescription(tp, nm);
        }
        if (pd == null) {
            pd = new PointDescription(POINT_TYPE_LOCATION, "");
        }
        if (pd.isLocation() && l != null) {
            pd.setLat(l.getLatitude());
            pd.setLon(l.getLongitude());
        }
        return pd;
    }

    public static double convert(String coordinate) {
        StringTokenizer st;
        int tokens;
        if ((coordinate = coordinate.replace(' ', ':').replace('#', ':').replace(',', '.')) == null) {
            throw new NullPointerException("coordinate");
        }
        boolean negative = false;
        if (coordinate.charAt(0) == '-') {
            coordinate = coordinate.substring(1);
            negative = true;
        }
        if ((tokens = (st = new StringTokenizer(coordinate, ":")).countTokens()) < 1) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        try {
            boolean isNegative180;
            double min;
            String degrees = st.nextToken();
            if (tokens == 1) {
                double val = Double.parseDouble(degrees);
                return negative ? -val : val;
            }
            String minutes = st.nextToken();
            int deg = Integer.parseInt(degrees);
            double sec = 0.0;
            if (st.hasMoreTokens()) {
                min = Integer.parseInt(minutes);
                String seconds = st.nextToken();
                sec = Double.parseDouble(seconds);
            } else {
                min = Double.parseDouble(minutes);
            }
            boolean bl = isNegative180 = negative && deg == 180 && min == 0.0 && sec == 0.0;
            if ((double)deg < 0.0 || deg > 180 && !isNegative180) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (min < 0.0 || min > 60.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            if (sec < 0.0 || sec > 60.0) {
                throw new IllegalArgumentException("coordinate=" + coordinate);
            }
            double val = (double)deg * 3600.0 + min * 60.0 + sec;
            return negative ? -val : (val /= 3600.0);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
    }

    public static String convert(double coordinate, int outputType) {
        if (coordinate < -180.0 || coordinate > 180.0 || Double.isNaN(coordinate)) {
            throw new IllegalArgumentException("coordinate=" + coordinate);
        }
        if (outputType != 0 && outputType != 1 && outputType != 2) {
            throw new IllegalArgumentException("outputType=" + outputType);
        }
        StringBuilder sb = new StringBuilder();
        if (coordinate < 0.0) {
            sb.append('-');
            coordinate = -coordinate;
        }
        DecimalFormat df = new DecimalFormat("###.#####", new DecimalFormatSymbols(Locale.US));
        if (outputType == 1 || outputType == 2) {
            int degrees = (int)Math.floor(coordinate);
            sb.append(degrees);
            sb.append(':');
            coordinate -= (double)degrees;
            coordinate *= 60.0;
            if (outputType == 2) {
                int minutes = (int)Math.floor(coordinate);
                sb.append(minutes);
                sb.append(':');
                coordinate -= (double)minutes;
                coordinate *= 60.0;
            }
        }
        sb.append(df.format(coordinate));
        return sb.toString();
    }
}

