/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer;

import java.util.HashMap;
import java.util.Map;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.renderer.AbstractOWLEntityRenderer;
import org.protege.editor.owl.ui.renderer.RenderingEscapeUtils;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.vocab.DublinCoreVocabulary;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLEntityRendererImpl
extends AbstractOWLEntityRenderer {
    private Map<IRI, String> wellKnownRenderings = new HashMap<IRI, String>();

    @Override
    public void initialise() {
        for (OWLRDFVocabulary oWLRDFVocabulary : OWLRDFVocabulary.values()) {
            this.addOWLRDFVocabulary(oWLRDFVocabulary);
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : OWL2Datatype.values()) {
            this.wellKnownRenderings.put(oWLRDFVocabulary.getIRI(), oWLRDFVocabulary.getPrefixedName());
        }
        for (OWLRDFVocabulary oWLRDFVocabulary : DublinCoreVocabulary.values()) {
            this.wellKnownRenderings.put(oWLRDFVocabulary.getIRI(), oWLRDFVocabulary.getPrefixedName());
        }
    }

    private void addOWLRDFVocabulary(OWLRDFVocabulary vocabulary) {
        this.wellKnownRenderings.put(vocabulary.getIRI(), vocabulary.getPrefixedName());
    }

    private String getSubstringFromLastCharacter(String iriString, char lastChar) {
        int index = iriString.lastIndexOf(lastChar);
        if (index != -1 && index < iriString.length()) {
            return RenderingEscapeUtils.getEscapedRendering(iriString.substring(index + 1));
        }
        return null;
    }

    @Override
    public String render(IRI iri) {
        try {
            String wellKnownName = this.wellKnownRenderings.get(iri);
            if (wellKnownName != null) {
                return wellKnownName;
            }
            String iriString = iri.toString();
            for (Namespaces ns : Namespaces.values()) {
                if (!iriString.startsWith(ns.getPrefixIRI())) continue;
                return ns.getPrefixName() + ":" + iriString.substring(ns.getPrefixIRI().length());
            }
            String fragment = this.getSubstringFromLastCharacter(iriString, '#');
            if (fragment != null) {
                return fragment;
            }
            String pathElement = this.getSubstringFromLastCharacter(iriString, '/');
            if (pathElement != null) {
                return pathElement;
            }
            return RenderingEscapeUtils.getEscapedRendering(iri.toQuotedString());
        }
        catch (Exception e) {
            return "<Error! " + e.getMessage() + ">";
        }
    }

    @Override
    public boolean isConfigurable() {
        return false;
    }

    @Override
    public boolean configure(OWLEditorKit eKit) {
        throw new IllegalStateException("This renderer is not configurable");
    }

    @Override
    protected void disposeRenderer() {
    }
}

