/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.nkjp;

import java.io.File;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.nkjp.NKJPSegmentationDocument;
import opennlp.tools.formats.nkjp.NKJPSentenceSampleStream;
import opennlp.tools.formats.nkjp.NKJPTextDocument;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.util.ObjectStream;

public class NKJPSentenceSampleStreamFactory
extends AbstractSampleStreamFactory<SentenceSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "nkjp", new NKJPSentenceSampleStreamFactory(Parameters.class));
    }

    protected <P> NKJPSentenceSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        CmdLineUtil.checkInputFile("Text", params.getTextFile());
        NKJPSegmentationDocument segDoc = null;
        NKJPTextDocument textDoc = null;
        try {
            segDoc = NKJPSegmentationDocument.parse(params.getData());
            textDoc = NKJPTextDocument.parse(params.getTextFile());
        }
        catch (IOException ex) {
            CmdLineUtil.handleCreateObjectStreamError(ex);
        }
        return new NKJPSentenceSampleStream(segDoc, textDoc);
    }

    static interface Parameters
    extends BasicFormatParams {
        @ArgumentParser.ParameterDescription(valueName="text", description="file containing NKJP text")
        public File getTextFile();
    }
}

