/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.PluginInfo;

public class InitParams {
    public static final String TYPE = "initParams";
    public final String name;
    public final Set<String> paths;
    public final NamedList defaults;
    public final NamedList invariants;
    public final NamedList appends;
    private final PluginInfo pluginInfo;
    private final Set<String> KNOWN_KEYS = ImmutableSet.of((Object)"defaults", (Object)"invariants", (Object)"appends");

    public InitParams(PluginInfo p) {
        this.pluginInfo = p;
        this.name = p.attributes.get("name");
        Set paths = null;
        String pathStr = p.attributes.get("path");
        if (pathStr != null) {
            paths = Collections.unmodifiableSet(new HashSet(StrUtils.splitSmart((String)pathStr, (char)',')));
        }
        this.paths = paths;
        NamedList nl = (NamedList)p.initArgs.get("defaults");
        this.defaults = nl == null ? null : nl.getImmutableCopy();
        nl = (NamedList)p.initArgs.get("invariants");
        this.invariants = nl == null ? null : nl.getImmutableCopy();
        nl = (NamedList)p.initArgs.get("appends");
        this.appends = nl == null ? null : nl.getImmutableCopy();
    }

    public boolean matchPath(String name) {
        if (this.paths == null) {
            return false;
        }
        if (this.paths.contains(name)) {
            return true;
        }
        for (String path : this.paths) {
            if (!InitParams.matchPath(path, name)) continue;
            return true;
        }
        return false;
    }

    private static boolean matchPath(String path, String name) {
        int i;
        List pathSplit = StrUtils.splitSmart((String)path, (char)'/');
        List nameSplit = StrUtils.splitSmart((String)name, (char)'/');
        for (i = 0; i < nameSplit.size(); ++i) {
            String ps;
            String s = (String)nameSplit.get(i);
            String string = ps = pathSplit.size() > i ? (String)pathSplit.get(i) : null;
            if (ps == null) {
                return false;
            }
            if (s.equals(ps)) continue;
            if ("*".equals(ps) && nameSplit.size() == i + 1) {
                return true;
            }
            return "**".equals(ps);
        }
        String ps = pathSplit.size() > i ? (String)pathSplit.get(i) : null;
        return "*".equals(ps) || "**".equals(ps);
    }

    public void apply(PluginInfo info) {
        if (!info.isFromSolrConfig()) {
            InitParams.merge(this.defaults, (NamedList)info.initArgs.get("defaults"), info.initArgs, "defaults", false);
        } else {
            InitParams.merge((NamedList)info.initArgs.get("defaults"), this.defaults, info.initArgs, "defaults", false);
        }
        InitParams.merge((NamedList)info.initArgs.get("invariants"), this.invariants, info.initArgs, "invariants", false);
        InitParams.merge((NamedList)info.initArgs.get("appends"), this.appends, info.initArgs, "appends", true);
        if (this.pluginInfo.initArgs != null) {
            for (int i = 0; i < this.pluginInfo.initArgs.size(); ++i) {
                Object val;
                String name = this.pluginInfo.initArgs.getName(i);
                if (this.KNOWN_KEYS.contains(name) || (val = info.initArgs.get(name)) != null) continue;
                info.initArgs.add(name, this.pluginInfo.initArgs.getVal(i));
            }
        }
    }

    private static void merge(NamedList first, NamedList second, NamedList sink, String name, boolean appends) {
        if (first == null && second == null) {
            return;
        }
        if (first == null) {
            first = new NamedList();
        }
        NamedList nl = first.clone();
        if (appends) {
            if (second != null) {
                nl.addAll(second);
            }
        } else {
            Map.Entry e;
            HashSet<String> a = new HashSet<String>();
            HashSet<String> b = new HashSet<String>();
            for (Object o : first) {
                e = (Map.Entry)o;
                a.add((String)e.getKey());
            }
            if (second != null) {
                for (Object o : second) {
                    e = (Map.Entry)o;
                    b.add((String)e.getKey());
                }
            }
            for (String s : b) {
                if (a.contains(s)) continue;
                for (Object v : second.getAll(s)) {
                    nl.add(s, v);
                }
            }
        }
        if (sink.indexOf(name, 0) > -1) {
            sink.setVal(sink.indexOf(name, 0), (Object)nl);
        } else {
            sink.add(name, (Object)nl);
        }
    }
}

