/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.RecursiveEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ColumnEvaluator
extends RecursiveEvaluator {
    protected static final long serialVersionUID = 1L;

    public ColumnEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        this.init();
    }

    public ColumnEvaluator(StreamExpression expression, StreamFactory factory, List<String> ignoredNamedParameters) throws IOException {
        super(expression, factory, ignoredNamedParameters);
        this.init();
    }

    private void init() throws IOException {
        if (2 != this.containedEvaluators.size()) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting exactly 2 parameters but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        }
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        try {
            Object firstLevel = ((StreamEvaluator)this.containedEvaluators.get(0)).evaluate(tuple);
            if (!(firstLevel instanceof List) || ((List)firstLevel).stream().anyMatch(value -> !(value instanceof Tuple))) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting a list of tuples but found %s", this.toExpression(this.constructingFactory), firstLevel.getClass().getSimpleName()));
            }
            ArrayList<Object> column = new ArrayList<Object>();
            for (Object innerTuple : (List)firstLevel) {
                column.add(((StreamEvaluator)this.containedEvaluators.get(1)).evaluate((Tuple)innerTuple));
            }
            return this.normalizeOutputType(column);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        throw new IOException("This call should never occur");
    }
}

