/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

public class LogWriter {
    String name;
    int level;
    LogWriter next;
    static LogWriter log_writers;
    static int globalLogLevel;

    public LogWriter(String string) {
        this.name = string;
        this.level = globalLogLevel;
        this.next = log_writers;
        log_writers = this;
    }

    public void setLevel(int n) {
        this.level = n;
    }

    public void write(int n, String string) {
        if (n <= this.level) {
            System.err.println(this.name + ": " + string);
        }
    }

    public void error(String string, Object ... objectArray) {
        this.write(0, String.format(string, objectArray));
    }

    public void status(String string, Object ... objectArray) {
        this.write(10, String.format(string, objectArray));
    }

    public void info(String string, Object ... objectArray) {
        this.write(30, String.format(string, objectArray));
    }

    public void debug(String string, Object ... objectArray) {
        this.write(100, String.format(string, objectArray));
    }

    public static boolean setLogParams(String string) {
        globalLogLevel = Integer.parseInt(string);
        LogWriter logWriter = log_writers;
        while (logWriter != null) {
            logWriter.setLevel(globalLogLevel);
            logWriter = logWriter.next;
        }
        return true;
    }

    static LogWriter getLogWriter(String string) {
        LogWriter logWriter = log_writers;
        while (logWriter != null) {
            if (string.equalsIgnoreCase(logWriter.name)) {
                return logWriter;
            }
            logWriter = logWriter.next;
        }
        return null;
    }

    static {
        globalLogLevel = 30;
    }
}

