/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.security.auth.x500.X500Principal;
import sun.net.idn.Punycode;
import sun.net.idn.StringPrep;
import sun.net.util.IPAddressUtil;
import sun.security.ssl.Krb5Helper;
import sun.security.util.DerValue;
import sun.security.x509.X500Name;
import sun.text.normalizer.UCharacterIterator;

public class HostnameChecker {
    public static final byte TYPE_TLS = 1;
    private static final HostnameChecker INSTANCE_TLS;
    public static final byte TYPE_LDAP = 2;
    private static final HostnameChecker INSTANCE_LDAP;
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private final byte checkType;
    private static final String ACE_PREFIX = "xn--";
    private static final int ACE_PREFIX_LENGTH;
    private static final int MAX_LABEL_LENGTH = 63;
    private static StringPrep namePrep;

    private HostnameChecker(byte checkType) {
        this.checkType = checkType;
    }

    public static HostnameChecker getInstance(byte checkType) {
        if (checkType == 1) {
            return INSTANCE_TLS;
        }
        if (checkType == 2) {
            return INSTANCE_LDAP;
        }
        throw new IllegalArgumentException("Unknown check type: " + checkType);
    }

    public void match(String expectedName, X509Certificate cert) throws CertificateException {
        if (HostnameChecker.isIpAddress(expectedName)) {
            HostnameChecker.matchIP(expectedName, cert);
        } else {
            this.matchDNS(expectedName, cert);
        }
    }

    public static boolean match(String expectedName, Principal principal) {
        String hostName = HostnameChecker.getServerName(principal);
        return expectedName.equalsIgnoreCase(hostName);
    }

    public static String getServerName(Principal principal) {
        return Krb5Helper.getPrincipalHostName((Principal)principal);
    }

    private static boolean isIpAddress(String name) {
        return IPAddressUtil.isIPv4LiteralAddress(name) || IPAddressUtil.isIPv6LiteralAddress(name);
    }

    private static void matchIP(String expectedIP, X509Certificate cert) throws CertificateException {
        Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
        if (subjAltNames == null) {
            throw new CertificateException("No subject alternative names present");
        }
        for (List<?> next : subjAltNames) {
            if ((Integer)next.get(0) != 7) continue;
            String ipAddress = (String)next.get(1);
            if (expectedIP.equalsIgnoreCase(ipAddress)) {
                return;
            }
            try {
                if (!InetAddress.getByName(expectedIP).equals(InetAddress.getByName(ipAddress))) continue;
                return;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
            }
        }
        throw new CertificateException("No subject alternative names matching IP address " + expectedIP + " found");
    }

    private void matchDNS(String expectedName, X509Certificate cert) throws CertificateException {
        X500Name subjectName;
        DerValue derValue;
        try {
            HostnameChecker.checkHostName(expectedName);
        }
        catch (IllegalArgumentException iae) {
            throw new CertificateException("Illegal given domain name: " + expectedName, iae);
        }
        Collection<List<?>> subjAltNames = cert.getSubjectAlternativeNames();
        if (subjAltNames != null) {
            boolean foundDNS = false;
            for (List<?> next : subjAltNames) {
                if ((Integer)next.get(0) != 2) continue;
                foundDNS = true;
                String dnsName = (String)next.get(1);
                if (!this.isMatched(expectedName, dnsName)) continue;
                return;
            }
            if (foundDNS) {
                throw new CertificateException("No subject alternative DNS name matching " + expectedName + " found.");
            }
        }
        if ((derValue = (subjectName = HostnameChecker.getSubjectX500Name(cert)).findMostSpecificAttribute(X500Name.commonName_oid)) != null) {
            try {
                if (this.isMatched(expectedName, derValue.getAsString())) {
                    return;
                }
            }
            catch (IOException next) {
                // empty catch block
            }
        }
        String msg = "No name matching " + expectedName + " found";
        throw new CertificateException(msg);
    }

    public static X500Name getSubjectX500Name(X509Certificate cert) throws CertificateParsingException {
        try {
            Principal subjectDN = cert.getSubjectDN();
            if (subjectDN instanceof X500Name) {
                return (X500Name)subjectDN;
            }
            X500Principal subjectX500 = cert.getSubjectX500Principal();
            return new X500Name(subjectX500.getEncoded());
        }
        catch (IOException e) {
            throw (CertificateParsingException)new CertificateParsingException().initCause(e);
        }
    }

    private boolean isMatched(String name, String template) {
        try {
            HostnameChecker.checkHostName(template.replace('*', 'z'));
        }
        catch (IllegalArgumentException iae) {
            return false;
        }
        if (this.checkType == 1) {
            return HostnameChecker.matchAllWildcards(name, template);
        }
        if (this.checkType == 2) {
            return HostnameChecker.matchLeftmostWildcard(name, template);
        }
        return false;
    }

    private static boolean matchAllWildcards(String name, String template) {
        name = name.toLowerCase(Locale.ENGLISH);
        template = template.toLowerCase(Locale.ENGLISH);
        StringTokenizer nameSt = new StringTokenizer(name, ".");
        StringTokenizer templateSt = new StringTokenizer(template, ".");
        if (nameSt.countTokens() != templateSt.countTokens()) {
            return false;
        }
        while (nameSt.hasMoreTokens()) {
            if (HostnameChecker.matchWildCards(nameSt.nextToken(), templateSt.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchLeftmostWildcard(String name, String template) {
        name = name.toLowerCase(Locale.ENGLISH);
        template = template.toLowerCase(Locale.ENGLISH);
        int templateIdx = template.indexOf(".");
        int nameIdx = name.indexOf(".");
        if (templateIdx == -1) {
            templateIdx = template.length();
        }
        if (nameIdx == -1) {
            nameIdx = name.length();
        }
        if (HostnameChecker.matchWildCards(name.substring(0, nameIdx), template.substring(0, templateIdx))) {
            return template.substring(templateIdx).equals(name.substring(nameIdx));
        }
        return false;
    }

    private static boolean matchWildCards(String name, String template) {
        int wildcardIdx = template.indexOf("*");
        if (wildcardIdx == -1) {
            return name.equals(template);
        }
        boolean isBeginning = true;
        String beforeWildcard = "";
        String afterWildcard = template;
        while (wildcardIdx != -1) {
            beforeWildcard = afterWildcard.substring(0, wildcardIdx);
            afterWildcard = afterWildcard.substring(wildcardIdx + 1);
            int beforeStartIdx = name.indexOf(beforeWildcard);
            if (beforeStartIdx == -1 || isBeginning && beforeStartIdx != 0) {
                return false;
            }
            isBeginning = false;
            name = name.substring(beforeStartIdx + beforeWildcard.length());
            wildcardIdx = afterWildcard.indexOf("*");
        }
        return name.endsWith(afterWildcard);
    }

    private static void checkHostName(String hostname) {
        hostname = HostnameChecker.toASCII(Objects.requireNonNull(hostname, "Server name value of host_name cannot be null"), 2);
        hostname.getBytes(StandardCharsets.US_ASCII);
        if (hostname.isEmpty()) {
            throw new IllegalArgumentException("Server name value of host_name cannot be empty");
        }
        if (hostname.endsWith(".")) {
            throw new IllegalArgumentException("Server name value of host_name cannot have the trailing dot");
        }
    }

    private static String toASCII(String input, int flag) {
        int p = 0;
        int q = 0;
        StringBuffer out = new StringBuffer();
        if (HostnameChecker.isRootLabel(input)) {
            return ".";
        }
        while (p < input.length()) {
            q = HostnameChecker.searchDots(input, p);
            out.append(HostnameChecker.toASCIIInternal(input.substring(p, q), flag));
            if (q != input.length()) {
                out.append('.');
            }
            p = q + 1;
        }
        return out.toString();
    }

    private static String toASCIIInternal(String label, int flag) {
        boolean useSTD3ASCIIRules;
        StringBuffer dest;
        boolean isASCII = HostnameChecker.isAllASCII(label);
        if (!isASCII) {
            UCharacterIterator iter = UCharacterIterator.getInstance(label);
            try {
                dest = namePrep.prepare(iter, flag);
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        } else {
            dest = new StringBuffer(label);
        }
        if (dest.length() == 0) {
            throw new IllegalArgumentException("Empty label is not a legal name");
        }
        boolean bl = useSTD3ASCIIRules = (flag & 2) != 0;
        if (useSTD3ASCIIRules) {
            for (int i = 0; i < dest.length(); ++i) {
                char c = dest.charAt(i);
                if (!HostnameChecker.isNonLDHAsciiCodePoint(c)) continue;
                throw new IllegalArgumentException("Contains non-LDH ASCII characters");
            }
            if (dest.charAt(0) == '-' || dest.charAt(dest.length() - 1) == '-') {
                throw new IllegalArgumentException("Has leading or trailing hyphen");
            }
        }
        if (!isASCII && !HostnameChecker.isAllASCII(dest.toString())) {
            if (!HostnameChecker.startsWithACEPrefix(dest)) {
                try {
                    dest = Punycode.encode(dest, null);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
                dest = HostnameChecker.toASCIILower(dest);
                dest.insert(0, ACE_PREFIX);
            } else {
                throw new IllegalArgumentException("The input starts with the ACE Prefix");
            }
        }
        if (dest.length() > 63) {
            throw new IllegalArgumentException("The label in the input is too long");
        }
        return dest.toString();
    }

    private static boolean isNonLDHAsciiCodePoint(int ch) {
        return 0 <= ch && ch <= 44 || 46 <= ch && ch <= 47 || 58 <= ch && ch <= 64 || 91 <= ch && ch <= 96 || 123 <= ch && ch <= 127;
    }

    private static int searchDots(String s, int start) {
        int i;
        for (i = start; i < s.length() && !HostnameChecker.isLabelSeparator(s.charAt(i)); ++i) {
        }
        return i;
    }

    private static boolean isRootLabel(String s) {
        return s.length() == 1 && HostnameChecker.isLabelSeparator(s.charAt(0));
    }

    private static boolean isLabelSeparator(char c) {
        return c == '.' || c == '\u3002' || c == '\uff0e' || c == '\uff61';
    }

    private static boolean startsWithACEPrefix(StringBuffer input) {
        boolean startsWithPrefix = true;
        if (input.length() < ACE_PREFIX_LENGTH) {
            return false;
        }
        for (int i = 0; i < ACE_PREFIX_LENGTH; ++i) {
            if (HostnameChecker.toASCIILower(input.charAt(i)) == ACE_PREFIX.charAt(i)) continue;
            startsWithPrefix = false;
        }
        return startsWithPrefix;
    }

    private static char toASCIILower(char ch) {
        if ('A' <= ch && ch <= 'Z') {
            return (char)(ch + 97 - 65);
        }
        return ch;
    }

    private static StringBuffer toASCIILower(StringBuffer input) {
        StringBuffer dest = new StringBuffer();
        for (int i = 0; i < input.length(); ++i) {
            dest.append(HostnameChecker.toASCIILower(input.charAt(i)));
        }
        return dest;
    }

    private static boolean isAllASCII(String input) {
        boolean isASCII = true;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c <= '\u007f') continue;
            isASCII = false;
            break;
        }
        return isASCII;
    }

    static {
        block2: {
            INSTANCE_TLS = new HostnameChecker(1);
            INSTANCE_LDAP = new HostnameChecker(2);
            ACE_PREFIX_LENGTH = ACE_PREFIX.length();
            namePrep = null;
            InputStream stream = null;
            try {
                String IDN_PROFILE = "uidna.spp";
                stream = System.getSecurityManager() != null ? AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                    @Override
                    public InputStream run() {
                        return StringPrep.class.getResourceAsStream("uidna.spp");
                    }
                }) : StringPrep.class.getResourceAsStream("uidna.spp");
                namePrep = new StringPrep(stream);
                stream.close();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }
}

