/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import jakarta.servlet.FilterChain;
import jakarta.servlet.GenericFilter;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.tomcat.websocket.server.UpgradeUtil;
import org.apache.tomcat.websocket.server.WsMappingResult;
import org.apache.tomcat.websocket.server.WsServerContainer;

public class WsFilter
extends GenericFilter {
    private static final long serialVersionUID = 1L;
    private transient WsServerContainer sc;

    public void init() throws ServletException {
        this.sc = (WsServerContainer)this.getServletContext().getAttribute("jakarta.websocket.server.ServerContainer");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (!this.sc.areEndpointsRegistered() || !UpgradeUtil.isWebSocketUpgradeRequest(servletRequest, servletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        String string = httpServletRequest.getPathInfo();
        String string2 = string == null ? httpServletRequest.getServletPath() : httpServletRequest.getServletPath() + string;
        WsMappingResult wsMappingResult = this.sc.findMapping(string2);
        if (wsMappingResult == null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        UpgradeUtil.doUpgrade(this.sc, httpServletRequest, httpServletResponse, wsMappingResult.getConfig(), wsMappingResult.getPathParams());
    }
}

