/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.filters;

import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.catalina.filters.FilterBase;

public abstract class RequestFilter
extends FilterBase {
    protected Pattern allow = null;
    protected Pattern deny = null;
    protected int denyStatus = 403;
    private static final String PLAIN_TEXT_MIME_TYPE = "text/plain";

    public String getAllow() {
        if (this.allow == null) {
            return null;
        }
        return this.allow.toString();
    }

    public void setAllow(String string) {
        this.allow = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public String getDeny() {
        if (this.deny == null) {
            return null;
        }
        return this.deny.toString();
    }

    public void setDeny(String string) {
        this.deny = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public int getDenyStatus() {
        return this.denyStatus;
    }

    public void setDenyStatus(int n) {
        this.denyStatus = n;
    }

    public abstract void doFilter(ServletRequest var1, ServletResponse var2, FilterChain var3) throws IOException, ServletException;

    @Override
    protected boolean isConfigProblemFatal() {
        return true;
    }

    protected void process(String string, ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (this.isAllowed(string)) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else if (servletResponse instanceof HttpServletResponse) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)sm.getString("requestFilter.deny", new Object[]{((HttpServletRequest)servletRequest).getRequestURI(), string}));
            }
            ((HttpServletResponse)servletResponse).sendError(this.denyStatus);
        } else {
            this.sendErrorWhenNotHttp(servletResponse);
        }
    }

    private boolean isAllowed(String string) {
        if (this.deny != null && this.deny.matcher(string).matches()) {
            return false;
        }
        if (this.allow != null && this.allow.matcher(string).matches()) {
            return true;
        }
        return this.deny != null && this.allow == null;
    }

    private void sendErrorWhenNotHttp(ServletResponse servletResponse) throws IOException {
        servletResponse.setContentType(PLAIN_TEXT_MIME_TYPE);
        servletResponse.getWriter().write(sm.getString("http.403"));
        servletResponse.getWriter().flush();
    }
}

