/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.users;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.catalina.Group;
import org.apache.catalina.Role;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.users.MemoryGroup;
import org.apache.catalina.users.MemoryGroupCreationFactory;
import org.apache.catalina.users.MemoryRole;
import org.apache.catalina.users.MemoryRoleCreationFactory;
import org.apache.catalina.users.MemoryUser;
import org.apache.catalina.users.MemoryUserCreationFactory;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.ObjectCreationFactory;
import org.apache.tomcat.util.file.ConfigFileLoader;
import org.apache.tomcat.util.res.StringManager;

public class MemoryUserDatabase
implements UserDatabase {
    private static final Log log = LogFactory.getLog(MemoryUserDatabase.class);
    protected final HashMap<String, Group> groups = new HashMap();
    protected final String id;
    protected String pathname = "conf/tomcat-users.xml";
    protected String pathnameOld = this.pathname + ".old";
    protected String pathnameNew = this.pathname + ".new";
    protected boolean readonly = true;
    protected final HashMap<String, Role> roles = new HashMap();
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.users");
    protected final HashMap<String, User> users = new HashMap();

    public MemoryUserDatabase() {
        this(null);
    }

    public MemoryUserDatabase(String string) {
        this.id = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Group> getGroups() {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            return this.groups.values().iterator();
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getPathname() {
        return this.pathname;
    }

    public void setPathname(String string) {
        this.pathname = string;
        this.pathnameOld = string + ".old";
        this.pathnameNew = string + ".new";
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<Role> getRoles() {
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            return this.roles.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<User> getUsers() {
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            return this.users.values().iterator();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        this.save();
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            HashMap<String, User> hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.clear();
                this.groups.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group createGroup(String string, String string2) {
        if (string == null || string.length() == 0) {
            String string3 = sm.getString("memoryUserDatabase.nullGroup");
            log.warn((Object)string3);
            throw new IllegalArgumentException(string3);
        }
        MemoryGroup memoryGroup = new MemoryGroup(this, string, string2);
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            this.groups.put(memoryGroup.getGroupname(), memoryGroup);
        }
        return memoryGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role createRole(String string, String string2) {
        if (string == null || string.length() == 0) {
            String string3 = sm.getString("memoryUserDatabase.nullRole");
            log.warn((Object)string3);
            throw new IllegalArgumentException(string3);
        }
        MemoryRole memoryRole = new MemoryRole(this, string, string2);
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            this.roles.put(memoryRole.getRolename(), memoryRole);
        }
        return memoryRole;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User createUser(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            String string4 = sm.getString("memoryUserDatabase.nullUser");
            log.warn((Object)string4);
            throw new IllegalArgumentException(string4);
        }
        MemoryUser memoryUser = new MemoryUser(this, string, string2, string3);
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            this.users.put(memoryUser.getUsername(), memoryUser);
        }
        return memoryUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Group findGroup(String string) {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            return this.groups.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Role findRole(String string) {
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            return this.roles.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User findUser(String string) {
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            return this.users.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws Exception {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            HashMap<String, User> hashMap2 = this.users;
            synchronized (hashMap2) {
                this.users.clear();
                this.groups.clear();
                this.roles.clear();
                String string = this.getPathname();
                InputStream inputStream = null;
                try {
                    inputStream = ConfigFileLoader.getInputStream((String)string);
                    Digester digester = new Digester();
                    try {
                        digester.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
                    }
                    catch (Exception exception) {
                        log.warn((Object)sm.getString("memoryUserDatabase.xmlFeatureEncoding"), (Throwable)exception);
                    }
                    digester.addFactoryCreate("tomcat-users/group", (ObjectCreationFactory)new MemoryGroupCreationFactory(this), true);
                    digester.addFactoryCreate("tomcat-users/role", (ObjectCreationFactory)new MemoryRoleCreationFactory(this), true);
                    digester.addFactoryCreate("tomcat-users/user", (ObjectCreationFactory)new MemoryUserCreationFactory(this), true);
                    digester.parse(inputStream);
                }
                catch (IOException iOException) {
                    log.error((Object)sm.getString("memoryUserDatabase.fileNotFound", new Object[]{string}));
                }
                finally {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeGroup(Group group) {
        HashMap<String, Group> hashMap = this.groups;
        synchronized (hashMap) {
            Iterator<User> iterator = this.getUsers();
            while (iterator.hasNext()) {
                User user = iterator.next();
                user.removeGroup(group);
            }
            this.groups.remove(group.getGroupname());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRole(Role role) {
        HashMap<String, Role> hashMap = this.roles;
        synchronized (hashMap) {
            Object object;
            Iterator<Group> iterator = this.getGroups();
            while (iterator.hasNext()) {
                object = iterator.next();
                object.removeRole(role);
            }
            object = this.getUsers();
            while (object.hasNext()) {
                User user = (User)object.next();
                user.removeRole(role);
            }
            this.roles.remove(role.getRolename());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeUser(User user) {
        HashMap<String, User> hashMap = this.users;
        synchronized (hashMap) {
            this.users.remove(user.getUsername());
        }
    }

    public boolean isWriteable() {
        File file;
        File file2 = new File(this.pathname);
        if (!file2.isAbsolute()) {
            file2 = new File(System.getProperty("catalina.base"), this.pathname);
        }
        return (file = file2.getParentFile()).exists() && file.isDirectory() && file.canWrite();
    }

    @Override
    public void save() throws Exception {
        Object object;
        Object object2;
        if (this.getReadonly()) {
            log.error((Object)sm.getString("memoryUserDatabase.readOnly"));
            return;
        }
        if (!this.isWriteable()) {
            log.warn((Object)sm.getString("memoryUserDatabase.notPersistable"));
            return;
        }
        File file = new File(this.pathnameNew);
        if (!file.isAbsolute()) {
            file = new File(System.getProperty("catalina.base"), this.pathnameNew);
        }
        PrintWriter printWriter = null;
        try {
            object2 = new FileOutputStream(file);
            object = new OutputStreamWriter((OutputStream)object2, "UTF-8");
            printWriter = new PrintWriter((Writer)object);
            printWriter.println("<?xml version='1.0' encoding='utf-8'?>");
            printWriter.println("<tomcat-users>");
            Iterator<Principal> iterator = null;
            iterator = this.getRoles();
            while (iterator.hasNext()) {
                printWriter.print("  ");
                printWriter.println(iterator.next());
            }
            iterator = this.getGroups();
            while (iterator.hasNext()) {
                printWriter.print("  ");
                printWriter.println(iterator.next());
            }
            iterator = this.getUsers();
            while (iterator.hasNext()) {
                printWriter.print("  ");
                printWriter.println(((MemoryUser)iterator.next()).toXml());
            }
            printWriter.println("</tomcat-users>");
            if (printWriter.checkError()) {
                printWriter.close();
                file.delete();
                throw new IOException(sm.getString("memoryUserDatabase.writeException", new Object[]{file.getAbsolutePath()}));
            }
            printWriter.close();
        }
        catch (IOException iOException) {
            if (printWriter != null) {
                printWriter.close();
            }
            file.delete();
            throw iOException;
        }
        object2 = new File(this.pathnameOld);
        if (!((File)object2).isAbsolute()) {
            object2 = new File(System.getProperty("catalina.base"), this.pathnameOld);
        }
        ((File)object2).delete();
        object = new File(this.pathname);
        if (!((File)object).isAbsolute()) {
            object = new File(System.getProperty("catalina.base"), this.pathname);
        }
        if (((File)object).exists()) {
            ((File)object2).delete();
            if (!((File)object).renameTo((File)object2)) {
                throw new IOException(sm.getString("memoryUserDatabase.renameOld", new Object[]{((File)object2).getAbsolutePath()}));
            }
        }
        if (!file.renameTo((File)object)) {
            if (((File)object2).exists()) {
                ((File)object2).renameTo((File)object);
            }
            throw new IOException(sm.getString("memoryUserDatabase.renameNew", new Object[]{((File)object).getAbsolutePath()}));
        }
        ((File)object2).delete();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("MemoryUserDatabase[id=");
        stringBuilder.append(this.id);
        stringBuilder.append(",pathname=");
        stringBuilder.append(this.pathname);
        stringBuilder.append(",groupCount=");
        stringBuilder.append(this.groups.size());
        stringBuilder.append(",roleCount=");
        stringBuilder.append(this.roles.size());
        stringBuilder.append(",userCount=");
        stringBuilder.append(this.users.size());
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    StringManager getStringManager() {
        return sm;
    }
}

