/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import org.apache.tomcat.util.buf.UriUtil;
import org.apache.tomcat.util.res.StringManager;

public class ConfigFileLoader {
    private static final StringManager sm = StringManager.getManager(ConfigFileLoader.class.getPackage().getName());
    private static final File CATALINA_BASE_FILE;
    private static final URI CATALINA_BASE_URI;

    private ConfigFileLoader() {
    }

    public static InputStream getInputStream(String string) throws IOException {
        Comparable<URI> comparable;
        if (!UriUtil.isAbsoluteURI(string)) {
            comparable = new File(string);
            if (!((File)comparable).isAbsolute()) {
                comparable = new File(CATALINA_BASE_FILE, string);
            }
            if (((File)comparable).isFile()) {
                return new FileInputStream((File)comparable);
            }
        }
        comparable = ConfigFileLoader.getURI(string);
        try {
            URL uRL = ((URI)comparable).toURL();
            return uRL.openConnection().getInputStream();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(sm.getString("configFileLoader.cannotObtainURL", string), illegalArgumentException);
        }
    }

    public static URI getURI(String string) {
        URI uRI = CATALINA_BASE_URI != null ? CATALINA_BASE_URI.resolve(string) : URI.create(string);
        return uRI;
    }

    static {
        String string = System.getProperty("catalina.base");
        if (string != null) {
            CATALINA_BASE_FILE = new File(string);
            CATALINA_BASE_URI = CATALINA_BASE_FILE.toURI();
        } else {
            CATALINA_BASE_FILE = null;
            CATALINA_BASE_URI = null;
        }
    }
}

