/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui;

import com.sun.tools.visualvm.core.datasource.DataSource;
import com.sun.tools.visualvm.core.snapshot.Snapshot;
import com.sun.tools.visualvm.core.ui.DataSourceView;
import com.sun.tools.visualvm.core.ui.components.DataViewComponent;
import java.util.HashMap;
import java.util.Map;

public abstract class DataSourceViewProvider<X extends DataSource> {
    private final Map<X, DataSourceView> viewsCache = new HashMap<X, DataSourceView>();

    protected abstract boolean supportsViewFor(X var1);

    protected abstract DataSourceView createView(X var1);

    protected boolean supportsSaveViewFor(X dataSource, Class<? extends Snapshot> snapshotClass) {
        return false;
    }

    protected void saveView(X dataSource, Snapshot snapshot) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataSourceView getCachedView(X dataSource) {
        Map<X, DataSourceView> map = this.viewsCache;
        synchronized (map) {
            return this.viewsCache.get(dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final DataSourceView getView(X dataSource) {
        Map<X, DataSourceView> map = this.viewsCache;
        synchronized (map) {
            DataSourceView view = this.getCachedView(dataSource);
            if (view == null) {
                view = this.createView(dataSource);
                if (view == null) {
                    throw new NullPointerException("DataSourceViewProvider provides null view: " + this);
                }
                view.setController(this);
                this.viewsCache.put(dataSource, view);
            }
            return view;
        }
    }

    void viewSaveView(X dataSource, Snapshot snapshot) {
        this.saveView(dataSource, snapshot);
    }

    void processCreatedComponent(DataSourceView view, DataViewComponent component) {
    }

    void viewWillBeAdded(DataSourceView view) {
    }

    void viewAdded(DataSourceView view) {
    }

    void viewRemoved(DataSourceView view) {
        this.viewsCache.remove(view.getDataSource());
    }
}

