/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.CellTipAware;
import org.netbeans.lib.profiler.ui.components.CellTipManager;
import org.netbeans.lib.profiler.ui.components.table.CustomSortableHeaderRenderer;
import org.netbeans.lib.profiler.ui.components.table.EnhancedTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.TableCellRendererPersistent;
import org.netbeans.lib.profiler.ui.components.tree.EnhancedTreeCellRenderer;
import org.netbeans.lib.profiler.ui.components.tree.TreeCellRendererPersistent;
import org.netbeans.lib.profiler.ui.components.treetable.AbstractTreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModel;
import org.netbeans.lib.profiler.ui.components.treetable.TreeTableModelAdapter;
import org.netbeans.modules.profiler.api.icons.Icons;

public class JTreeTable
extends JTable
implements CellTipAware,
MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    public static final boolean SORT_ORDER_DESC = false;
    public static final boolean SORT_ORDER_ASC = true;
    private static final boolean isGTK = UIUtils.isGTKLookAndFeel();
    protected JToolTip cellTip;
    protected Rectangle rendererRect;
    TreeTableCellRenderer tree;
    protected int lastColumn = -1;
    protected int lastRow = -1;
    private AbstractTreeTableModel treeTableModel;
    private CustomSortableHeaderRenderer headerRenderer;
    private ImageIcon sortAscIcon = Icons.getImageIcon((String)"GeneralIcons.SortAscending");
    private ImageIcon sortDescIcon = Icons.getImageIcon((String)"GeneralIcons.SortDescending");
    private JTableHeader tableHeader;
    private String internalFindString;
    private String userFindString;
    private TableHeaderListener headerListener;
    private TreeTableModelAdapter treeTableModelAdapter;
    private int lastFocusedColumn = -1;
    private int treeSignExtent;
    private int treeSignRightMargin;
    private int userFindColumn;

    public JTreeTable(AbstractTreeTableModel abstractTreeTableModel) {
        this.treeTableModel = abstractTreeTableModel;
        this.setBackground(UIUtils.getProfilerResultsBackground());
        int n = abstractTreeTableModel.getInitialSortingColumn();
        boolean bl = abstractTreeTableModel.getInitialSortingOrder();
        if (abstractTreeTableModel.supportsSorting()) {
            abstractTreeTableModel.sortByColumn(n, bl);
        }
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (JTreeTable.this.getSelectedRows().length > 0) {
                    JTreeTable.this.repaint();
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (JTreeTable.this.getSelectedRows().length > 0) {
                    JTreeTable.this.repaint();
                }
            }
        });
        this.tree = new TreeTableCellRenderer(abstractTreeTableModel);
        this.setTreeUIVariables();
        this.tree.setTransferHandler(new TransferHandler(){

            @Override
            public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
                JTreeTable.this.getTransferHandler().exportToClipboard(JTreeTable.this, clipboard, n);
            }
        });
        this.treeTableModelAdapter = new TreeTableModelAdapter(abstractTreeTableModel, this);
        this.setModel(this.treeTableModelAdapter);
        if (abstractTreeTableModel.supportsSorting()) {
            this.headerListener = new TableHeaderListener();
            this.headerRenderer = new CustomSortableHeaderRenderer(this.sortAscIcon, this.sortDescIcon);
            this.headerRenderer.setSortingColumn(n);
            this.headerRenderer.setSortingOrder(bl);
            this.updateTreeTableHeader();
        }
        this.getTableHeader().setReorderingAllowed(false);
        ListToTreeSelectionModelWrapper listToTreeSelectionModelWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(listToTreeSelectionModelWrapper);
        this.setSelectionModel(listToTreeSelectionModelWrapper.getListSelectionModel());
        this.setDefaultRenderer(TreeTableModel.class, this.tree);
        this.cellTip = this.createCellTip();
        this.cellTip.setBorder(BorderFactory.createLineBorder(this.getGridColor()));
        this.cellTip.setLayout(new BorderLayout());
        CellTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public JToolTip getCellTip() {
        return this.cellTip;
    }

    @Override
    public Point getCellTipLocation() {
        if (this.rendererRect == null) {
            return null;
        }
        return new Point(this.rendererRect.getLocation().x - 1, this.rendererRect.getLocation().y - 1);
    }

    public int getFindColumn() {
        return this.userFindColumn;
    }

    public boolean isFindColumnValid() {
        return this.userFindColumn >= 0 && this.userFindColumn < this.getColumnCount();
    }

    public void setFindParameters(String string, int n) {
        this.userFindString = string;
        this.userFindColumn = n;
        this.internalFindString = this.getInternalFindString(this.userFindString);
    }

    public String getFindString() {
        return this.userFindString;
    }

    public boolean isFindStringDefined() {
        return this.userFindString != null && this.userFindString.trim().length() > 0;
    }

    @Override
    public void setGridColor(Color color) {
        super.setGridColor(color);
        if (color == null || this.cellTip == null) {
            return;
        }
        this.cellTip.setBorder(BorderFactory.createLineBorder(color));
    }

    @Override
    public void setRowHeight(int n) {
        super.setRowHeight(n);
        if (this.tree != null && this.tree.getRowHeight() != n) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public void setSortingColumn(int n) {
        this.headerRenderer.setSortingColumn(n);
    }

    public int getSortingColumn() {
        return this.headerRenderer.getSortingColumn();
    }

    public void setSortingOrder(boolean bl) {
        this.headerRenderer.setSortingOrder(bl);
    }

    public boolean getSortingOrder() {
        return this.headerRenderer.getSortingOrder();
    }

    public JTree getTree() {
        return this.tree;
    }

    public void setTreeCellOffsetX(int n) {
        if (this.getTreeCellOffsetX() != n) {
            this.tree.setOffsetX(n);
            this.repaint(0, 0, this.getColumnModel().getColumn(0).getWidth(), this.getHeight());
        }
    }

    public int getTreeCellOffsetX() {
        return this.tree.getOffsetX();
    }

    public void setTreeCellRenderer(EnhancedTreeCellRenderer enhancedTreeCellRenderer) {
        this.tree.setTreeCellRenderer(enhancedTreeCellRenderer);
    }

    public EnhancedTreeCellRenderer getTreeCellRenderer() {
        return this.tree.getTreeCellRenderer();
    }

    public boolean canFindBePerformed() {
        return this.tree != null && this.treeTableModel.getRoot() != null && this.isFindColumnValid() && this.isFindStringDefined();
    }

    public boolean findFirst() {
        return this.findFirst(true);
    }

    public boolean findNext() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        CCTNode cCTNode = this.getSearchRoot();
        if (this.doFindNext(cCTNode, 0, true)) {
            return true;
        }
        CCTNode cCTNode2 = cCTNode.getParent();
        while (cCTNode2 != null) {
            if (this.doFindNext(cCTNode2, cCTNode2.getIndexOfChild((Object)cCTNode) + 1, true)) {
                return true;
            }
            cCTNode = cCTNode2;
            cCTNode2 = cCTNode.getParent();
        }
        return false;
    }

    public boolean findPrevious() {
        if (!this.canFindBePerformed()) {
            return false;
        }
        CCTNode cCTNode = this.getSearchRoot();
        if (!this.isAnyRowSelected()) {
            return this.findFirst();
        }
        CCTNode cCTNode2 = cCTNode.getParent();
        while (cCTNode2 != null) {
            if (this.doFindPrevious(cCTNode2, cCTNode2.getIndexOfChild((Object)cCTNode) - 1, true)) {
                return true;
            }
            cCTNode = cCTNode2;
            cCTNode2 = cCTNode.getParent();
        }
        return false;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.shouldBeForwarded(keyEvent)) {
            this.dispatchKeyboardEvent(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.shouldBeForwarded(keyEvent)) {
            this.dispatchKeyboardEvent(keyEvent);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.shouldBeForwarded(keyEvent)) {
            this.dispatchKeyboardEvent(keyEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.dispatchMouseEvent(mouseEvent);
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        this.dispatchMouseEvent(mouseEvent);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.contains(mouseEvent.getPoint()) && this.cellTip.isShowing()) {
            return;
        }
        CellTipManager.sharedInstance().setEnabled(false);
        this.lastRow = -1;
        this.lastColumn = -1;
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        Component component;
        Object object;
        boolean bl;
        int n = this.rowAtPoint(mouseEvent.getPoint());
        int n2 = this.columnAtPoint(mouseEvent.getPoint());
        boolean bl2 = bl = this.getColumnClass(n2) == TreeTableModel.class;
        if (!bl && n == this.lastRow && n2 == this.lastColumn) {
            return;
        }
        this.lastRow = n;
        this.lastColumn = n2;
        if (n < 0 || n2 < 0) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        Rectangle rectangle = this.getCellRect(n, n2, false);
        if (bl) {
            object = this.tree.getTreeCellRenderer();
            component = ((TreeCellRendererPersistent)object).getTreeCellRendererComponentPersistent(this.tree, this.treeTableModel.getValueAt(this.tree.getPathForRow(n).getLastPathComponent(), 0), false, this.tree.isExpanded(n), this.treeTableModel.isLeaf(this.tree.getPathForRow(n).getLastPathComponent()), n, false);
            if (component == null) {
                CellTipManager.sharedInstance().setEnabled(false);
                return;
            }
            Point point = this.tree.getPathBounds(this.tree.getPathForRow(n)).getLocation();
            this.rendererRect = new Rectangle(rectangle.x + point.x - this.tree.getOffsetX(), point.y, component.getPreferredSize().width, component.getPreferredSize().height + 2);
        } else {
            object = this.getCellRenderer(n, n2);
            if (!(object instanceof TableCellRendererPersistent)) {
                return;
            }
            component = ((TableCellRendererPersistent)object).getTableCellRendererComponentPersistent(this, this.getValueAt(n, n2), false, false, n, n2);
            if (component == null) {
                CellTipManager.sharedInstance().setEnabled(false);
                return;
            }
            int n3 = ((EnhancedTableCellRenderer)component).getHorizontalAlignment();
            this.rendererRect = n3 == 11 || n3 == 4 ? new Rectangle(rectangle.x + rectangle.width - component.getPreferredSize().width, rectangle.y, component.getPreferredSize().width, component.getPreferredSize().height) : new Rectangle(rectangle.x, rectangle.y, component.getPreferredSize().width, component.getPreferredSize().height);
        }
        if (bl && !this.rendererRect.contains(mouseEvent.getPoint())) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        if (this.rendererRect.x >= rectangle.x && this.rendererRect.x + this.rendererRect.width <= rectangle.x + rectangle.width) {
            CellTipManager.sharedInstance().setEnabled(false);
            return;
        }
        while (this.cellTip.getComponentCount() > 0) {
            this.cellTip.remove(0);
        }
        this.cellTip.add(component, "Center");
        this.cellTip.setPreferredSize(new Dimension(this.rendererRect.width + 2, this.getRowHeight(n) + 2));
        CellTipManager.sharedInstance().setEnabled(true);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.dispatchMouseEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.dispatchMouseEvent(mouseEvent);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        this.mouseMoved(mouseWheelEvent);
        CellTipManager.sharedInstance().setEnabled(false);
    }

    @Override
    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent instanceof MouseWheelEvent) {
            Container container = this.getParent();
            if (container == null || !(container instanceof JViewport)) {
                container = this;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(this, (MouseWheelEvent)mouseEvent, container);
            container.dispatchEvent((MouseWheelEvent)mouseEvent2);
        } else {
            super.processMouseEvent(mouseEvent);
        }
    }

    public void resetTreeCellOffsetX() {
        this.setTreeCellOffsetX(0);
    }

    public CCTNode[] getPathToRoot(CCTNode cCTNode) {
        return this.treeTableModel.getPathToRoot(cCTNode);
    }

    public void selectNode(CCTNode cCTNode, boolean bl) {
        TreePath treePath = new TreePath(this.treeTableModel.getPathToRoot(cCTNode));
        this.getTree().setSelectionPath(treePath);
        if (bl) {
            this.scrollRectToVisible(this.getCellRect(this.getSelectedRow(), 0, true));
        }
    }

    public void selectRowByContents(String string, int n, boolean bl) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getValueAt(i, n).toString().equals(string)) continue;
            this.getSelectionModel().setSelectionInterval(i, i);
            if (bl) {
                this.scrollRectToVisible(this.getCellRect(i, n, true));
            }
            return;
        }
        this.getSelectionModel().clearSelection();
    }

    public boolean silentlyFindFirst() {
        return this.findFirst(false);
    }

    public void updateTreeTable() {
        this.treeTableModelAdapter.updateTreeTable();
    }

    public void changeRoot(CCTNode cCTNode) {
        this.treeTableModelAdapter.changeRoot(cCTNode);
    }

    public void setup(List list, TreePath treePath) {
        this.treeTableModelAdapter.setup(list, treePath);
    }

    public List getExpandedPaths() {
        return this.treeTableModelAdapter.getExpandedPaths();
    }

    public void updateTreeTableHeader() {
        TableColumnModel tableColumnModel = this.getColumnModel();
        int n = tableColumnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            tableColumnModel.getColumn(i).setHeaderRenderer(this.headerRenderer);
        }
        if (this.tableHeader != this.getTableHeader()) {
            if (this.tableHeader != null) {
                this.tableHeader.removeMouseListener(this.headerListener);
            }
            if (this.tableHeader != null) {
                this.tableHeader.removeMouseMotionListener(this.headerListener);
            }
            this.tableHeader = this.getTableHeader();
            this.tableHeader.addMouseListener(this.headerListener);
            this.tableHeader.addMouseMotionListener(this.headerListener);
            this.updateTreeTable();
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
            this.setTreeUIVariables();
        }
    }

    protected JToolTip createCellTip() {
        return new JToolTip();
    }

    private boolean isAnyRowSelected() {
        TreePath treePath = this.tree.getSelectionPath();
        return treePath != null && treePath.getPathCount() > 0;
    }

    private String getInternalFindString(String string) {
        if (string == null) {
            return null;
        }
        return string.toLowerCase();
    }

    private CCTNode getSearchRoot() {
        if (!this.isAnyRowSelected()) {
            return (CCTNode)this.treeTableModel.getRoot();
        }
        return (CCTNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    private void setTreeUIVariables() {
        if (this.tree.getUI() instanceof BasicTreeUI) {
            BasicTreeUI basicTreeUI = (BasicTreeUI)this.tree.getUI();
            this.treeSignExtent = basicTreeUI.getExpandedIcon().getIconWidth() / 2;
            this.treeSignRightMargin = basicTreeUI.getRightChildIndent();
        }
    }

    private void dispatchKeyboardEvent(KeyEvent keyEvent) {
        int n;
        this.tree.customProcessKeyEvent(keyEvent);
        if (!JTreeTable.isModifierKey(keyEvent) && (n = this.getSelectedRow()) > -1) {
            this.scrollRectToVisible(this.getCellRect(n, 0, false));
        }
    }

    private static boolean isModifierKey(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 16: 
            case 17: 
            case 18: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    private void dispatchMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent != null) {
            int n = this.rowAtPoint(mouseEvent.getPoint());
            int n2 = this.columnAtPoint(mouseEvent.getPoint());
            Rectangle rectangle = this.getCellRect(n, n2, true);
            Rectangle rectangle2 = this.tree.getRowBounds(n);
            if (rectangle2 != null) {
                int n3;
                Class<?> clazz = this.getColumnClass(n2);
                if (clazz == TreeTableModel.class) {
                    n3 = mouseEvent.getX() - rectangle.x;
                    if ((n3 += this.tree.getOffsetX()) < rectangle2.x - this.treeSignExtent - this.treeSignRightMargin || n3 > rectangle2.x + this.treeSignExtent - this.treeSignRightMargin + 1) {
                        n3 = rectangle2.x + rectangle2.width - 1;
                    }
                } else {
                    n3 = rectangle2.x + rectangle2.width - 1;
                }
                int n4 = 2 - mouseEvent.getClickCount() % 2;
                MouseEvent mouseEvent2 = new MouseEvent(this.tree, mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), n3, mouseEvent.getY(), n4, mouseEvent.isPopupTrigger());
                this.tree.dispatchEvent(mouseEvent2);
            }
        }
    }

    private boolean doFindNext(CCTNode cCTNode, int n, boolean bl) {
        int n2 = cCTNode.getNChildren();
        while (n < n2) {
            CCTNode cCTNode2 = cCTNode.getChild(n);
            if (this.matchesFindCriterion(cCTNode2)) {
                return this.selectFoundNode(cCTNode2, bl);
            }
            if (cCTNode2.getNChildren() > 0 && this.doFindNext(cCTNode2, 0, bl)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean doFindPrevious(CCTNode cCTNode, int n, boolean bl) {
        while (n >= 0) {
            CCTNode cCTNode2 = cCTNode.getChild(n);
            if (this.doFindPrevious(cCTNode2, cCTNode2.getNChildren() - 1, bl)) {
                return true;
            }
            --n;
        }
        if (this.matchesFindCriterion(cCTNode)) {
            return this.selectFoundNode(cCTNode, bl);
        }
        return false;
    }

    private boolean findFirst(boolean bl) {
        if (!this.canFindBePerformed()) {
            return false;
        }
        CCTNode cCTNode = (CCTNode)this.treeTableModel.getRoot();
        if (this.matchesFindCriterion(cCTNode)) {
            return this.selectFoundNode(cCTNode, bl);
        }
        return this.doFindNext(cCTNode, 0, bl);
    }

    private boolean matchesFindCriterion(Object object) {
        Object object2 = this.treeTableModel.getValueAt(object, 0);
        if (object2 == null) {
            return false;
        }
        String string = object2.toString();
        if (string == null) {
            return false;
        }
        return string.toLowerCase().indexOf(this.internalFindString) != -1;
    }

    private boolean selectFoundNode(CCTNode cCTNode, boolean bl) {
        Rectangle rectangle;
        TreePath treePath = new TreePath(this.treeTableModel.getPathToRoot(cCTNode));
        this.tree.expandPath(treePath);
        this.tree.setSelectionPath(treePath);
        if (bl) {
            this.requestFocusInWindow();
        }
        if ((rectangle = this.tree.getPathBounds(treePath)) != null) {
            this.scrollRectToVisible(rectangle);
            return true;
        }
        return false;
    }

    private boolean shouldBeForwarded(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 33: 
            case 34: {
                return false;
            }
        }
        return true;
    }

    private class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        protected int currentlyPaintedRow;
        private Color darkerUnselectedBackground;
        private Color unselectedBackground;
        private Color unselectedForeground;
        private EnhancedTreeCellRenderer treeCellRenderer;
        private int offsetX;

        public TreeTableCellRenderer(TreeModel treeModel) {
            super(treeModel);
            this.offsetX = 0;
            this.setOpaque(false);
            this.treeCellRenderer = new EnhancedTreeCellRenderer();
            this.setCellRenderer(this.treeCellRenderer);
            this.unselectedBackground = UIUtils.getProfilerResultsBackground();
            this.darkerUnselectedBackground = UIUtils.getDarker(this.unselectedBackground);
        }

        @Override
        public void validate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public Insets getInsets() {
            return ZERO_INSETS;
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, 0, n3, JTreeTable.this.getHeight());
        }

        public void setOffsetX(int n) {
            this.offsetX = n;
        }

        public int getOffsetX() {
            return this.offsetX;
        }

        @Override
        public void setRowHeight(int n) {
            if (n > 0) {
                super.setRowHeight(n);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != n) {
                    JTreeTable.this.setRowHeight(this.getRowHeight());
                }
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setRowForeground(jTable.isFocusOwner() ? jTable.getSelectionForeground() : UIUtils.getUnfocusedSelectionForeground());
                this.setRowBackground(jTable.isFocusOwner() ? jTable.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground());
            } else if ((n & 1) == 0) {
                this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                this.setRowBackground(this.darkerUnselectedBackground != null ? this.darkerUnselectedBackground : UIUtils.getDarker(jTable.getBackground()));
            } else {
                this.setRowForeground(this.unselectedForeground != null ? this.unselectedForeground : jTable.getForeground());
                this.setRowBackground(this.unselectedBackground != null ? this.unselectedBackground : jTable.getBackground());
            }
            this.currentlyPaintedRow = n;
            return this;
        }

        public void setTreeCellRenderer(EnhancedTreeCellRenderer enhancedTreeCellRenderer) {
            this.treeCellRenderer = enhancedTreeCellRenderer;
            this.setCellRenderer(this.treeCellRenderer);
        }

        public EnhancedTreeCellRenderer getTreeCellRenderer() {
            return this.treeCellRenderer;
        }

        public void customProcessKeyEvent(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent);
        }

        @Override
        public void paint(Graphics graphics) {
            boolean bl = this.isRowSelected(this.currentlyPaintedRow);
            boolean bl2 = JTreeTable.this.isFocusOwner();
            int n = this.getRowHeight();
            graphics.translate(-this.offsetX, -this.currentlyPaintedRow * n);
            if (isGTK) {
                super.paint(graphics);
                Rectangle rectangle = this.getRowBounds(this.currentlyPaintedRow);
                int n2 = rectangle.x + rectangle.width;
                graphics.setColor(this.getRowColor(this.currentlyPaintedRow, bl, bl2));
                graphics.fillRect(n2, this.currentlyPaintedRow * n, this.getWidth() + this.offsetX - n2, n);
            } else {
                int n3 = bl ? 0 : this.getRowBounds((int)this.currentlyPaintedRow).x;
                graphics.setColor(this.getRowColor(this.currentlyPaintedRow, bl, bl2));
                graphics.fillRect(n3, this.currentlyPaintedRow * n, this.getWidth() + this.offsetX, n);
                super.paint(graphics);
            }
        }

        protected void setRowBackground(Color color) {
            this.treeCellRenderer.setBackground(color);
            this.treeCellRenderer.setBackgroundNonSelectionColor(color);
            this.treeCellRenderer.setBackgroundSelectionColor(color);
        }

        protected void setRowForeground(Color color) {
            this.treeCellRenderer.setForeground(color);
            this.treeCellRenderer.setTextNonSelectionColor(color);
            this.treeCellRenderer.setTextSelectionColor(color);
        }

        private Color getRowColor(int n, boolean bl, boolean bl2) {
            if (bl) {
                return bl2 ? JTreeTable.this.getSelectionBackground() : UIUtils.getUnfocusedSelectionBackground();
            }
            Color color = UIUtils.getProfilerResultsBackground();
            if ((n & 1) == 0) {
                return UIUtils.getDarker(color);
            }
            return color;
        }
    }

    private class TableHeaderListener
    extends MouseAdapter
    implements MouseMotionListener {
        private TableHeaderListener() {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                int n;
                int n2 = JTreeTable.this.tableHeader.columnAtPoint(mouseEvent.getPoint());
                if (n2 == (n = JTreeTable.this.headerRenderer.getSortingColumn())) {
                    JTreeTable.this.headerRenderer.reverseSortingOrder();
                } else {
                    JTreeTable.this.headerRenderer.setSortingColumn(n2);
                    if (JTreeTable.this.treeTableModel.getInitialSorting(n2)) {
                        JTreeTable.this.headerRenderer.setSortingOrder(true);
                    } else {
                        JTreeTable.this.headerRenderer.setSortingOrder(false);
                    }
                }
                JTreeTable.this.tableHeader.repaint();
                JTreeTable.this.treeTableModel.sortByColumn(n2, JTreeTable.this.headerRenderer.getSortingOrder());
                JTreeTable.this.updateTreeTable();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n = JTreeTable.this.tableHeader.columnAtPoint(mouseEvent.getPoint());
            if (n != JTreeTable.this.lastFocusedColumn) {
                if (n != -1) {
                    JTreeTable.this.tableHeader.setToolTipText(JTreeTable.this.treeTableModel.getColumnToolTipText(n));
                } else {
                    JTreeTable.this.tableHeader.setToolTipText(null);
                }
                JTreeTable.this.lastFocusedColumn = n;
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16 && JTreeTable.this.tableHeader.getResizingColumn() == null) {
                JTreeTable.this.headerRenderer.setPressedColumn(JTreeTable.this.tableHeader.columnAtPoint(mouseEvent.getPoint()));
                JTreeTable.this.tableHeader.repaint();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16) {
                JTreeTable.this.headerRenderer.setPressedColumn(-1);
                JTreeTable.this.tableHeader.repaint();
            }
        }
    }

    class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        protected boolean updatingListSelectionModel;

        public ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        @Override
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        protected ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int n = this.listSelectionModel.getMinSelectionIndex();
                    int n2 = this.listSelectionModel.getMaxSelectionIndex();
                    this.clearSelection();
                    if (n != -1 && n2 != -1) {
                        for (int i = n; i <= n2; ++i) {
                            TreePath treePath;
                            if (!this.listSelectionModel.isSelectedIndex(i) || (treePath = JTreeTable.this.tree.getPathForRow(i)) == null) continue;
                            this.addSelectionPath(treePath);
                        }
                    }
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (JTreeTable.this.treeTableModelAdapter.isFiringChange()) {
                    return;
                }
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }
}

