/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.annotation.HandlesTypes;
import javax.websocket.ContainerProvider;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.server.ServerApplicationConfig;
import javax.websocket.server.ServerEndpoint;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.websocket.server.WsContextListener;
import org.apache.tomcat.websocket.server.WsServerContainer;
import org.apache.tomcat.websocket.server.WsSessionListener;

@HandlesTypes(value={ServerEndpoint.class, ServerApplicationConfig.class, Endpoint.class})
public class WsSci
implements ServletContainerInitializer {
    private static boolean logMessageWritten = false;
    private final Log log = LogFactory.getLog(WsSci.class);
    private static final StringManager sm = StringManager.getManager(WsSci.class);

    public void onStartup(Set<Class<?>> set, ServletContext servletContext) throws ServletException {
        Object object;
        Object object3;
        if (!WsSci.isJava7OrLater()) {
            if (!logMessageWritten) {
                logMessageWritten = true;
                this.log.info((Object)sm.getString("sci.noWebSocketSupport"));
            }
            return;
        }
        WsServerContainer wsServerContainer = WsSci.init(servletContext, true);
        if (set == null || set.size() == 0) {
            return;
        }
        HashSet<ServerApplicationConfig> hashSet = new HashSet<ServerApplicationConfig>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet hashSet3 = new HashSet();
        try {
            object3 = ContainerProvider.class.getName();
            object3 = ((String)object3).substring(0, ((String)object3).lastIndexOf(46) + 1);
            for (Class<?> iterator : set) {
                JreCompat jreCompat = JreCompat.getInstance();
                int n = iterator.getModifiers();
                if (!Modifier.isPublic(n) || Modifier.isAbstract(n) || Modifier.isInterface(n) || !jreCompat.isExported(iterator) || iterator.getName().startsWith((String)object3)) continue;
                if (ServerApplicationConfig.class.isAssignableFrom(iterator)) {
                    hashSet.add((ServerApplicationConfig)iterator.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                if (Endpoint.class.isAssignableFrom(iterator)) {
                    object = iterator;
                    hashSet2.add(object);
                }
                if (!iterator.isAnnotationPresent(ServerEndpoint.class)) continue;
                hashSet3.add(iterator);
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ServletException((Throwable)instantiationException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ServletException((Throwable)illegalArgumentException);
        }
        catch (SecurityException securityException) {
            throw new ServletException((Throwable)securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ServletException((Throwable)illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ServletException((Throwable)invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ServletException((Throwable)noSuchMethodException);
        }
        object3 = new HashSet();
        HashSet hashSet4 = new HashSet();
        if (hashSet.isEmpty()) {
            hashSet4.addAll(hashSet3);
        } else {
            for (ServerApplicationConfig serverApplicationConfig : hashSet) {
                Set set2 = serverApplicationConfig.getEndpointConfigs(hashSet2);
                if (set2 != null) {
                    object3.addAll(set2);
                }
                if ((object = serverApplicationConfig.getAnnotatedEndpointClasses(hashSet3)) == null) continue;
                hashSet4.addAll(object);
            }
        }
        try {
            Iterator iterator = object3.iterator();
            while (iterator.hasNext()) {
                ServerEndpointConfig serverEndpointConfig = (ServerEndpointConfig)iterator.next();
                wsServerContainer.addEndpoint(serverEndpointConfig);
            }
            Iterator iterator2 = hashSet4.iterator();
            while (iterator2.hasNext()) {
                Class clazz = (Class)iterator2.next();
                wsServerContainer.addEndpoint(clazz, true);
            }
        }
        catch (DeploymentException deploymentException) {
            throw new ServletException((Throwable)deploymentException);
        }
    }

    static WsServerContainer init(ServletContext servletContext, boolean bl) {
        WsServerContainer wsServerContainer = new WsServerContainer(servletContext);
        servletContext.setAttribute("javax.websocket.server.ServerContainer", (Object)wsServerContainer);
        servletContext.addListener((EventListener)((Object)new WsSessionListener(wsServerContainer)));
        if (bl) {
            servletContext.addListener((EventListener)((Object)new WsContextListener()));
        }
        return wsServerContainer;
    }

    private static boolean isJava7OrLater() {
        try {
            Class.forName("java.nio.channels.AsynchronousSocketChannel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
        return true;
    }
}

