/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.ProxySelector;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.security.AllPermission;
import java.security.KeyStore;
import java.security.Policy;
import java.security.Security;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import javax.jnlp.ServiceManager;
import javax.naming.ConfigurationException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.text.html.parser.ParserDelegator;
import net.sourceforge.jnlp.DefaultLaunchHandler;
import net.sourceforge.jnlp.GuiLaunchHandler;
import net.sourceforge.jnlp.LaunchHandler;
import net.sourceforge.jnlp.browser.BrowserAwareProxySelector;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.DefaultDownloadIndicator;
import net.sourceforge.jnlp.cache.DownloadIndicator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.runtime.ApplicationInstance;
import net.sourceforge.jnlp.runtime.CachedJarFileCallback;
import net.sourceforge.jnlp.runtime.JNLPPolicy;
import net.sourceforge.jnlp.runtime.JNLPSecurityManager;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.security.JNLPAuthenticator;
import net.sourceforge.jnlp.security.KeyStores;
import net.sourceforge.jnlp.security.SecurityDialogMessageHandler;
import net.sourceforge.jnlp.security.SecurityUtil;
import net.sourceforge.jnlp.services.XServiceManagerStub;
import net.sourceforge.jnlp.util.BasicExceptionDialog;
import net.sourceforge.jnlp.util.FileUtils;
import net.sourceforge.jnlp.util.logging.JavaConsole;
import net.sourceforge.jnlp.util.logging.LogConfig;
import net.sourceforge.jnlp.util.logging.OutputController;
import sun.net.www.protocol.jar.URLJarFile;

public class JNLPRuntime {
    private static String history = "";
    private static JNLPSecurityManager security;
    private static JNLPPolicy policy;
    private static SecurityDialogMessageHandler securityDialogMessageHandler;
    private static LaunchHandler handler;
    private static DownloadIndicator indicator;
    private static UpdatePolicy updatePolicy;
    private static boolean initialized;
    private static boolean headless;
    private static boolean headlessChecked;
    private static boolean verify;
    private static boolean securityEnabled;
    private static boolean debug;
    private static Boolean pluginDebug;
    public static Object initMutex;
    private static boolean isWebstartApplication;
    private static boolean forksAllowed;
    private static boolean trustAll;
    private static boolean html;
    private static boolean trustNone;
    private static boolean allowRedirect;
    private static boolean offlineForced;
    private static Boolean onlineDetected;
    private static long startupTrackerMoment;
    private static boolean ignoreHeaders;
    private static List<String> initialArguments;
    private static FileLock fileLock;

    public static boolean isInitialized() {
        return initialized;
    }

    public static void initialize(boolean isApplication) throws IllegalStateException {
        JNLPRuntime.checkInitialized();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            OutputController.getLogger().log("Unable to set system look and feel");
        }
        if (JavaConsole.canShowOnStartup(isApplication)) {
            JavaConsole.getConsole().showConsoleLater();
        }
        if (JNLPRuntime.getConfiguration().getLoadingException() != null) {
            if (JNLPRuntime.getConfiguration().getLoadingException() instanceof ConfigurationException) {
                throw new RuntimeException(JNLPRuntime.getConfiguration().getLoadingException());
            }
            OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("RConfigurationError") + ": " + JNLPRuntime.getConfiguration().getLoadingException().getMessage());
        }
        isWebstartApplication = isApplication;
        System.setProperty("javawebstart.version", "javaws-" + System.getProperty("java.version"));
        if (!JNLPRuntime.isHeadless() && indicator == null) {
            indicator = new DefaultDownloadIndicator();
        }
        if (handler == null) {
            handler = JNLPRuntime.isHeadless() ? new DefaultLaunchHandler(OutputController.getLogger()) : new GuiLaunchHandler(OutputController.getLogger());
        }
        ServiceManager.setServiceManagerStub(new XServiceManagerStub());
        policy = new JNLPPolicy();
        security = new JNLPSecurityManager();
        JNLPRuntime.doMainAppContextHacks();
        if (securityEnabled) {
            Policy.setPolicy(policy);
            System.setSecurityManager(security);
        }
        securityDialogMessageHandler = JNLPRuntime.startSecurityThreads();
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            KeyStore ks = KeyStores.getKeyStore(KeyStores.Level.USER, KeyStores.Type.CLIENT_CERTS).getKs();
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            SecurityUtil.initKeyManagerFactory(kmf, ks);
            TrustManager[] trust = new TrustManager[]{JNLPRuntime.getSSLSocketTrustManager()};
            context.init(kmf.getKeyManagers(), trust, null);
            SSLSocketFactory sslSocketFactory = context.getSocketFactory();
            HttpsURLConnection.setDefaultSSLSocketFactory(sslSocketFactory);
        }
        catch (Exception e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to set SSLSocketfactory (may _prevent_ access to sites that should be trusted)! Continuing anyway...");
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        Authenticator.setDefault(new JNLPAuthenticator());
        BrowserAwareProxySelector proxySelector = new BrowserAwareProxySelector(JNLPRuntime.getConfiguration());
        proxySelector.initialize();
        ProxySelector.setDefault(proxySelector);
        Security.setProperty("package.access", Security.getProperty("package.access") + ",net.sourceforge.jnlp");
        URLJarFile.setCallBack(CachedJarFileCallback.getInstance());
        initialized = true;
    }

    public static void reloadPolicy() {
        policy.refresh();
    }

    private static TrustManager getSSLSocketTrustManager() throws ClassNotFoundException, IllegalAccessException, InstantiationException, InvocationTargetException {
        try {
            Class<?> trustManagerClass;
            if (System.getProperty("java.version").startsWith("1.6")) {
                try {
                    trustManagerClass = Class.forName("net.sourceforge.jnlp.security.VariableX509TrustManagerJDK6");
                }
                catch (ClassNotFoundException cnfe) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to find class net.sourceforge.jnlp.security.VariableX509TrustManagerJDK6");
                    return null;
                }
            }
            try {
                trustManagerClass = Class.forName("net.sourceforge.jnlp.security.VariableX509TrustManagerJDK7");
            }
            catch (ClassNotFoundException cnfe) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to find class net.sourceforge.jnlp.security.VariableX509TrustManagerJDK7");
                return null;
            }
            Constructor<?>[] tmCtors = trustManagerClass.getDeclaredConstructors();
            Constructor<?> tmCtor = tmCtors[0];
            for (Constructor<?> ctor : tmCtors) {
                if (tmCtor.getGenericParameterTypes().length != 0) continue;
                tmCtor = ctor;
                break;
            }
            return (TrustManager)tmCtor.newInstance(new Object[0]);
        }
        catch (RuntimeException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Unable to load JDK-specific TrustManager. Was this version of IcedTea-Web compiled with JDK 6 or 7?");
            OutputController.getLogger().log(e);
            throw e;
        }
    }

    private static SecurityDialogMessageHandler startSecurityThreads() {
        ThreadGroup securityThreadGroup = new ThreadGroup("NetxSecurityThreadGroup");
        SecurityDialogMessageHandler runner = new SecurityDialogMessageHandler();
        Thread securityThread = new Thread(securityThreadGroup, runner, "NetxSecurityThread");
        securityThread.setDaemon(true);
        securityThread.start();
        return runner;
    }

    private static void doMainAppContextHacks() {
        new ParserDelegator();
    }

    public static void setOfflineForced(boolean b) {
        offlineForced = b;
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Forcing of offline set to: " + offlineForced);
    }

    public static boolean isOfflineForced() {
        return offlineForced;
    }

    public static void setOnlineDetected(boolean online) {
        onlineDetected = online;
        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Detected online set to: " + onlineDetected);
    }

    public static boolean isOnlineDetected() {
        if (onlineDetected == null) {
            return true;
        }
        return onlineDetected;
    }

    public static boolean isOnline() {
        if (JNLPRuntime.isOfflineForced()) {
            return false;
        }
        return JNLPRuntime.isOnlineDetected();
    }

    public static void detectOnline(URL location) {
        if (onlineDetected != null) {
            return;
        }
        JNLPRuntime.setOnlineDetected(JNLPRuntime.isConnectable(location));
    }

    public static boolean isConnectable(URL location) {
        if (location.getProtocol().equals("file")) {
            return true;
        }
        try {
            InetAddress.getByName(location.getHost());
        }
        catch (UnknownHostException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "The host of " + location.toExternalForm() + " file seems down, or you are simply offline.");
            return false;
        }
        return true;
    }

    public static DeploymentConfiguration getConfiguration() {
        return DeploymentConfigurationHolder.INSTANCE;
    }

    public static boolean isWebstartApplication() {
        return isWebstartApplication;
    }

    public static boolean isHeadless() {
        if (!headless && !headlessChecked) {
            JNLPRuntime.checkHeadless();
        }
        return headless;
    }

    public static boolean isVerifying() {
        return verify;
    }

    public static void setHeadless(boolean enabled) {
        JNLPRuntime.checkInitialized();
        headless = enabled;
    }

    public static void setAllowRedirect(boolean enabled) {
        JNLPRuntime.checkInitialized();
        allowRedirect = enabled;
    }

    public static boolean isAllowRedirect() {
        return allowRedirect;
    }

    public static void setVerify(boolean enabled) {
        JNLPRuntime.checkInitialized();
        verify = enabled;
    }

    public static boolean isSecurityEnabled() {
        return securityEnabled;
    }

    public static void setSecurityEnabled(boolean enabled) {
        JNLPRuntime.checkInitialized();
        securityEnabled = enabled;
    }

    public static SecurityDialogMessageHandler getSecurityDialogHandler() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AllPermission());
        }
        return securityDialogMessageHandler;
    }

    public static void setExitClass(Class<?> exitClass) {
        JNLPRuntime.checkExitClass();
        security.setExitClass(exitClass);
    }

    public static void disableExit() {
        security.disableExit();
    }

    public static ApplicationInstance getApplication() {
        return security.getApplication();
    }

    public static boolean isDebug() {
        return JNLPRuntime.isSetDebug() || JNLPRuntime.isPluginDebug() || LogConfig.getLogConfig().isEnableLogging();
    }

    public static boolean isSetDebug() {
        return debug;
    }

    public static void setDebug(boolean enabled) {
        JNLPRuntime.checkExitClass();
        debug = enabled;
    }

    public static void setDefaultUpdatePolicy(UpdatePolicy policy) {
        JNLPRuntime.checkExitClass();
        updatePolicy = policy;
    }

    public static UpdatePolicy getDefaultUpdatePolicy() {
        return updatePolicy;
    }

    public static void setDefaultLaunchHandler(LaunchHandler handler) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.handler = handler;
    }

    public static LaunchHandler getDefaultLaunchHandler() {
        return handler;
    }

    public static void setDefaultDownloadIndicator(DownloadIndicator indicator) {
        JNLPRuntime.checkExitClass();
        JNLPRuntime.indicator = indicator;
    }

    public static DownloadIndicator getDefaultDownloadIndicator() {
        return indicator;
    }

    public static String getLocalisedTimeStamp(Date timestamp) {
        return DateFormat.getInstance().format(timestamp);
    }

    public static boolean getForksAllowed() {
        return forksAllowed;
    }

    public static void setForksAllowed(boolean value) {
        JNLPRuntime.checkInitialized();
        forksAllowed = value;
    }

    private static void checkInitialized() {
        if (initialized) {
            throw new IllegalStateException("JNLPRuntime already initialized.");
        }
    }

    private static void checkExitClass() {
        if (securityEnabled && initialized && !security.isExitClass()) {
            throw new IllegalStateException("Caller is not the exit class");
        }
    }

    private static void checkHeadless() {
        block9: {
            try {
                if ("true".equalsIgnoreCase(System.getProperty("java.awt.headless"))) {
                    headless = true;
                }
                if (headless) break block9;
                boolean noCheck = Boolean.valueOf(JNLPRuntime.getConfiguration().getProperty("deployment.headless.ignore"));
                if (noCheck) {
                    headless = false;
                    OutputController.getLogger().log("deployment.headless.ignore set to " + noCheck + ". Avoding headless check.");
                    break block9;
                }
                try {
                    if (GraphicsEnvironment.isHeadless()) {
                        throw new HeadlessException();
                    }
                }
                catch (HeadlessException ex) {
                    headless = true;
                    OutputController.getLogger().log(ex);
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("HEADLESS_MISSCONFIGURED"));
                }
            }
            catch (SecurityException securityException) {
            }
            finally {
                headlessChecked = true;
            }
        }
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name");
        return os != null && os.startsWith("Windows");
    }

    @Deprecated
    public static boolean isUnix() {
        String sep = System.getProperty("file.separator");
        return sep != null && sep.equals("/");
    }

    public static void setInitialArgments(List<String> args) {
        JNLPRuntime.checkInitialized();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AllPermission());
        }
        initialArguments = args;
    }

    public static List<String> getInitialArguments() {
        return initialArguments;
    }

    public static synchronized void markNetxRunning() {
        if (fileLock != null) {
            return;
        }
        try {
            FileInputStream is;
            FileChannel channel;
            String message = "This file is used to check if netx is running";
            File netxRunningFile = PathsAndFiles.MAIN_LOCK.getFile();
            if (!netxRunningFile.exists()) {
                FileUtils.createParentDir(netxRunningFile);
                FileUtils.createRestrictedFile(netxRunningFile, true);
                try (FileOutputStream fos = new FileOutputStream(netxRunningFile);){
                    fos.write(message.getBytes());
                }
            }
            if (!(fileLock = (channel = (is = new FileInputStream(netxRunningFile)).getChannel()).lock(0L, 1L, true)).isShared()) {
                FileLock temp = null;
                for (long pos = 1L; temp == null && pos < 0x7FFFFFFFFFFFFFFEL; ++pos) {
                    temp = channel.tryLock(pos, 1L, false);
                }
                fileLock.release();
                fileLock = temp;
            }
            if (fileLock != null && fileLock.isShared()) {
                OutputController.getLogger().log("Acquired shared lock on " + netxRunningFile.toString() + " to indicate javaws is running");
            }
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread("JNLPRuntimeShutdownHookThread"){

            @Override
            public void run() {
                JNLPRuntime.markNetxStopped();
                CacheUtil.cleanCache();
            }
        });
    }

    private static void markNetxStopped() {
        if (fileLock == null) {
            return;
        }
        try {
            fileLock.release();
            fileLock.channel().close();
            fileLock = null;
            OutputController.getLogger().log("Release shared lock on " + PathsAndFiles.MAIN_LOCK.getFullPath());
        }
        catch (IOException e) {
            OutputController.getLogger().log(e);
        }
    }

    public static void setHtml(boolean html) {
        JNLPRuntime.html = html;
    }

    public static boolean isHtml() {
        return html;
    }

    public static void setTrustAll(boolean b) {
        trustAll = b;
    }

    public static boolean isTrustAll() {
        return trustAll;
    }

    public static void setTrustNone(boolean b) {
        trustNone = b;
    }

    public static boolean isTrustNone() {
        return trustNone;
    }

    public static boolean isIgnoreHeaders() {
        return ignoreHeaders;
    }

    public static void setIgnoreHeaders(boolean ignoreHeaders) {
        JNLPRuntime.ignoreHeaders = ignoreHeaders;
    }

    public static void initStartupTracker() {
        startupTrackerMoment = System.currentTimeMillis();
    }

    public static void addStartupTrackingEntry(String message) {
        if (startupTrackerMoment > 0L) {
            long time = (System.currentTimeMillis() - startupTrackerMoment) / 1000L;
            String msg = "Startup tracker: seconds elapsed: [" + time + "], message: [" + message + "]";
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, msg);
        }
    }

    private static boolean isPluginDebug() {
        if (pluginDebug == null) {
            try {
                pluginDebug = System.getenv().containsKey("ICEDTEAPLUGIN_DEBUG");
            }
            catch (Exception ex) {
                pluginDebug = false;
                OutputController.getLogger().log(ex);
            }
        }
        return pluginDebug;
    }

    public static void exit(int i) {
        try {
            OutputController.getLogger().close();
            while (BasicExceptionDialog.areShown()) {
                Thread.sleep(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.exit(i);
    }

    public static void saveHistory(String documentBase) {
        history = history + " " + documentBase + " ";
    }

    private static String getHistory() {
        return history;
    }

    static {
        handler = null;
        indicator = null;
        updatePolicy = UpdatePolicy.ALWAYS;
        initialized = false;
        headless = false;
        headlessChecked = false;
        verify = true;
        securityEnabled = true;
        debug = false;
        pluginDebug = null;
        initMutex = new Object();
        forksAllowed = true;
        trustAll = false;
        html = false;
        trustNone = false;
        allowRedirect = false;
        offlineForced = false;
        onlineDetected = null;
        startupTrackerMoment = 0L;
        ignoreHeaders = false;
    }

    private static class DeploymentConfigurationHolder {
        private static final DeploymentConfiguration INSTANCE = DeploymentConfigurationHolder.initConfiguration();

        private DeploymentConfigurationHolder() {
        }

        private static DeploymentConfiguration initConfiguration() {
            DeploymentConfiguration config = new DeploymentConfiguration();
            try {
                config.load();
                config.copyTo(System.getProperties());
            }
            catch (ConfigurationException ex) {
                OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, Translator.R("RConfigurationError"));
                config.setLoadingException(ex);
            }
            catch (Exception t) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, t);
                OutputController.getLogger().log(OutputController.Level.WARNING_ALL, Translator.R("RFailingToDefault"));
                if (!JNLPRuntime.isHeadless()) {
                    JOptionPane.showMessageDialog(null, Translator.R("RFailingToDefault") + "\n" + t.toString());
                }
                config.resetToDefaults();
            }
            finally {
                OutputController.getLogger().startConsumer();
            }
            return config;
        }
    }
}

