/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util.math.intpoly;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import sun.security.util.math.ImmutableIntegerModuloP;
import sun.security.util.math.IntegerFieldModuloP;
import sun.security.util.math.IntegerModuloP;
import sun.security.util.math.MutableIntegerModuloP;
import sun.security.util.math.SmallValue;

public abstract class IntegerPolynomial
implements IntegerFieldModuloP {
    protected static final BigInteger TWO = BigInteger.valueOf(2L);
    protected final int numLimbs;
    private final BigInteger modulus;
    protected final int bitsPerLimb;
    private final long[] posModLimbs;
    private final int maxAdds;

    protected abstract void reduce(long[] var1);

    protected void multByInt(long[] lArray, long l) {
        int n = 0;
        while (n < lArray.length) {
            int n2 = n++;
            lArray[n2] = lArray[n2] * l;
        }
        this.reduce(lArray);
    }

    protected abstract void mult(long[] var1, long[] var2, long[] var3);

    protected abstract void square(long[] var1, long[] var2);

    IntegerPolynomial(int n, int n2, int n3, BigInteger bigInteger) {
        this.numLimbs = n2;
        this.modulus = bigInteger;
        this.bitsPerLimb = n;
        this.maxAdds = n3;
        this.posModLimbs = this.setPosModLimbs();
    }

    private long[] setPosModLimbs() {
        long[] lArray = new long[this.numLimbs];
        this.setLimbsValuePositive(this.modulus, lArray);
        return lArray;
    }

    protected int getNumLimbs() {
        return this.numLimbs;
    }

    public int getMaxAdds() {
        return this.maxAdds;
    }

    @Override
    public BigInteger getSize() {
        return this.modulus;
    }

    @Override
    public ImmutableElement get0() {
        return new ImmutableElement(false);
    }

    @Override
    public ImmutableElement get1() {
        return new ImmutableElement(true);
    }

    @Override
    public ImmutableElement getElement(BigInteger bigInteger) {
        return new ImmutableElement(bigInteger);
    }

    @Override
    public SmallValue getSmallValue(int n) {
        int n2 = 1 << this.bitsPerLimb - 1;
        if (Math.abs(n) >= n2) {
            throw new IllegalArgumentException("max magnitude is " + n2);
        }
        return new Limb(n);
    }

    protected void encode(ByteBuffer byteBuffer, int n, byte by, long[] lArray) {
        int n2 = 32 - Integer.numberOfLeadingZeros(by);
        int n3 = 8 * n + n2;
        int n4 = (n3 + this.bitsPerLimb - 1) / this.bitsPerLimb;
        if (n4 > this.numLimbs) {
            long[] lArray2 = new long[n4];
            this.encodeSmall(byteBuffer, n, by, lArray2);
            System.arraycopy(lArray2, 0, lArray, 0, lArray.length);
        } else {
            this.encodeSmall(byteBuffer, n, by, lArray);
        }
    }

    protected void encodeSmall(ByteBuffer byteBuffer, int n, byte by, long[] lArray) {
        int n2 = 0;
        long l = 0L;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            long l2 = byteBuffer.get() & 0xFF;
            if (n3 + 8 >= this.bitsPerLimb) {
                int n4 = this.bitsPerLimb - n3;
                lArray[n2++] = l += (l2 & (long)(255 >> 8 - n4)) << n3;
                l = l2 >> n4;
                n3 = 8 - n4;
                continue;
            }
            l += l2 << n3;
            n3 += 8;
        }
        if (by != 0) {
            long l3 = by & 0xFF;
            if (n3 + 8 >= this.bitsPerLimb) {
                int n5 = this.bitsPerLimb - n3;
                lArray[n2++] = l += (l3 & (long)(255 >> 8 - n5)) << n3;
                l = l3 >> n5;
            } else {
                l += l3 << n3;
            }
        }
        if (n2 < lArray.length) {
            lArray[n2++] = l;
        }
        Arrays.fill(lArray, n2, lArray.length, 0L);
        this.postEncodeCarry(lArray);
    }

    protected void encode(byte[] byArray, int n, int n2, byte by, long[] lArray) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n, n2);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.encode(byteBuffer, n2, by, lArray);
    }

    protected void postEncodeCarry(long[] lArray) {
        this.reduce(lArray);
    }

    @Override
    public ImmutableElement getElement(byte[] byArray, int n, int n2, byte by) {
        long[] lArray = new long[this.numLimbs];
        this.encode(byArray, n, n2, by, lArray);
        return new ImmutableElement(lArray, 0);
    }

    protected BigInteger evaluate(long[] lArray) {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = lArray.length - 1; i >= 0; --i) {
            bigInteger = bigInteger.shiftLeft(this.bitsPerLimb).add(BigInteger.valueOf(lArray[i]));
        }
        return bigInteger.mod(this.modulus);
    }

    protected long carryValue(long l) {
        return l + (long)(1 << this.bitsPerLimb - 1) >> this.bitsPerLimb;
    }

    protected void carry(long[] lArray, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            long l = this.carryOut(lArray, i);
            int n3 = i + 1;
            lArray[n3] = lArray[n3] + l;
        }
    }

    protected void carry(long[] lArray) {
        this.carry(lArray, 0, lArray.length - 1);
    }

    protected long carryOut(long[] lArray, int n) {
        long l = this.carryValue(lArray[n]);
        int n2 = n;
        lArray[n2] = lArray[n2] - (l << this.bitsPerLimb);
        return l;
    }

    private void setLimbsValue(BigInteger bigInteger, long[] lArray) {
        this.setLimbsValuePositive(bigInteger, lArray);
        this.carry(lArray);
    }

    protected void setLimbsValuePositive(BigInteger bigInteger, long[] lArray) {
        BigInteger bigInteger2 = BigInteger.valueOf(1 << this.bitsPerLimb);
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = bigInteger.mod(bigInteger2).longValue();
            bigInteger = bigInteger.shiftRight(this.bitsPerLimb);
        }
    }

    protected abstract void finalCarryReduceLast(long[] var1);

    protected void finalReduce(long[] lArray) {
        int n;
        for (n = 0; n < 2; ++n) {
            this.finalCarryReduceLast(lArray);
            long l = 0L;
            int n2 = 0;
            while (n2 < this.numLimbs - 1) {
                int n3 = n2;
                lArray[n3] = lArray[n3] + l;
                l = lArray[n2] >> this.bitsPerLimb;
                int n4 = n2++;
                lArray[n4] = lArray[n4] - (l << this.bitsPerLimb);
            }
            int n5 = this.numLimbs - 1;
            lArray[n5] = lArray[n5] + l;
        }
        n = 1;
        long[] lArray2 = new long[this.numLimbs];
        for (int i = this.numLimbs - 1; i >= 0; --i) {
            lArray2[i] = lArray[i] - this.posModLimbs[i];
            n *= (int)(lArray2[i] >> 63) + 1;
        }
        IntegerPolynomial.conditionalSwap(n, lArray, lArray2);
    }

    protected void decode(long[] lArray, byte[] byArray, int n, int n2) {
        int n3 = 0;
        long l = lArray[n3++];
        int n4 = 0;
        for (int i = 0; i < n2; ++i) {
            int n5 = i + n;
            if (n4 + 8 >= this.bitsPerLimb) {
                byArray[n5] = (byte)l;
                l = 0L;
                if (n3 < lArray.length) {
                    l = lArray[n3++];
                }
                int n6 = this.bitsPerLimb - n4;
                int n7 = 8 - n6;
                int n8 = n5;
                byArray[n8] = (byte)((long)byArray[n8] + ((l & (long)(255 >> n6)) << n6));
                l >>= n7;
                n4 = n7;
                continue;
            }
            byArray[n5] = (byte)l;
            l >>= 8;
            n4 += 8;
        }
    }

    protected void addLimbs(long[] lArray, long[] lArray2, long[] lArray3) {
        for (int i = 0; i < lArray3.length; ++i) {
            lArray3[i] = lArray[i] + lArray2[i];
        }
    }

    protected static void conditionalAssign(int n, long[] lArray, long[] lArray2) {
        int n2 = 0 - n;
        for (int i = 0; i < lArray.length; ++i) {
            long l = (long)n2 & (lArray[i] ^ lArray2[i]);
            lArray[i] = l ^ lArray[i];
        }
    }

    protected static void conditionalSwap(int n, long[] lArray, long[] lArray2) {
        int n2 = 0 - n;
        for (int i = 0; i < lArray.length; ++i) {
            long l = (long)n2 & (lArray[i] ^ lArray2[i]);
            lArray[i] = l ^ lArray[i];
            lArray2[i] = l ^ lArray2[i];
        }
    }

    protected void limbsToByteArray(long[] lArray, byte[] byArray) {
        long[] lArray2 = (long[])lArray.clone();
        this.finalReduce(lArray2);
        this.decode(lArray2, byArray, 0, byArray.length);
    }

    protected void addLimbsModPowerTwo(long[] lArray, long[] lArray2, byte[] byArray) {
        long[] lArray3 = (long[])lArray2.clone();
        long[] lArray4 = (long[])lArray.clone();
        this.finalReduce(lArray3);
        this.finalReduce(lArray4);
        this.addLimbs(lArray4, lArray3, lArray4);
        long l = 0L;
        int n = 0;
        while (n < this.numLimbs) {
            int n2 = n;
            lArray4[n2] = lArray4[n2] + l;
            l = lArray4[n] >> this.bitsPerLimb;
            int n3 = n++;
            lArray4[n3] = lArray4[n3] - (l << this.bitsPerLimb);
        }
        this.decode(lArray4, byArray, 0, byArray.length);
    }

    class Limb
    implements SmallValue {
        int value;

        Limb(int n) {
            this.value = n;
        }
    }

    class ImmutableElement
    extends Element
    implements ImmutableIntegerModuloP {
        protected ImmutableElement(BigInteger bigInteger) {
            super(bigInteger);
        }

        protected ImmutableElement(boolean bl) {
            super(bl);
        }

        protected ImmutableElement(long[] lArray, int n) {
            super(lArray, n);
        }

        @Override
        public ImmutableElement fixed() {
            return this;
        }
    }

    protected class MutableElement
    extends Element
    implements MutableIntegerModuloP {
        protected MutableElement(long[] lArray, int n) {
            super(lArray, n);
        }

        @Override
        public ImmutableElement fixed() {
            return new ImmutableElement((long[])this.limbs.clone(), this.numAdds);
        }

        @Override
        public void conditionalSet(IntegerModuloP integerModuloP, int n) {
            Element element = (Element)integerModuloP;
            IntegerPolynomial.conditionalAssign(n, this.limbs, element.limbs);
            this.numAdds = element.numAdds;
        }

        @Override
        public void conditionalSwapWith(MutableIntegerModuloP mutableIntegerModuloP, int n) {
            MutableElement mutableElement = (MutableElement)mutableIntegerModuloP;
            IntegerPolynomial.conditionalSwap(n, this.limbs, mutableElement.limbs);
            int n2 = this.numAdds;
            this.numAdds = mutableElement.numAdds;
            mutableElement.numAdds = n2;
        }

        @Override
        public MutableElement setValue(IntegerModuloP integerModuloP) {
            Element element = (Element)integerModuloP;
            System.arraycopy(element.limbs, 0, this.limbs, 0, element.limbs.length);
            this.numAdds = element.numAdds;
            return this;
        }

        @Override
        public MutableElement setValue(byte[] byArray, int n, int n2, byte by) {
            IntegerPolynomial.this.encode(byArray, n, n2, by, this.limbs);
            this.numAdds = 0;
            return this;
        }

        @Override
        public MutableElement setValue(ByteBuffer byteBuffer, int n, byte by) {
            IntegerPolynomial.this.encode(byteBuffer, n, by, this.limbs);
            this.numAdds = 0;
            return this;
        }

        @Override
        public MutableElement setProduct(IntegerModuloP integerModuloP) {
            Element element = (Element)integerModuloP;
            IntegerPolynomial.this.mult(this.limbs, element.limbs, this.limbs);
            this.numAdds = 0;
            return this;
        }

        @Override
        public MutableElement setProduct(SmallValue smallValue) {
            int n = ((Limb)smallValue).value;
            IntegerPolynomial.this.multByInt(this.limbs, n);
            this.numAdds = 0;
            return this;
        }

        @Override
        public MutableElement setSum(IntegerModuloP integerModuloP) {
            Element element = (Element)integerModuloP;
            if (!this.isSummand() || !element.isSummand()) {
                throw new ArithmeticException("Not a valid summand");
            }
            for (int i = 0; i < this.limbs.length; ++i) {
                this.limbs[i] = this.limbs[i] + element.limbs[i];
            }
            this.numAdds = Math.max(this.numAdds, element.numAdds) + 1;
            return this;
        }

        @Override
        public MutableElement setDifference(IntegerModuloP integerModuloP) {
            Element element = (Element)integerModuloP;
            if (!this.isSummand() || !element.isSummand()) {
                throw new ArithmeticException("Not a valid summand");
            }
            for (int i = 0; i < this.limbs.length; ++i) {
                this.limbs[i] = this.limbs[i] - element.limbs[i];
            }
            this.numAdds = Math.max(this.numAdds, element.numAdds) + 1;
            return this;
        }

        @Override
        public MutableElement setSquare() {
            IntegerPolynomial.this.square(this.limbs, this.limbs);
            this.numAdds = 0;
            return this;
        }

        @Override
        public MutableElement setAdditiveInverse() {
            for (int i = 0; i < this.limbs.length; ++i) {
                this.limbs[i] = -this.limbs[i];
            }
            return this;
        }

        @Override
        public MutableElement setReduced() {
            IntegerPolynomial.this.reduce(this.limbs);
            this.numAdds = 0;
            return this;
        }
    }

    private abstract class Element
    implements IntegerModuloP {
        protected long[] limbs;
        protected int numAdds;

        public Element(BigInteger bigInteger) {
            this.limbs = new long[IntegerPolynomial.this.numLimbs];
            this.setValue(bigInteger);
        }

        public Element(boolean bl) {
            this.limbs = new long[IntegerPolynomial.this.numLimbs];
            this.limbs[0] = bl ? 1L : 0L;
            this.numAdds = 0;
        }

        private Element(long[] lArray, int n) {
            this.limbs = lArray;
            this.numAdds = n;
        }

        private void setValue(BigInteger bigInteger) {
            IntegerPolynomial.this.setLimbsValue(bigInteger, this.limbs);
            this.numAdds = 0;
        }

        @Override
        public IntegerFieldModuloP getField() {
            return IntegerPolynomial.this;
        }

        @Override
        public BigInteger asBigInteger() {
            return IntegerPolynomial.this.evaluate(this.limbs);
        }

        @Override
        public MutableElement mutable() {
            return new MutableElement((long[])this.limbs.clone(), this.numAdds);
        }

        protected boolean isSummand() {
            return this.numAdds < IntegerPolynomial.this.maxAdds;
        }

        @Override
        public ImmutableElement add(IntegerModuloP integerModuloP) {
            int n;
            Element element = (Element)integerModuloP;
            if (!this.isSummand() || !element.isSummand()) {
                throw new ArithmeticException("Not a valid summand");
            }
            long[] lArray = new long[this.limbs.length];
            for (n = 0; n < this.limbs.length; ++n) {
                lArray[n] = this.limbs[n] + element.limbs[n];
            }
            n = Math.max(this.numAdds, element.numAdds) + 1;
            return new ImmutableElement(lArray, n);
        }

        @Override
        public ImmutableElement additiveInverse() {
            long[] lArray = new long[this.limbs.length];
            for (int i = 0; i < this.limbs.length; ++i) {
                lArray[i] = -this.limbs[i];
            }
            ImmutableElement immutableElement = new ImmutableElement(lArray, this.numAdds);
            return immutableElement;
        }

        protected long[] cloneLow(long[] lArray) {
            long[] lArray2 = new long[IntegerPolynomial.this.numLimbs];
            this.copyLow(lArray, lArray2);
            return lArray2;
        }

        protected void copyLow(long[] lArray, long[] lArray2) {
            System.arraycopy(lArray, 0, lArray2, 0, lArray2.length);
        }

        @Override
        public ImmutableElement multiply(IntegerModuloP integerModuloP) {
            Element element = (Element)integerModuloP;
            long[] lArray = new long[this.limbs.length];
            IntegerPolynomial.this.mult(this.limbs, element.limbs, lArray);
            return new ImmutableElement(lArray, 0);
        }

        @Override
        public ImmutableElement square() {
            long[] lArray = new long[this.limbs.length];
            IntegerPolynomial.this.square(this.limbs, lArray);
            return new ImmutableElement(lArray, 0);
        }

        @Override
        public void addModPowerTwo(IntegerModuloP integerModuloP, byte[] byArray) {
            Element element = (Element)integerModuloP;
            if (!this.isSummand() || !element.isSummand()) {
                throw new ArithmeticException("Not a valid summand");
            }
            IntegerPolynomial.this.addLimbsModPowerTwo(this.limbs, element.limbs, byArray);
        }

        @Override
        public void asByteArray(byte[] byArray) {
            if (!this.isSummand()) {
                throw new ArithmeticException("Not a valid summand");
            }
            IntegerPolynomial.this.limbsToByteArray(this.limbs, byArray);
        }
    }
}

