/*
 * Decompiled with CFR 0.152.
 */
package org.islandoftex.arara.filehandling;

import com.uchuhimo.konf.Config;
import com.uchuhimo.konf.Item;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.islandoftex.arara.Arara;
import org.islandoftex.arara.configuration.AraraSpec;
import org.islandoftex.arara.filehandling.FileHandlingUtils;
import org.islandoftex.arara.filehandling.FileSearchingUtils;
import org.islandoftex.arara.localization.LanguageController;
import org.islandoftex.arara.localization.Messages;
import org.islandoftex.arara.model.AraraException;
import org.islandoftex.arara.model.FileType;
import org.islandoftex.arara.utils.CommonUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nJ*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\u00042\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005J\u0018\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\b2\b\b\u0002\u0010\u000f\u001a\u00020\u0005\u00a8\u0006\u0014"}, d2={"Lorg/islandoftex/arara/filehandling/FileSearchingUtils;", "", "()V", "listFilesByExtensions", "", "Ljava/io/File;", "directory", "extensions", "", "recursive", "", "listFilesByPatterns", "patterns", "lookupFile", "reference", "workingDirectory", "registerFileAttributes", "", "file", "resolveFile", "application"})
public final class FileSearchingUtils {
    public static final FileSearchingUtils INSTANCE;

    @NotNull
    public final List<File> listFilesByExtensions(@NotNull File directory, @NotNull List<String> extensions, boolean recursive) {
        List<File> list2;
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        Intrinsics.checkParameterIsNotNull(extensions, "extensions");
        try {
            List<File> list3;
            if (recursive) {
                list2 = FilesKt.walkTopDown(directory);
                boolean bl = false;
                list3 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter(list2, listFilesByExtensions.1.INSTANCE), (Function1)new Function1<File, Boolean>(extensions){
                    final /* synthetic */ List $extensions;

                    public final boolean invoke(@NotNull File it) {
                        Intrinsics.checkParameterIsNotNull(it, "it");
                        return this.$extensions.contains(FilesKt.getExtension(it));
                    }
                    {
                        this.$extensions = list2;
                        super(1);
                    }
                }));
            } else {
                File[] fileArray = directory.listFiles(new FileFilter(extensions){
                    final /* synthetic */ List $extensions;

                    public final boolean accept(File it) {
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull(file2, "it");
                        return this.$extensions.contains(FilesKt.getExtension(file2));
                    }
                    {
                        this.$extensions = list2;
                    }
                });
                if (fileArray == null) {
                    Intrinsics.throwNpe();
                }
                list3 = ArraysKt.toList(fileArray);
            }
            list2 = list3;
        }
        catch (Exception _) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<File> listFilesByPatterns(@NotNull File directory, @NotNull List<String> patterns, boolean recursive) {
        List<File> list2;
        Intrinsics.checkParameterIsNotNull(directory, "directory");
        Intrinsics.checkParameterIsNotNull(patterns, "patterns");
        try {
            List<File> list3;
            void $this$mapTo$iv$iv;
            Object $this$map$iv = patterns;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PathMatcher pathMatcher = FileSystems.getDefault().getPathMatcher("glob:" + (String)it);
                collection.add(pathMatcher);
            }
            List pathMatcher = (List)destination$iv$iv;
            if (recursive) {
                $this$map$iv = FilesKt.walkTopDown(directory);
                boolean bl = false;
                list3 = SequencesKt.toList(SequencesKt.filter(SequencesKt.filter($this$map$iv, listFilesByPatterns.1.INSTANCE), (Function1)new Function1<File, Boolean>(pathMatcher){
                    final /* synthetic */ List $pathMatcher;

                    public final boolean invoke(@NotNull File file2) {
                        boolean bl;
                        block3: {
                            Intrinsics.checkParameterIsNotNull(file2, "file");
                            Iterable $this$any$iv = this.$pathMatcher;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    PathMatcher it = (PathMatcher)element$iv;
                                    boolean bl2 = false;
                                    Path path = file2.toPath();
                                    Intrinsics.checkExpressionValueIsNotNull(path, "file.toPath()");
                                    if (!it.matches(path.getFileName())) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                    {
                        this.$pathMatcher = list2;
                        super(1);
                    }
                }));
            } else {
                File[] fileArray = directory.listFiles(new FileFilter(pathMatcher){
                    final /* synthetic */ List $pathMatcher;

                    public final boolean accept(@NotNull File file2) {
                        boolean bl;
                        block3: {
                            Intrinsics.checkParameterIsNotNull(file2, "file");
                            Iterable $this$any$iv = this.$pathMatcher;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    PathMatcher it = (PathMatcher)element$iv;
                                    boolean bl2 = false;
                                    Path path = file2.toPath();
                                    Intrinsics.checkExpressionValueIsNotNull(path, "file.toPath()");
                                    if (!it.matches(path.getFileName())) continue;
                                    bl = true;
                                    break block3;
                                }
                                bl = false;
                            }
                        }
                        return bl;
                    }
                    {
                        this.$pathMatcher = list2;
                    }
                });
                if (fileArray == null) {
                    Intrinsics.throwNpe();
                }
                list3 = ArraysKt.toList(fileArray);
            }
            list2 = list3;
        }
        catch (Exception _) {
            boolean bl = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final File resolveFile(@NotNull String reference, @NotNull File workingDirectory) throws AraraException {
        Intrinsics.checkParameterIsNotNull(reference, "reference");
        Intrinsics.checkParameterIsNotNull(workingDirectory, "workingDirectory");
        File file2 = this.lookupFile(reference, workingDirectory);
        if (file2 == null) {
            throw (Throwable)new AraraException(LanguageController.INSTANCE.getMessage((Enum)Messages.ERROR_DISCOVERFILE_FILE_NOT_FOUND, reference, CommonUtils.INSTANCE.getFileTypesList()));
        }
        return file2;
    }

    public static /* synthetic */ File resolveFile$default(FileSearchingUtils fileSearchingUtils, String string, File file2, int n, Object object) throws AraraException {
        if ((n & 2) != 0) {
            File file3 = ((Path)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getWorkingDirectory())).toFile();
            Intrinsics.checkExpressionValueIsNotNull(file3, "Arara.config[AraraSpec.E\u2026orkingDirectory].toFile()");
            file2 = file3;
        }
        return fileSearchingUtils.resolveFile(string, file2);
    }

    private final File lookupFile(String reference, File workingDirectory) throws AraraException {
        Object v5;
        block8: {
            Object object;
            FileType it;
            Iterable iterable;
            Iterable $this$mapTo$iv$iv;
            Object element$iv;
            Iterator iterator2;
            boolean $i$f$firstOrNull;
            Object $this$firstOrNull$iv;
            Set types = (Set)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getFileTypes());
            File file2 = FilesKt.resolve(workingDirectory, reference);
            String name = file2.getName();
            File parent = FileHandlingUtils.INSTANCE.getParentCanonicalFile(file2);
            String string = name;
            Intrinsics.checkExpressionValueIsNotNull(string, "name");
            File testFile = FilesKt.resolve(parent, string);
            if (testFile.exists() && testFile.isFile()) {
                Object v2;
                block7: {
                    $this$firstOrNull$iv = types;
                    $i$f$firstOrNull = false;
                    iterator2 = $this$firstOrNull$iv.iterator();
                    while (iterator2.hasNext()) {
                        element$iv = iterator2.next();
                        FileType it2 = (FileType)element$iv;
                        boolean bl = false;
                        String string2 = testFile.toString();
                        Intrinsics.checkExpressionValueIsNotNull(string2, "testFile.toString()");
                        if (!StringsKt.endsWith$default(string2, "." + it2.getExtension(), false, 2, null)) continue;
                        v2 = element$iv;
                        break block7;
                    }
                    v2 = null;
                }
                FileType fileType = v2;
                if (fileType != null) {
                    $this$firstOrNull$iv = fileType;
                    $i$f$firstOrNull = false;
                    boolean bl = false;
                    Object it3 = $this$firstOrNull$iv;
                    boolean bl2 = false;
                    return testFile;
                }
            }
            Iterable $this$map$iv = types;
            boolean $i$f$map = false;
            iterator2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                FileType fileType = (FileType)item$iv$iv;
                iterable = destination$iv$iv;
                boolean bl = false;
                object = FilesKt.resolve(parent, name + '.' + it.getExtension());
                iterable.add(object);
            }
            $this$map$iv = types;
            iterable = (List)destination$iv$iv;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (FileType)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                String string3 = StringsKt.removeSuffix(name, (CharSequence)".");
                StringBuilder stringBuilder = new StringBuilder();
                File file3 = parent;
                boolean bl3 = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string5 = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                File file4 = FilesKt.resolve(file3, stringBuilder.append(string5).append('.').append(it.getExtension()).toString());
                object.add(file4);
            }
            object = (List)destination$iv$iv;
            $this$firstOrNull$iv = CollectionsKt.union(iterable, (Iterable)object);
            $i$f$firstOrNull = false;
            iterator2 = $this$firstOrNull$iv.iterator();
            while (iterator2.hasNext()) {
                element$iv = iterator2.next();
                File it4 = (File)element$iv;
                boolean bl = false;
                if (!(it4.exists() && it4.isFile())) continue;
                v5 = element$iv;
                break block8;
            }
            v5 = null;
        }
        return v5;
    }

    /*
     * WARNING - void declaration
     */
    public final void registerFileAttributes(@NotNull File file2) {
        Object element$iv2;
        Config config;
        Item item2;
        block1: {
            void $this$first$iv;
            Intrinsics.checkParameterIsNotNull(file2, "file");
            Iterable iterable = (Iterable)Arara.INSTANCE.getConfig().get(AraraSpec.Execution.INSTANCE.getFileTypes());
            item2 = AraraSpec.Execution.INSTANCE.getFilePattern();
            config = Arara.INSTANCE.getConfig();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                FileType it = (FileType)element$iv2;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getExtension(), FilesKt.getExtension(file2))) continue;
                break block1;
            }
            throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object t = element$iv2;
        config.set(item2, ((FileType)t).getPattern());
        Arara.INSTANCE.getConfig().set(AraraSpec.Execution.INSTANCE.getReference(), file2);
    }

    private FileSearchingUtils() {
    }

    static {
        FileSearchingUtils fileSearchingUtils;
        INSTANCE = fileSearchingUtils = new FileSearchingUtils();
    }
}

